package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import net.minecraft.class_10225;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2283.class)
public abstract class ChorusPlantMixin extends class_2429 {

  protected ChorusPlantMixin(float radius, class_2251 settings) {
    super(radius, settings);
  }

  @Inject(method = "getStateForNeighborUpdate", at = @At("HEAD"), cancellable = true)
  public void checkBelowForEndSoil(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random,
      CallbackInfoReturnable<class_2680> cir) {
    if ((state.method_26184(world, pos))
        && direction == class_2350.field_11033
        && neighborState.method_26164(LighterEndTags.END_SOIL)) {
      cir.setReturnValue(state.method_11657(field_11329.get(direction), true));
      cir.cancel();
    }
  }

  @Inject(method = "withConnectionProperties", at = @At("RETURN"), cancellable = true)
  private static void withConnectedEndSoil(
      class_1922 world, class_2338 pos, class_2680 state, CallbackInfoReturnable<class_2680> cir
  ) {
    class_2680 down = world.method_8320(pos.method_10074());
    class_2248 block = state.method_26204();
    cir.setReturnValue(
        cir.getReturnValue().method_47968(
            field_11330,
            down.method_27852(block)
                || down.method_27852(class_2246.field_10528)
                || down.method_27852(class_2246.field_10471)
                || down.method_26164(LighterEndTags.END_SOIL)
        )
    );
  }

  @Inject(method = "canPlaceAt", at = @At("HEAD"), cancellable = true)
  public void placeOnEndSoil(
      class_2680 state,
      class_4538 world,
      class_2338 pos,
      CallbackInfoReturnable<Boolean> cir
  ) {
    if (world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
      cir.setReturnValue(true);
      cir.cancel();
    }
    for (class_2350 direction : class_2350.class_2353.field_11062) {
      class_2338 horizontal = pos.method_10093(direction);
      if (world.method_8320(horizontal).method_27852(class_2246.field_10021)) {
        class_2680 diagonal = world.method_8320(horizontal.method_10074());
        if (
            diagonal.method_27852(class_2246.field_10021)
                || diagonal.method_27852(class_2246.field_10471)
                || diagonal.method_26164(
                LighterEndTags.END_SOIL)
        ) {
          cir.setReturnValue(true);
          cir.cancel();
          break;
        }
      }
    }
  }
}
