package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndLootTables;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_8153;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8153.class)
public abstract class EndMossSplootMixin extends class_1309 {

  protected EndMossSplootMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
    super(entityType, world);
  }

  @Shadow
  protected abstract class_2338 getDigPos();

  @Accessor("FINISH_DIG_TIME")
  public static class_2940<Integer> getFinishDigTime() {
    throw new AssertionError();
  }

  @Inject(method = "dropSeeds", at = @At("HEAD"), cancellable = true)
  public void dropEndSplootLoot(CallbackInfo ci) {
    if (this.method_73183() instanceof class_3218 serverWorld
        && this.field_6011.method_12789(getFinishDigTime()) == this.field_6012) {
      class_2338 blockPos = this.getDigPos();
      if (serverWorld.method_8320(blockPos.method_10074()).method_27852(LighterEndBlocks.END_MOSS)) {
        this.method_64169(serverWorld, LighterEndLootTables.END_MOSS_SPLOOT_LOOT,
            (serverWorldx, itemStack) -> {
              class_1542 itemEntity = new class_1542(this.method_73183(), blockPos.method_10263(),
                  blockPos.method_10264(), blockPos.method_10260(), itemStack);
              itemEntity.method_6988();
              serverWorldx.method_8649(itemEntity);
            });
        this.method_5783(class_3417.field_42600, 1.0F, 1.0F);
        ci.cancel();
      }
    }
  }

}
