package io.github.openbagtwo.lighterend.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.world.LighterEndConfiguredFeatures;
import io.github.openbagtwo.lighterend.world.gen.LighterEndWorldGen;
import java.util.Map;
import net.minecraft.class_11545;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_27;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_4766;
import net.minecraft.class_5217;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5322;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(MinecraftServer.class)
public abstract class EndSpawnMixin {

  @Unique
  private static final float END_SPAWN_RADIUS = 10_000F;

  @Unique
  private class_3218 theEnd = null;

  @Shadow
  public abstract class_3218 getWorld(class_5321<class_1937> key);

  @Accessor("worlds")
  abstract Map<class_5321<class_1937>, class_3218> getWorldz();

  @Shadow
  public abstract class_11545 getChunkLoadProgress();

  @Shadow
  public abstract class_5219 getSaveProperties();

  @Accessor
  abstract class_32.class_5143 getSession();

  @Inject(
      method = "createWorlds",
      at = @At(
          value = "INVOKE",
          target = "Lnet/minecraft/command/DataCommandStorage;<init>(Lnet/minecraft/world/PersistentStateManager;)V"
      )
  )
  public void setEndSpawn(
      CallbackInfo ci,
      @Local class_5268 serverWorldProperties,
      @Local class_2378<class_5363> registry,
      @Local class_5285 generatorOptions
  ) {
    if (!LighterEnd.CONFIG.enableEndSpawn()) {
      return;
    }
    if (serverWorldProperties.method_222()) {
      return;
    }

    class_5363 endSettings = registry.method_29107(class_5363.field_25414);

    if (endSettings == null) {
      return;
    }

    this.theEnd = loadTheEnd(
        new class_27(
            this.getSaveProperties(),
            serverWorldProperties
        ),
        endSettings,
        class_4543.method_27984(generatorOptions.method_28028())
    );
    this.getWorldz().put(class_1937.field_25181, this.theEnd);

    setEndSpawn(
        this.theEnd,
        serverWorldProperties,
        this.getChunkLoadProgress()
    );
    serverWorldProperties.method_223(true);
  }

  @Inject(method = "createWorlds", at = @At("TAIL"))
  public void reInsertOurEnd(CallbackInfo ci) {
    if (this.theEnd != null) {
      this.getWorldz().put(class_1937.field_25181, this.theEnd);
      this.theEnd = null;
    }
  }


  private class_3218 loadTheEnd(
      class_27 unmodifiableLevelProperties,
      class_5363 dimensionOptions,
      long biomeSeed
  ) {

    if (LighterEnd.CONFIG.generateBiomes()) {
      class_2794 defaultChunkGen = dimensionOptions.comp_1013();
      class_1966 defaultBiomes = defaultChunkGen.method_12098();
      if (defaultBiomes instanceof class_4766 noiseBiomeSource
          && defaultChunkGen instanceof class_3754 noiseChunkGen) {
        class_1966 patchedBiomes = LighterEndWorldGen.addBiomesToNoiseSource(
            ((BiomeAccessor) noiseBiomeSource).accessBiomeEntries(),
            ((MinecraftServer) (Object) this).method_30611().method_30530(
                class_7924.field_41236)
        );
        dimensionOptions = new class_5363(
            dimensionOptions.comp_1012(),
            new class_3754(patchedBiomes, noiseChunkGen.method_41541())
        );
      }
    }

    return new class_3218(
        (MinecraftServer) (Object) this,
        class_156.method_18349(),
        this.getSession(),
        unmodifiableLevelProperties,
        class_1937.field_25181,
        dimensionOptions,
        false,
        biomeSeed,
        ImmutableList.of(),
        false,
        null
    );
  }

  private static void setEndSpawn(
      class_3218 world,
      class_5268 worldProperties,
      class_11545 loadProgress
  ) {

    class_3215 serverChunkManager = world.method_14178();

    class_1923 chunkPos;
    int y;
    while (true) {
      float angle = class_3532.method_15344(world.method_8409(), 0, class_3532.field_29846);
      chunkPos = new class_1923(
          new class_2338(
              Math.round(END_SPAWN_RADIUS * class_3532.method_15362(angle)),
              64,
              Math.round(END_SPAWN_RADIUS * class_3532.method_15374(angle)))
      );
      loadProgress.method_72281(class_11545.class_11546.field_61106, 0);
      loadProgress.method_72279(world.method_27983(), chunkPos);
      y = serverChunkManager.method_12129().method_12100(world);
      if (y < world.method_31607()) {
        class_2338 blockPos = chunkPos.method_8323();
        y = world.method_8624(class_2902.class_2903.field_13202, blockPos.method_10263() + 8, blockPos.method_10260() + 8);
      }
      if (
          y > 50 && !world.method_23753(chunkPos.method_8323().method_10069(8, y, 8))
              .method_40220(LighterEndTags.INVALID_SPAWN_BIOMES)
      ) {
        break;
      }
    }

    worldProperties.method_187(class_5217.class_12064.method_74895(world.method_27983(),
        chunkPos.method_8323().method_10069(8, y, 8), 0.0F, 0.0F));
    int j = 0;
    int k = 0;
    int l = 0;
    int m = -1;

    for (int n = 0; n < class_3532.method_34954(11); n++) {
      if (j >= -5 && j <= 5 && k >= -5 && k <= 5) {
        class_2338 blockPos2 = class_5322.method_29196(world,
            new class_1923(chunkPos.field_9181 + j, chunkPos.field_9180 + k));
        if (blockPos2 != null) {
          worldProperties.method_187(
              class_5217.class_12064.method_74895(world.method_27983(), blockPos2, 0.0F, 0.0F));
          break;
        }
      }

      if (j == k || j < 0 && j == -k || j > 0 && j == 1 - k) {
        int o = l;
        l = -m;
        m = o;
      }

      j += l;
      k += m;
    }

    world.method_30349()
        .method_46759(class_7924.field_41239)
        .flatMap(
            featureRegistry -> featureRegistry.method_46746(
                LighterEndConfiguredFeatures.STARTER_CHEST))
        .ifPresent(
            feature -> feature.comp_349()
                .method_12862(world, serverChunkManager.method_12129(), world.field_9229,
                    worldProperties.method_74893().method_74897())
        );

    loadProgress.method_72280(class_11545.class_11546.field_61106);

  }


}
