package io.github.openbagtwo.lighterend.mixin;

import io.github.openbagtwo.lighterend.LighterEnd;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_7134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public abstract class GravityStrengthMixin {

  @Shadow
  public abstract class_1937 getEntityWorld();

  @Inject(method = "getFinalGravity", at = @At("RETURN"), cancellable = true)
  public void applyEndGravity(CallbackInfoReturnable<Double> cir) {
    if (
        LighterEnd.CONFIG.disableEndGravityWhileFlying()
            && (class_1297) (Object) this instanceof class_1309 player
    ) {
      if (player.method_6128()) {
        return;
      }
    }
    double endGravity = LighterEnd.CONFIG.getEndGravity();
    if (
        endGravity >= 0.0
            && class_7134.field_37668.equals(
            this.getEntityWorld().method_40134().method_40230().orElse(null)
        )
    ) {
      cir.setReturnValue(cir.getReturnValue() * endGravity);
    }
  }

}
