package io.github.openbagtwo.lighterend.mobs;

import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dragonfly extends class_1429 implements class_1432 {

  public Dragonfly(class_1299<Dragonfly> entityType, class_1937 world) {
    super(entityType, world);
    this.field_6207 = new class_1331(this, 20, true);
    this.field_6206 = new DragonflyLookControl(this);
    this.method_5941(class_7.field_18, -1.0F);
    this.method_5941(class_7.field_9, -1.0F);
    this.field_6194 = 1;
  }

  public static class_5132.class_5133 createAttributes() {
    return class_1429.method_61457()
        .method_26868(class_5134.field_23716, 8.0D)
        .method_26868(class_5134.field_23717, 16.0D)
        .method_26868(class_5134.field_23720, 1.0D)
        .method_26868(class_5134.field_23719, 0.1D);
  }

  @Override
  public boolean method_5931() {
    return true;
  }

  @Override
  protected @NotNull class_1408 method_5965(class_1937 world) {
    class_1407 birdNavigation = new class_1407(this, world) {
      public boolean method_6333(class_2338 pos) {
        class_2680 state = this.field_6677.method_8320(pos);
        return state.method_26215() || !state.method_51366();
      }

      public void method_6360() {
        super.method_6360();
      }
    };
    birdNavigation.method_70687(false);
    birdNavigation.method_6354(false);
    return birdNavigation;
  }

  @Override
  public float method_6144(class_2338 pos, class_4538 world) {
    return world.method_8320(pos).method_26215() ? 10.0F : 0.0F;
  }

  @Override
  public boolean method_6481(class_1799 itemStack) {
    return false;
  }

  @Override
  protected void method_5959() {
    this.field_6201.method_6277(1, new class_1347(this));
    this.field_6201.method_6277(2, new class_1341(this, 1.0D));
    this.field_6201.method_6277(3, new class_1353(this, 1.0D));
    this.field_6201.method_6277(4, new WanderAroundGoal());
  }

  @Override
  public boolean method_5810() {
    return false;
  }

  @Override
  protected void method_5623(double heightDifference, boolean onGround, class_2680 state,
      class_2338 landedPosition) {
  }

  @Override
  protected class_1297.@NotNull class_5799 method_33570() {
    return class_1297.class_5799.field_28632;
  }

  @Override
  public boolean method_6581() {
    return !this.method_24828();
  }

  @Override
  public boolean method_5740() {
    return true;
  }

  @Override
  public class_3414 method_5994() {
    return LighterEndSounds.DRAGONFLY_IDLE;
  }

  @Nullable
  protected class_3414 method_6011(class_1282 source) {
    return LighterEndSounds.DRAGONFLY_HURT;
  }

  @Nullable
  protected class_3414 method_6002() {
    return LighterEndSounds.DRAGONFLY_DEATH;
  }

  @Override
  protected float method_6107() {
    return class_3532.method_15344(field_5974, 0.25F, 0.5F);
  }

  static class DragonflyLookControl extends class_1333 {

    DragonflyLookControl(class_1308 entity) {
      super(entity);
    }

    protected boolean method_20433() {
      return true;
    }
  }

  class WanderAroundGoal extends class_1352 {

    WanderAroundGoal() {
      this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
      return Dragonfly.this.field_6189.method_6357()
          && Dragonfly.this.field_5974.method_43048(10) == 0;
    }

    public boolean method_6266() {
      return Dragonfly.this.field_6189.method_23966();
    }

    public void method_6269() {
      class_243 vec3d = this.getRandomLocation();
      if (vec3d != null) {
        class_2338 pos = new class_2338((int) vec3d.field_1352, (int) vec3d.field_1351, (int) vec3d.field_1350);
        try {
          class_11 path = Dragonfly.this.field_6189.method_6348(pos, 1);
          if (path != null) {
            Dragonfly.this.field_6189.method_6334(path, 1.0D);
          }
        } catch (Exception e) {
        }
      }
      super.method_6269();
    }

    private class_243 getRandomLocation() {
      int h = PosInfo.downRay(Dragonfly.this.method_73183(),
          Dragonfly.this.method_24515(), 16);
      class_243 rotation = Dragonfly.this.method_5828(0.0F);
      class_243 airPos = class_5533.method_31524(Dragonfly.this, 8, 7, rotation.field_1352, rotation.field_1350,
          1.5707964F, 3, 1);
      if (airPos != null) {
        if (isInVoid(airPos)) {
          for (int i = 0; i < 8; i++) {
            airPos = class_5533.method_31524(
                Dragonfly.this,
                16,
                7,
                rotation.field_1352,
                rotation.field_1350,
                MathUtils.PI2,
                3,
                1
            );
            if (airPos != null && !isInVoid(airPos)) {
              return airPos;
            }
          }
          return null;
        }
        if (h > 5 && airPos.method_10214() >= Dragonfly.this.method_24515().method_10264()) {
          airPos = new class_243(airPos.field_1352, airPos.field_1351 - h * 0.5, airPos.field_1350);
        }
        return airPos;
      }
      return class_5530.method_31504(
          Dragonfly.this,
          8,
          4,
          -2,
          rotation.field_1352,
          rotation.field_1350,
          1.5707963705062866D
      );
    }

    private boolean isInVoid(class_243 pos) {
      int h = PosInfo.downRay(
          Dragonfly.this.method_73183(),
          new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350),
          128
      );
      return h > 100;
    }
  }

  @Override
  public class_1296 method_5613(class_3218 world, class_1296 entity) {
    return LighterEndMobs.DRAGONFLY.mob.method_5883(world, class_3730.field_16466);
  }

  @Override
  public boolean method_5974(double d) {
    return !this.method_16914();
  }
}
