package io.github.openbagtwo.lighterend.mobs;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.blocks.entities.SilkMothNestEntity;
import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5530;
import net.minecraft.class_5531;
import net.minecraft.class_5533;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class SilkMoth extends class_1429 implements class_1432 {

  /**
   * the distance beyond which the moth will look for a new hive
   */
  public static double MAX_DISTANCE_FROM_HIVE = 48;

  /**
   * the maximum number of ticks a moth is allowed to search for a hive
   */
  public static int MAX_TICKS_TO_FIND_HIVE = 200;

  public static int MIN_TICKS_BETWEEN_ENTERING_HIVE = 2400;

  @Nullable
  protected class_2338 hivePos;

  protected int ticksLeftUntilEnterHive;
  protected int ticksLeftUntilFindHive;
  protected int ticksInsideWater;

  protected MoveToHiveGoal moveToHiveGoal;


  public SilkMoth(class_1299<? extends SilkMoth> entityType, class_1937 world) {
    super(entityType, world);
    this.field_6207 = new class_1331(this, 20, true);
    this.field_6206 = new class_1333(this);
    this.method_5941(class_7.field_9, -1.0F);
    this.method_5941(class_7.field_18, -1.0F);
    this.method_5941(class_7.field_4, 16.0F);
    this.method_5941(class_7.field_21516, -1.0F);
    this.method_5941(class_7.field_10, -1.0F);
    this.field_6194 = 1;
  }

  public static class_5132.class_5133 createAttributes() {
    return class_1429.method_61457()
        .method_26868(class_5134.field_23716, 2.0D)
        .method_26868(class_5134.field_23717, 16.0D)
        .method_26868(class_5134.field_23720, 0.4D)
        .method_26868(class_5134.field_23719, 0.1D);
  }

  @Override
  protected class_1408 method_5965(class_1937 world) {
    class_1407 birdNavigation = new class_1407(this, world) {
      @Override
      public boolean method_6333(class_2338 pos) {
        class_2680 state = this.field_6677.method_8320(pos);
        return !state.method_26215();
      }

    };
    birdNavigation.method_70687(false);
    birdNavigation.method_6354(false);
    birdNavigation.method_61439(48.0F);
    return birdNavigation;
  }

  @Override
  public float method_6144(class_2338 pos, class_4538 world) {
    return world.method_8320(pos).method_26215() ? 10.0F : 0.0F;
  }

  @Override
  protected void method_5959() {
    this.field_6201.method_6277(0, new EnterHiveGoal());
    this.field_6201.method_6277(1, new class_1341(this, 1.0));
    this.field_6201.method_6277(
        2,
        new class_1391(this, 1.25, class_1856.method_8091(LighterEndBlocks.TENANEA_FLOWER), false)
    );
    this.field_6201.method_6277(2, new ValidateHiveGoal());
    this.field_6201.method_6277(3, new class_1353(this, 1.25));
    this.field_6201.method_6277(3, new FindHiveGoal());
    this.moveToHiveGoal = new MoveToHiveGoal();
    this.field_6201.method_6277(3, moveToHiveGoal);
    this.field_6201.method_6277(4, new WanderAroundGoal());
    this.field_6201.method_6277(5, new class_1347(this));
  }

  @Override
  public void method_5652(class_11372 view) {
    super.method_5652(view);
    if (this.hivePos != null) {
      view.method_71477("hive_pos", class_2338.field_25064, this.hivePos);
    }
  }

  @Override
  protected void method_5749(class_11368 view) {
    super.method_5749(view);
    this.hivePos = view.method_71426("hive_pos", class_2338.field_25064).orElse(null);
  }

  @Override
  protected void method_5958(class_3218 world) {
    if (this.method_5799()) {
      this.ticksInsideWater++;
    } else {
      this.ticksInsideWater = 0;
    }

    if (this.ticksInsideWater > 20) {
      this.method_64397(world, this.method_48923().method_48824(), 1.0F);
    }
  }

  @Override
  public void method_6007() {
    super.method_6007();
    if (!this.method_73183().method_8608()) {
      if (this.ticksLeftUntilEnterHive > 0) {
        this.ticksLeftUntilEnterHive--;
      }

      if (this.ticksLeftUntilFindHive > 0) {
        this.ticksLeftUntilFindHive--;
      }

      if (this.field_6012 % 20 == 0 && this.getHive() == null) {
        this.hivePos = null;
      }
    }
  }

  @Override
  public boolean method_6481(class_1799 itemStack) {
    return itemStack.method_31574(LighterEndBlocks.TENANEA_FLOWER.method_8389());
  }

  @Override
  protected void method_5623(double heightDifference, boolean onGround, class_2680 state,
      class_2338 landedPosition) {
  }

  @Override
  protected class_1297.class_5799 method_33570() {
    return class_1297.class_5799.field_28632;
  }

  @Override
  public boolean method_5931() {
    return true;
  }

  @Override
  public boolean method_6581() {
    return !this.method_24828();
  }

  @Override
  public boolean method_5740() {
    return true;
  }

  @Override
  public class_1296 method_5613(class_3218 world, class_1296 entity) {
    return LighterEndMobs.SILK_MOTH.mob.method_5883(world, class_3730.field_16466);
  }

  @Nullable
  SilkMothNestEntity getHive() {
    if (this.hivePos == null) {
      return null;
    }
    if (!this.hivePos.method_19771(this.method_24515(), MAX_DISTANCE_FROM_HIVE)) {
      return null;
    }
    return this.method_73183().method_35230(
        this.hivePos, LighterEndBlockEntities.SILK_MOTH_NEST
    ).orElse(null);

  }

  public boolean canEnterHive() {
    if (this.ticksLeftUntilEnterHive > 0) {
      return false;
    }
    SilkMothNestEntity hive = this.getHive();
    return hive == null || !hive.isNearFire();  // if the hive doesn't exist, then it's not on fire
  }

  public void setHive(class_2338 hivePos) {
    this.hivePos = hivePos;
  }

  public void clearHivePos() {
    this.hivePos = null;
    this.ticksLeftUntilFindHive = MAX_TICKS_TO_FIND_HIVE;
  }

  public void resetCannotEnterHiveTicks() {
    this.ticksLeftUntilEnterHive = MIN_TICKS_BETWEEN_ENTERING_HIVE;
  }

  protected void startMovingTo(class_2338 pos) {
    class_243 vec3d = class_243.method_24955(pos);
    int i = 0;
    class_2338 blockPos = this.method_24515();
    int j = (int) vec3d.field_1351 - blockPos.method_10264();
    if (j > 2) {
      i = 4;
    } else if (j < -2) {
      i = -4;
    }

    int k = 6;
    int l = 8;
    int m = blockPos.method_19455(pos);
    if (m < 15) {
      k = m / 2;
      l = m / 2;
    }

    class_243 vec3d2 = class_5531.method_31508(this, k, l, i, vec3d, (float) (Math.PI / 10));
    if (vec3d2 != null) {
      this.field_6189.method_23964(0.5F);
      this.field_6189.method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, 1.0);
    }
  }

  // AI Goals

  class EnterHiveGoal extends class_1352 {

    @Override
    public boolean method_6264() {
      if (
          SilkMoth.this.hivePos != null && SilkMoth.this.canEnterHive()
              && SilkMoth.this.hivePos.method_19769(SilkMoth.this.method_73189(), 2.0)
      ) {
        SilkMothNestEntity nest = SilkMoth.this.getHive();
        if (nest != null && nest.getOccupancy() < SilkMothNestEntity.MAX_MOTH_COUNT) {
          return true;
        }
        SilkMoth.this.hivePos = null;
      }
      return false;
    }

    @Override
    public boolean method_6266() {
      return false;
    }

    @Override
    public void method_6269() {
      SilkMothNestEntity nest = SilkMoth.this.getHive();
      if (nest != null) {
        nest.tryEnterHive(SilkMoth.this);
      }
    }
  }

  class ValidateHiveGoal extends class_1352 {

    private final int ticksUntilNextValidate = class_3532.method_15395(SilkMoth.this.field_5974, 20, 40);
    private long lastValidateTime = -1L;

    @Override
    public void method_6269() {
      if (SilkMoth.this.hivePos != null && SilkMoth.this.method_73183()
          .method_8477(SilkMoth.this.hivePos) && SilkMoth.this.getHive() == null) {
        SilkMoth.this.clearHivePos();
      }

      this.lastValidateTime = SilkMoth.this.method_73183().method_8510();
    }

    @Override
    public boolean method_6264() {
      return SilkMoth.this.method_73183().method_8510()
          > this.lastValidateTime + this.ticksUntilNextValidate;
    }

    @Override
    public boolean method_6266() {
      return false;
    }
  }

  class MoveToHiveGoal extends class_1352 {

    int ticks;
    final List<class_2338> possibleHives = Lists.newArrayList();

    @Nullable
    private class_11 path;
    private int ticksUntilLost;

    public MoveToHiveGoal() {
      this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
      return (
          SilkMoth.this.hivePos != null
              && SilkMoth.this.hivePos.method_19771(SilkMoth.this.method_24515(),
              MAX_DISTANCE_FROM_HIVE)
              && SilkMoth.this.canEnterHive()
              && !this.isCloseEnough(SilkMoth.this.hivePos)
              && SilkMoth.this.method_73183().method_8320(SilkMoth.this.hivePos)
              .method_27852(LighterEndBlocks.SILK_MOTH_NEST)
      );
    }

    @Override
    public boolean method_6266() {
      return this.method_6264();
    }

    @Override
    public void method_6269() {
      this.ticks = 0;
      this.ticksUntilLost = 0;
      super.method_6269();
    }

    @Override
    public void method_6270() {
      this.ticks = 0;
      this.ticksUntilLost = 0;
      SilkMoth.this.field_6189.method_6340();
      SilkMoth.this.field_6189.method_23965();
    }

    @Override
    public void method_6268() {
      if (SilkMoth.this.hivePos != null) {
        this.ticks++;
        if (this.ticks > this.method_38847(MIN_TICKS_BETWEEN_ENTERING_HIVE)) {
          this.makeChosenHivePossibleHive();
        } else if (!SilkMoth.this.field_6189.method_23966()) {
          if (!SilkMoth.this.hivePos.method_19769(SilkMoth.this.method_73189(), 16)) {
            if (!SilkMoth.this.hivePos.method_19769(SilkMoth.this.method_73189(),
                MAX_DISTANCE_FROM_HIVE)) {
              SilkMoth.this.clearHivePos();
            } else {
              SilkMoth.this.startMovingTo(SilkMoth.this.hivePos);
            }
          } else {
            boolean bl = this.startMovingToFar(SilkMoth.this.hivePos);
            if (!bl) {
              this.makeChosenHivePossibleHive();
            } else if (
                this.path != null && SilkMoth.this.field_6189.method_6345().method_41(this.path)
            ) {
              this.ticksUntilLost++;
              if (this.ticksUntilLost > 60) {
                SilkMoth.this.clearHivePos();
                this.ticksUntilLost = 0;
              }
            } else {
              this.path = SilkMoth.this.field_6189.method_6345();
            }
          }
        }
      }
    }

    private boolean startMovingToFar(class_2338 pos) {
      int i = pos.method_19769(SilkMoth.this.method_73189(), 3) ? 1 : 2;
      SilkMoth.this.field_6189.method_23964(10.0F);
      SilkMoth.this.field_6189.method_58160(pos.method_10263(), pos.method_10264(), pos.method_10260(), i, 1.0);
      return SilkMoth.this.field_6189.method_6345() != null
          && SilkMoth.this.field_6189.method_6345().method_21655();
    }

    boolean isPossibleHive(class_2338 pos) {
      return this.possibleHives.contains(pos);
    }

    private void addPossibleHive(class_2338 pos) {
      this.possibleHives.add(pos);

      while (this.possibleHives.size() > 3) {
        this.possibleHives.remove(0);
      }
    }

    void clearPossibleHives() {
      this.possibleHives.clear();
    }

    private void makeChosenHivePossibleHive() {
      if (SilkMoth.this.hivePos != null) {
        this.addPossibleHive(SilkMoth.this.hivePos);
      }

      SilkMoth.this.clearHivePos();
    }

    private boolean isCloseEnough(class_2338 pos) {
      if (pos.method_19771(SilkMoth.this.method_24515(), 2)) {
        return true;
      } else {
        class_11 path = SilkMoth.this.field_6189.method_6345();
        return path != null && path.method_48().equals(pos) && path.method_21655()
            && path.method_46();
      }
    }
  }

  class FindHiveGoal extends class_1352 {

    @Override
    public boolean method_6264() {
      return SilkMoth.this.ticksLeftUntilFindHive <= 0
          && SilkMoth.this.hivePos == null
          && SilkMoth.this.canEnterHive();
    }

    @Override
    public boolean method_6266() {
      return false;
    }

    @Override
    public void method_6269() {
      SilkMoth.this.ticksLeftUntilFindHive = MAX_TICKS_TO_FIND_HIVE;
      List<class_2338> list = this.getNearbyFreeHives();
      if (!list.isEmpty()) {
        for (class_2338 blockPos : list) {
          if (!SilkMoth.this.moveToHiveGoal.isPossibleHive(blockPos)) {
            SilkMoth.this.hivePos = blockPos;
            return;
          }
        }

        SilkMoth.this.moveToHiveGoal.clearPossibleHives();
        SilkMoth.this.setHive(list.getFirst());
      }
    }

    private List<class_2338> getNearbyFreeHives() {
      class_2338 blockPos = SilkMoth.this.method_24515();
      class_1937 world = SilkMoth.this.method_73183();

      List<class_2338> nearbyHives = new ArrayList<>();
      for (int dy = 0; dy <= 10 && dy >= -10; dy = (dy <= 0 ? 1 : 0) - dy) {
        for (int dx = 0;
            dx <= MAX_DISTANCE_FROM_HIVE - Math.abs(dy)
                && dx >= -MAX_DISTANCE_FROM_HIVE + Math.abs(dy);
            dx = (dx <= 0 ? 1 : 0) - dx) {
          for (int dz = 0; dz <= MAX_DISTANCE_FROM_HIVE - Math.abs(dy) - Math.abs(dx)
              && dz >= -MAX_DISTANCE_FROM_HIVE + Math.abs(dy) + Math.abs(dx);
              dz = (dz <= 0 ? 1 : 0) - dz) {
            class_2338 blockPos2 = blockPos.method_10069(dx, dy, dz);
            if (!blockPos2.method_19771(blockPos, MAX_DISTANCE_FROM_HIVE)) {
              continue;
            }
            if (world.method_8321(blockPos2) instanceof SilkMothNestEntity nest) {
              if (nest.getOccupancy() < SilkMothNestEntity.MAX_MOTH_COUNT) {
                nearbyHives.add(blockPos2);
              }
            }
          }
        }
      }
      nearbyHives.sort(Comparator.comparingDouble(pos -> pos.method_10262(blockPos)));
      return nearbyHives;
    }
  }

  class WanderAroundGoal extends class_1352 {

    WanderAroundGoal() {
      this.method_6265(EnumSet.of(class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
      return SilkMoth.this.field_6189.method_6357() && SilkMoth.this.field_5974.method_43048(10) == 0;
    }

    @Override
    public boolean method_6266() {
      return SilkMoth.this.field_6189.method_23966();
    }

    @Override
    public void method_6269() {
      class_243 vec3d = this.getRandomLocation();
      if (vec3d != null) {
        SilkMoth.this.field_6189.method_6334(
            SilkMoth.this.field_6189.method_6348(class_2338.method_49638(vec3d), 1), 1.0);
      }
    }

    @Nullable
    private class_243 getRandomLocation() {
      class_243 vec3d2;
      if (SilkMoth.this.getHive() != null && SilkMoth.this.hivePos.method_19771(
          SilkMoth.this.method_24515(), this.getMaxWanderDistance())) {
        class_243 vec3d = class_243.method_24953(SilkMoth.this.hivePos);
        vec3d2 = vec3d.method_1020(SilkMoth.this.method_73189()).method_1029();
      } else {
        vec3d2 = SilkMoth.this.method_5828(0.0F);
      }

      class_243 vec3d3 = class_5533.method_31524(SilkMoth.this, 8, 7, vec3d2.field_1352, vec3d2.field_1350,
          (float) (Math.PI / 2), 3, 1);
      return vec3d3 != null ? vec3d3
          : class_5530.method_31504(SilkMoth.this, 8, 4, -2, vec3d2.field_1352, vec3d2.field_1350,
              (float) (Math.PI / 2));
    }

    private int getMaxWanderDistance() {
      int i = (SilkMoth.this.hivePos == null) ? 16 : 24;
      return 48 - i;
    }
  }

  @Override
  public class_3414 method_5994() {
    return LighterEndSounds.SILK_MOTH_IDLE;
  }

  @Nullable
  protected class_3414 method_6011(class_1282 source) {
    return LighterEndSounds.SILK_MOTH_HURT;
  }

  @Nullable
  protected class_3414 method_6002() {
    return LighterEndSounds.SILK_MOTH_DEATH;
  }

}
