package io.github.openbagtwo.lighterend.mobs.models;

import io.github.openbagtwo.lighterend.mobs.states.CubozoaRenderState;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_6230;
import net.minecraft.class_630;

public class CubozoaModel extends class_583<CubozoaRenderState> {

  private final static int TENTACLE_COUNT = 4;

  private final class_630 model;
  private final class_630[] tentacle_center;
  private final class_630[] tentacle;
  private float scaleY;
  private float scaleXZ;

  public static class_5607 getTexturedModelData() {
    class_5609 modelData = new class_5609();
    class_5610 modelPartData = modelData.method_32111();

    class_5610 bodyPart = modelPartData.method_32117(
        class_6230.field_32608,
        class_5606.method_32108().method_32101(0, 17).method_32097(-2.0F, -12.5F, -2.0F, 4.0F, 4.0F, 4.0F),
        class_5603.method_32090(0.0F, 24.0F, 0.0F)
    );

    bodyPart.method_32117(
        "main_cube_r1",
        class_5606.method_32108().method_32101(0, 0).method_32097(-5.0F, -7.0F, -5.0F, 10.0F, 7.0F, 10.0F),
        class_5603.method_32091(0.0F, -14.0F, 0.0F, 0.0F, 0.0F, -3.1416F)
    );

    for (int i = 1; i <= TENTACLE_COUNT; i++) {
      class_5610 tentaclePart = bodyPart.method_32117(
          "tentacle_center_" + i,
          class_5606.method_32108(),
          class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, i * 1.5708F, 0.0F)
      );

      tentaclePart.method_32117(
          "tentacle_" + i,
          class_5606.method_32108().method_32101(16, 17).method_32097(-4.0F, 0.0F, 0.0F, 8.0F, 7.0F, 0.0F),
          class_5603.method_32090(0.0F, -7.0F, 4.5F)
      );
    }

    return class_5607.method_32110(modelData, 48, 48);
  }

  public CubozoaModel(class_630 modelPart) {
    super(modelPart, class_1921::method_23580);
    tentacle = new class_630[TENTACLE_COUNT];
    tentacle_center = new class_630[TENTACLE_COUNT];

    model = modelPart.method_32086(class_6230.field_32608);
    for (int i = 1; i <= TENTACLE_COUNT; i++) {
      tentacle_center[i - 1] = model.method_32086("tentacle_center_" + i);
      tentacle[i - 1] = tentacle_center[i - 1].method_32086("tentacle_" + i);
    }
  }

  @Override
  public void setAngles(CubozoaRenderState renderState) {
    super.method_2819(renderState);
    float sin = class_3532.method_15374(renderState.field_53328 * 0.13F);
    scaleY = sin * 0.1F + 0.9F;
    scaleXZ = class_3532.method_15374(renderState.field_53328 * 0.13F + 3.14F) * 0.1F + 0.9F;

    for (int i = 0; i < TENTACLE_COUNT; i++) {
      tentacle[i].field_3654 = sin * 0.15f;
    }
  }

  public void renderOverride(
      class_4587 matrices,
      class_4588 vertices,
      int light,
      int overlay,
      int color
  ) {
    matrices.method_22903();
    matrices.method_22905(scaleXZ, scaleY, scaleXZ);
    model.method_22698(matrices, vertices, light, overlay);
    matrices.method_22909();
  }
}
