package io.github.openbagtwo.lighterend.particles;

import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;

public class GlowingSphere extends class_708 {

  private int ticks;
  private double preVX;
  private double preVY;
  private double preVZ;
  private double nextVX;
  private double nextVY;
  private double nextVZ;

  protected GlowingSphere(
      class_638 world,
      double x,
      double y,
      double z,
      class_4002 sprites
  ) {
    super(world, x, y, z, sprites, 0);
    method_74307(sprites.method_18139(field_3840));
    this.field_3847 = class_3532.method_15395(field_3840, 150, 300);
    this.field_17867 = class_3532.method_15344(field_3840, 0.05F, 0.15F);
    this.method_3092(15916745);
    this.method_74306(field_17866);

    preVX = field_3840.method_43059() * 0.02;
    preVY = field_3840.method_43059() * 0.02;
    preVZ = field_3840.method_43059() * 0.02;

    nextVX = field_3840.method_43059() * 0.02;
    nextVY = field_3840.method_43059() * 0.02;
    nextVZ = field_3840.method_43059() * 0.02;
  }

  @Override
  public void method_3070() {
    ticks++;
    if (ticks > 30) {
      preVX = nextVX;
      preVY = nextVY;
      preVZ = nextVZ;
      nextVX = field_3840.method_43059() * 0.02;
      nextVY = field_3840.method_43059() * 0.02;
      nextVZ = field_3840.method_43059() * 0.02;
      ticks = 0;
    }
    double delta = (double) ticks / 30.0;

    this.field_3852 = class_3532.method_16436(delta, preVX, nextVX);
    this.field_3869 = class_3532.method_16436(delta, preVY, nextVY);
    this.field_3850 = class_3532.method_16436(delta, preVZ, nextVZ);

    super.method_3070();
  }

  public static class Factory implements class_707<class_2400> {

    private final class_4002 sprites;

    public Factory(class_4002 sprites) {
      this.sprites = sprites;
    }

    @Override
    public class_703 createParticle(
        class_2400 type,
        class_638 world,
        double x,
        double y,
        double z,
        double vX,
        double vY,
        double vZ,
        class_5819 random
    ) {
      return new GlowingSphere(world, x, y, z, sprites);
    }
  }
}
