package io.github.openbagtwo.lighterend.registries;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Agave;
import io.github.openbagtwo.lighterend.blocks.AuroraCrystal;
import io.github.openbagtwo.lighterend.blocks.Brimstone;
import io.github.openbagtwo.lighterend.blocks.Chandelier;
import io.github.openbagtwo.lighterend.blocks.Charnia;
import io.github.openbagtwo.lighterend.blocks.CreepingMoss;
import io.github.openbagtwo.lighterend.blocks.DragonBone;
import io.github.openbagtwo.lighterend.blocks.EndLily;
import io.github.openbagtwo.lighterend.blocks.EndLotus;
import io.github.openbagtwo.lighterend.blocks.EndMoss;
import io.github.openbagtwo.lighterend.blocks.Fur;
import io.github.openbagtwo.lighterend.blocks.Furnaces;
import io.github.openbagtwo.lighterend.blocks.GlowshroomCap;
import io.github.openbagtwo.lighterend.blocks.HydrothermalVent;
import io.github.openbagtwo.lighterend.blocks.Lumecorn;
import io.github.openbagtwo.lighterend.blocks.Murkweed;
import io.github.openbagtwo.lighterend.blocks.Needlegrass;
import io.github.openbagtwo.lighterend.blocks.Obelisk;
import io.github.openbagtwo.lighterend.blocks.Pedestal;
import io.github.openbagtwo.lighterend.blocks.Polypore;
import io.github.openbagtwo.lighterend.blocks.Sapling;
import io.github.openbagtwo.lighterend.blocks.ShadowBerry;
import io.github.openbagtwo.lighterend.blocks.ShadowGrass;
import io.github.openbagtwo.lighterend.blocks.SilkMothNest;
import io.github.openbagtwo.lighterend.blocks.SulphurCrystal;
import io.github.openbagtwo.lighterend.blocks.TenaneaFlower;
import io.github.openbagtwo.lighterend.blocks.TubeWorm;
import io.github.openbagtwo.lighterend.blocks.UmbrellaFern;
import io.github.openbagtwo.lighterend.blocks.UmbrellaFern.TallUmbrellaFern;
import io.github.openbagtwo.lighterend.blocks.UmbrellaMembrane;
import io.github.openbagtwo.lighterend.blocks.UmbrellaTreeCluster;
import io.github.openbagtwo.lighterend.blocks.VentBubbleColumn;
import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.world.features.trees.DragonTree;
import io.github.openbagtwo.lighterend.world.features.trees.Glowshroom;
import io.github.openbagtwo.lighterend.world.features.trees.TenaneaTree;
import io.github.openbagtwo.lighterend.world.features.trees.UmbrellaTree;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10716;
import net.minecraft.class_11710;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2401;
import net.minecraft.class_2431;
import net.minecraft.class_2440;
import net.minecraft.class_2449;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970.class_2251;
import net.minecraft.class_5321;
import net.minecraft.class_6019;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;

public class LighterEndBlocks {

  public static final class_2248 AURORA_CRYSTAL = register("aurora_crystal", AuroraCrystal::new);
  public static final class_2248 ENDER_BLOCK = register("ender_block", settings -> new class_2248(
      settings.method_51368(class_2766.field_18284).method_31710(class_3620.field_25708)
          .method_9629(5F, 6F).method_29292().method_9626(class_2498.field_11544)));
  public static final Material VIOLECITE = new Material("violecite", class_3620.field_16007);
  public static final class_2248 MISSING_TILE = register("missing_tile", settings -> new class_2248(
      settings.method_51368(class_2766.field_12653).method_29292().method_9629(3.0F, 9.0F)
          .method_31710(class_3620.field_16029)));

  public static final Material AZURE_JADESTONE = new Material("azure_jadestone",
      class_3620.field_16024);
  public static final Material SANDY_JADESTONE = new Material("sandy_jadestone", class_3620.field_16010);
  public static final Material VIRID_JADESTONE = new Material("virid_jadestone", class_3620.field_15995);

  public static class_2248 DRAGON_BONE_BLOCK = register("dragon_bone_block",
      settings -> new class_2465(DragonBone.applySettings(settings)));
  public static class_2248 DRAGON_BONE_STAIRS = register("dragon_bone_stairs",
      settings -> new class_2510(DRAGON_BONE_BLOCK.method_9564(),
          DragonBone.applySettings(settings)));
  public static class_2248 DRAGON_BONE_SLAB = register("dragon_bone_slab",
      settings -> new class_2482(DragonBone.applySettings(settings)));

  public static class_2248 END_MOSS = register("end_moss", EndMoss::new);

  public static class_2248 CREEPING_MOSS = register("creeping_moss", CreepingMoss::new);

  public static class_2248 UMBRELLA_FERN = register("umbrella_fern", UmbrellaFern::new);

  public static class_2248 TALL_UMBRELLA_FERN = register("umbrella_fern_tall", TallUmbrellaFern::new,
      false);

  public static class_2248 LUMECORN_SEED = register("lumecorn_seed", Lumecorn.LumecornSeed::new);
  public static class_2248 LUMECORN = register("lumecorn", Lumecorn::new, false);
  public static class_2248 LUMECORN_STEM = register("lumecorn_stem", Lumecorn.LumecornStem::new, false);

  public static Material UMBRALITH = new Material("umbralith", class_3620.field_16009);

  public static class_2248 TENANEA_FLOWER = register("tenanea_flower", TenaneaFlower::new);
  public static class_2248 TENANEA_SAPLING = register("tenanea_sapling",
      settings -> new Sapling(TenaneaTree::new, settings.method_31710(class_3620.field_16030)));
  public static class_2248 POTTED_TENANEA_SAPLING = register(
      "potted_tenanea_sapling",
      settings -> new class_2362(TENANEA_SAPLING, applyFlowerPotSettings(settings)),
      false
  );
  public static WoodSet TENANEA = new WoodSet(
      "tenanea",
      class_3620.field_16013,
      class_3620.field_15998
  );
  public static class_2248 TENANEA_LEAVES = register(
      "tenanea_leaves",
      settings -> new class_10716(
          0.01F,
          applyLeafSettings(settings.method_31710(class_3620.field_16030))
      )
  );
  public static class_2248 SILK_MOTH_NEST = register("silk_moth_nest", SilkMothNest::new, false);

  public static class_2248 UMBRELLA_TREE_CLUSTER = register("umbrella_tree_cluster",
      UmbrellaTreeCluster::new);
  public static class_2248 UMBRELLA_TREE_CLUSTER_EMPTY = register("umbrella_tree_cluster_empty",
      UmbrellaTreeCluster.EmptyCluster::new);
  public static class_2248 UMBRELLA_TREE_SAPLING = register("umbrella_tree_sapling",
      settings -> new Sapling(UmbrellaTree::new, settings.method_31710(class_3620.field_25708)));
  public static class_2248 POTTED_UMBRELLA_SAPLING = register(
      "potted_umbrella_tree_sapling",
      settings -> new class_2362(UMBRELLA_TREE_SAPLING, applyFlowerPotSettings(settings)),
      false
  );
  public static WoodSet UMBRELLA = new WoodSet("umbrella", class_3620.field_15984, class_3620.field_15995);
  public static class_2248 UMBRELLA_MEMBRANE = register("umbrella_membrane", UmbrellaMembrane::new);

  public static final class_2248 CHARNIA_CYAN = register("charnia_cyan", Charnia::new);
  public static final class_2248 CHARNIA_GREEN = register("charnia_green", Charnia::new);
  public static final class_2248 CHARNIA_LIGHT_BLUE = register("charnia_light_blue", Charnia::new);
  public static final class_2248 CHARNIA_ORANGE = register("charnia_orange", Charnia::new);
  public static final class_2248 CHARNIA_PURPLE = register("charnia_purple", Charnia::new);
  public static final class_2248 CHARNIA_RED = register("charnia_red", Charnia::new);

  public static final class_2248 END_LILY = register("end_lily", EndLily::new, false);
  public static final class_2248 END_LILY_SEED = register("end_lily_seed", EndLily.Seed::new);

  public static final class_2248 END_LOTUS_FLOWER = register("end_lotus_flower", EndLotus::new, false);
  public static final class_2248 END_LOTUS_STEM = register("end_lotus_stem", EndLotus.Stem::new);
  public static final class_2248 END_LOTUS_LEAF = register("end_lotus_leaf", EndLotus.Leaf::new, false);
  public static final class_2248 END_LOTUS_SEED = register("end_lotus_seed", EndLotus.Seed::new);

  public static final WoodSet LOTUS = new WoodSet("end_lotus", class_3620.field_16024, class_3620.field_16026);

  public static final class_2248 GLOWSHROOM_SAPLING = register("mossy_glowshroom_sapling",
      settings -> new Sapling(Glowshroom::new, settings.method_9631((bs) -> 7)));
  public static class_2248 POTTED_GLOWSHROOM_SAPLING = register(
      "potted_mossy_glowshroom_sapling",
      settings -> new class_2362(GLOWSHROOM_SAPLING, applyFlowerPotSettings(settings)),
      false
  );
  public static final WoodSet GLOWSHROOM = new WoodSet(
      "mossy_glowshroom",
      class_3620.field_15978,
      class_3620.field_15996);
  public static final class_2248 GLOWSHROOM_CAP = register("mossy_glowshroom_cap", GlowshroomCap::new);
  public static final class_2248 GLOWSHROOM_HYMENOPHORE = register(
      "mossy_glowshroom_hymenophore",
      settings -> new class_2248(
          settings
              .method_31710(class_3620.field_16024)
              .method_9632(1.0F)
              .method_9631((bs) -> 15)
              .method_9626(class_2498.field_22144)
      )
  );
  public static final class_2248 GLOWSHROOM_FUR = register(
      "mossy_glowshroom_fur", settings -> new Fur(settings, class_3620.field_16024, 4, true), false
  );

  public static final class_2248 AGAVE = register("blue_vine", Agave::new, false);
  public static final class_2248 AGAVE_BULB = register("blue_vine_lantern", Agave.Bulb::new);
  public static final class_2248 AGAVE_FUR = register(
      "blue_vine_fur",
      settings -> new Fur(settings, class_3620.field_25708, 0, false),
      false
  );
  public static final class_2248 AGAVE_SEED = register(
      "blue_vine_seed", settings -> new Sapling(Agave.AgaveFeature::new, settings)
  );

  public static final class_2248 AURANT_POLYPORE = register(
      "aurant_polypore",
      settings -> new Polypore(settings, class_3620.field_25704, 13)
  );
  public static final class_2248 PURPLE_POLYPORE = register(
      "purple_polypore",
      settings -> new Polypore(settings, class_3620.field_15998, 0)
  );

  public static final class_2248 END_FURNACE = register("end_stone_furnace", Furnaces.EndFurnace::new);
  public static final class_2248 END_SMOKER = register("end_stone_smoker", Furnaces.EndSmoker::new);

  public static final class_2248 END_LEVER = register("end_stone_lever", settings -> new class_2401(
          settings
              .method_9634()
              .method_9632(1.0F)
              .method_9626(class_2498.field_11544)
              .method_50012(class_3619.field_15971)
      )
  );

  public static final class_2248 OBELISK = register("obelisk", Obelisk::new);

  public static final class_2248 GOLD_CHANDELIER = register("gold_chandelier", Chandelier::new);
  public static final class_2248 IRON_CHANDELIER = register("iron_chandelier", Chandelier::new);
  public static final class_11710 COPPER_CHANDELIERS = class_11710.method_73123(
      "copper_chandelier",
      LighterEndBlocks::register,
      Chandelier::new,
      Chandelier.Oxidizable::new,
      oxidationLevel -> class_2251.method_9637()
          .method_31710(class_3620.field_16005)
          .method_9631((bs) -> 15)
          .method_51369()
          .method_22488()
          .method_29292()
          .method_50012(class_3619.field_15971)
          .method_9632(2.5F)
          .method_9626(class_2498.field_24119)
  );

  public static final class_2248 EMERALD_ICE = register(
      "emerald_ice",
      settings -> new class_2248(
          settings
              .method_31710(class_3620.field_15999)
              .method_51368(class_2766.field_12647)
              .method_9628(0.95F)
              .method_9632(0.75F)
              .method_9626(class_2498.field_11537)
              .method_29292()
              .method_22488()
      )
  );

  public static final class_2248 FERROUS_ICE = register(
      "ferrous_ice",
      settings -> new class_2248(
          settings
              .method_31710(class_3620.field_25703)
              .method_51368(class_2766.field_12647)
              .method_9628(0.95F)
              .method_9632(0.75F)
              .method_9626(class_2498.field_11537)
              .method_29292()
              .method_22488()
      )
  );

  public static final class_2248 AUROUS_ICE = register(
      "aurous_ice",
      settings -> new class_2248(
          settings
              .method_31710(class_3620.field_15986)
              .method_51368(class_2766.field_12647)
              .method_9628(0.95F)
              .method_9632(0.75F)
              .method_9626(class_2498.field_11537)
              .method_29292()
              .method_22488()
      )
  );

  public static final class_2248 END_STONE_REDSTONE_ORE = register(
      "end_stone_redstone_ore",
      settings -> new class_2449(
          settings
              .method_31710(class_3620.field_15986)
              .method_9629(4.5F, 9.0F)
              .method_51368(class_2766.field_12653)
              .method_29292()
              .method_9640()
              .method_9631(state -> state.method_11654(class_2741.field_12548) ? 9 : 0)
      )
  );

  public static final class_2248 UMBRALITH_REDSTONE_ORE = register(
      "umbralith_redstone_ore",
      settings -> new class_2449(
          settings
              .method_31710(class_3620.field_16009)
              .method_9629(4.5F, 9.0F)
              .method_51368(class_2766.field_12653)
              .method_29292()
              .method_9640()
              .method_9631(state -> state.method_11654(class_2741.field_12548) ? 9 : 0)
      )
  );

  public static final class_2248 END_STONE_QUARTZ_ORE = register(
      "end_stone_quartz_ore",
      settings -> new class_2431(class_6019.method_35017(2, 5),
          settings
              .method_31710(class_3620.field_15986)
              .method_9629(4.5F, 9.0F)
              .method_51368(class_2766.field_12653)
              .method_29292()
      )
  );

  public static final class_2248 UMBRALITH_QUARTZ_ORE = register(
      "umbralith_quartz_ore",
      settings -> new class_2431(class_6019.method_35017(2, 5),
          settings
              .method_31710(class_3620.field_16009)
              .method_9629(4.5F, 9.0F)
              .method_51368(class_2766.field_12653)
              .method_29292()
      )
  );

  public static final class_2248 BRIMSTONE = register("brimstone", Brimstone::new);
  public static final Material BORNITE = new Material("sulphuric_rock", class_3620.field_15977);
  public static final class_2248 SULPHUR_CRYSTAL = register("sulphur_crystal", SulphurCrystal::new);
  public static final class_2248 HYDROTHERMAL_VENT = register(
      "hydrothermal_vent",
      HydrothermalVent::new
  );
  public static final class_2248 VENT_BUBBLE_COLUMN = register(
      "vent_bubble_column",
      VentBubbleColumn::new,
      false
  );
  public static final class_2248 TUBE_WORM = register(
      "tube_worm",
      TubeWorm::new
  );

  public static final class_2248 SHADOW_BERRY = register(
      "shadow_berry",
      ShadowBerry::new,
      false
  );
  public static final class_2248 SHADOW_GRASS = register(
      "shadow_plant",
      ShadowGrass::new
  );
  public static final class_2248 NEEDLEGRASS = register(
      "needlegrass",
      Needlegrass::new
  );
  public static final class_2248 MURKWEED = register(
      "murkweed",
      Murkweed::new
  );
  public static class_2248 DRAGON_SAPLING = register("dragon_tree_sapling",
      settings -> new Sapling(DragonTree::new, settings.method_31710(class_3620.field_15998)));
  public static class_2248 POTTED_DRAGON_SAPLING = register(
      "potted_dragon_tree_sapling",
      settings -> new class_2362(DRAGON_SAPLING, applyFlowerPotSettings(settings)),
      false
  );
  public static WoodSet DRAGON = new WoodSet("dragon_tree", class_3620.field_16009, class_3620.field_16014);
  public static class_2248 DRAGON_LEAVES = register(
      "dragon_tree_leaves",
      settings -> new class_10716(
          0.01F,
          applyLeafSettings(settings.method_31710(class_3620.field_15998))
      )
  );

  public static class_2248 register(String name, Function<class_2251, class_2248> factory) {
    return register(name, factory, true);
  }

  public static class_2248 register(String name, Function<class_2251, class_2248> factory, boolean hasItem) {
    return register(name, factory, class_2251.method_9637(), hasItem);
  }

  private static class_2248 register(String name, Function<class_2251, class_2248> factory, class_2251 settings) {
    return register(name, factory, settings, true);
  }

  private static class_2248 register(
      String name,
      Function<class_2251, class_2248> factory,
      class_2251 settings,
      boolean hasItem
  ) {
    class_2960 id = LighterEnd.of(name);
    class_2248 block = factory.apply(settings.method_63500(class_5321.method_29179(class_7924.field_41254, id)));

    if (hasItem) {
      class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, id);
      class_2378.method_39197(class_7923.field_41178, itemKey,
          new class_1747(block, new class_1792.class_1793().method_63686(itemKey)));
    }
    class_5321<class_2248> blockKey = class_5321.method_29179(class_7924.field_41254, id);
    return class_2378.method_39197(class_7923.field_41175, blockKey, block);
  }

  public static void initialize() {
  }

  public static class Material {

    public final String baseName;
    public final class_2248 baseBlock;
    public final class_2248 baseStairs;
    public final class_2248 baseSlab;
    public final class_2248 baseWall;
    public final class_2248 bricks;
    public final class_2248 brickStairs;
    public final class_2248 brickSlab;
    public final class_2248 brickWall;
    public final class_2248 polished;
    public final class_2248 polishedStairs;
    public final class_2248 polishedSlab;
    public final class_2248 polishedWall;
    public final class_2248 tiles;
    public final class_2248 tileStairs;
    public final class_2248 tileSlab;
    public final class_2248 tileWall;
    public final class_2248 pillar;
    public final class_2248 button;
    public final class_2248 pressurePlate;
    public final class_2248 pedestal;
    public final List<class_2248> blocks;
    private final class_3620 mapColor;


    public Material(String name, class_3620 mapColor) {
      this.baseName = name;
      this.mapColor = mapColor;

      baseBlock = register(baseName, settings -> new class_2248(applySettings(settings)));
      baseStairs = register(baseName + "_stairs",
          settings -> new class_2510(baseBlock.method_9564(), applySettings(settings)));
      baseSlab = register(baseName + "_slab", settings -> new class_2482(applySettings(settings)));
      baseWall = register(baseName + "_wall", settings -> new class_2544(applySettings(settings)));

      bricks = register(baseName + "_bricks", settings -> new class_2248(applySettings(settings)));
      brickStairs = register(baseName + "_brick_stairs",
          settings -> new class_2510(bricks.method_9564(), applySettings(settings)));
      brickSlab = register(baseName + "_brick_slab",
          settings -> new class_2482(applySettings(settings)));
      brickWall = register(baseName + "_brick_wall",
          settings -> new class_2544(applySettings(settings)));

      polished = register(baseName + "_polished", settings -> new class_2248(applySettings(settings)));
      polishedStairs = register(baseName + "_polished_stairs",
          settings -> new class_2510(polished.method_9564(), applySettings(settings)));
      polishedSlab = register(baseName + "_polished_slab",
          settings -> new class_2482(applySettings(settings)));
      polishedWall = register(baseName + "_polished_wall",
          settings -> new class_2544(applySettings(settings)));

      tiles = register(baseName + "_tiles", settings -> new class_2248(applySettings(settings)));
      tileStairs = register(baseName + "_tile_stairs",
          settings -> new class_2510(tiles.method_9564(), applySettings(settings)));
      tileSlab = register(baseName + "_tile_slab",
          settings -> new class_2482(applySettings(settings)));
      tileWall = register(baseName + "_tile_wall",
          settings -> new class_2544(applySettings(settings)));

      pillar = register(baseName + "_pillar", settings -> new class_2465(applySettings(settings)));
      button = register(baseName + "_button",
          settings -> new class_2269(class_8177.field_42822, 30,
              settings.method_9634().method_9632(0.5F).method_50012(class_3619.field_15971)));
      pressurePlate = register(baseName + "_pressure_plate",
          settings -> new class_2440(class_8177.field_42822,
              settings.method_31710(mapColor)
                  .method_51369()
                  .method_51368(class_2766.field_12653)
                  .method_9634()
                  .method_9632(0.5F)
                  .method_50012(class_3619.field_15971)));
      pedestal = register(baseName + "_pedestal",
          settings -> new Pedestal(applySettings(settings))
      );

      blocks = Arrays.asList(baseBlock, baseStairs, baseSlab, baseWall, bricks, brickStairs,
          brickSlab, brickWall, polished, polishedStairs, polishedSlab, polishedWall, tiles,
          tileStairs, tileSlab, tileWall, pillar, button, pressurePlate, pedestal);
    }

    public class_2251 applySettings(class_2251 settings) {
      return settings.method_51368(class_2766.field_12653).method_29292().method_9629(3.0F, 9.0F)
          .method_31710(this.mapColor);
    }
  }

  public static class_2251 applyLeafSettings(class_2251 settings) {
    return settings
        .method_9632(0.2F)
        .method_9640()
        .method_9626(class_2498.field_11535)
        .method_22488()
        .method_26235(class_2246::method_26126)
        .method_26243(class_2246::method_26122)
        .method_26245(class_2246::method_26122)
        .method_50013()
        .method_50012(class_3619.field_15971)
        .method_26236(class_2246::method_26122);
  }

  public static class_2251 applyFlowerPotSettings(class_2251 settings) {
    return settings.method_9618().method_22488().method_50012(class_3619.field_15971);
  }

}
