package io.github.openbagtwo.lighterend.registries;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.SilkMothNest;
import io.github.openbagtwo.lighterend.blocks.entities.SilkMothNestEntity;
import io.github.openbagtwo.lighterend.blocks.entities.SilkMothNestEntity.MothData;
import io.github.openbagtwo.lighterend.items.TPTotem;
import io.github.openbagtwo.lighterend.items.TPTotem.Target;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_10134;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9331.class_9332;
import net.minecraft.class_9473;

public class LighterEndData {

  public static final class_9331<MothsComponent> MOTHS = registerDataComponent(
      "moths",
      builder -> builder.method_57881(MothsComponent.CODEC).method_57882(MothsComponent.PACKET_CODEC)
          .method_59871()
  );

  public static final class_9331<SilkLevelComponent> SILK_LEVEL = registerDataComponent(
      "silk_level",
      builder -> builder.method_57881(SilkLevelComponent.CODEC)
          .method_57882(SilkLevelComponent.PACKET_CODEC)
          .method_59871()
  );

  public static final class_9331<Variant> VARIANT = registerDataComponent(
      "variant",
      builder -> builder.method_57881(Variant.CODEC)
          .method_57882(Variant.PACKET_CODEC)
          .method_59871()
  );

  public record MothsComponent(List<MothData> moths) implements class_9299 {

    public static final Codec<MothsComponent> CODEC = MothData.LIST_CODEC.xmap(
        MothsComponent::new, MothsComponent::moths);
    public static final class_9139<ByteBuf, MothsComponent> PACKET_CODEC = MothData.PACKET_CODEC
        .method_56433(class_9135.method_56363())
        .method_56432(
            MothsComponent::new, MothsComponent::moths);
    public static final MothsComponent DEFAULT = new MothsComponent(List.of());

    @Override
    public void method_57409(
        class_1792.class_9635 context,
        Consumer<class_2561> textConsumer,
        class_1836 type,
        class_9473 components
    ) {
      textConsumer.accept(
          class_2561.method_43469(
              "container." + LighterEnd.MOD_ID + ".silk_moth_nest.moths",
              this.moths.size(),
              SilkMothNestEntity.MAX_MOTH_COUNT
          ).method_27692(class_124.field_1080)
      );
    }
  }

  public record SilkLevelComponent(int silk_level) implements class_9299 {

    public static final Codec<SilkLevelComponent> CODEC = Codec.INT.xmap(SilkLevelComponent::new,
        SilkLevelComponent::silk_level);
    public static final class_9139<ByteBuf, SilkLevelComponent> PACKET_CODEC = class_9135.field_48550.method_56432(
        SilkLevelComponent::new, SilkLevelComponent::silk_level);

    @Override
    public void method_57409(
        class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type,
        class_9473 components) {
      textConsumer.accept(
          class_2561.method_43469(
              "container." + LighterEnd.MOD_ID + ".silk_moth_nest.fullness",
              this.silk_level(),
              SilkMothNest.MAX_FULLNESS
          ).method_27692(class_124.field_1080)
      );
    }
  }

  public record Variant(int variant) {

    public static final Codec<Variant> CODEC = Codec.INT.xmap(Variant::new, Variant::variant);
    public static final class_9139<ByteBuf, Variant> PACKET_CODEC = class_9135.field_48550.method_56432(
        Variant::new, Variant::variant
    );
  }

  public static final class_10134.class_10135<TPTotem.FixedTeleport> TOTEM_TELEPORT = registerConsumeComponent(
      "totem_teleport", TPTotem.FixedTeleport.CODEC, TPTotem.FixedTeleport.field_53809
  );

  public static final class_9331<Target> TOTEM_TARGET = registerDataComponent(
      "teleportation_target",
      builder -> builder
          .method_57881(Target.CODEC)
          .method_57882(Target.PACKET_CODEC)
          .method_59871()
  );

  private static <T> class_9331<T> registerDataComponent(String name,
      UnaryOperator<class_9332<T>> builderOperator) {
    return class_2378.method_10230(
        class_7923.field_49658,
        LighterEnd.of(name),
        builderOperator.apply(class_9331.method_57873()).method_57880()
    );
  }

  private static <T extends class_10134> class_10134.class_10135<T> registerConsumeComponent(
      String id,
      MapCodec<T> codec,
      class_9139<class_9129, T> packetCodec
  ) {
    return class_2378.method_10226(class_7923.field_53967, id,
        new class_10134.class_10135<>(codec, packetCodec));
  }

  public static void initialize() {
  }
}
