package io.github.openbagtwo.lighterend.registries;

import com.google.common.collect.Maps;
import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.items.ArmoredElytra;
import java.util.Map;
import net.minecraft.class_10394;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8051;

public class LighterEndEquipment {


  public static final class_5321<class_10394> SILK_MATERIAL = class_5321.method_29179(
      class_5321.method_29180(class_2960.method_60656("equipment_asset")),
      LighterEnd.of("silk")
  );

  public static final class_1741 SILK_ARMOR = new class_1741(
      10, // durability base puts it between gold and iron
      Maps.newEnumMap(
          Map.of(
              class_8051.field_41937, 1,  // nerf boot defense
              class_8051.field_41936, 6,
              class_8051.field_41935, 8,
              class_8051.field_41934, 3,
              class_8051.field_48838, 4  // on par with chainmail
          )
      ),
      25, // enchantability on par with gold
      LighterEndSounds.EQUIP_SILK,
      0.0F,  // no toughness
      0.0F,  // no knockback protection,
      LighterEndTags.REPAIRS_SILK_ARMOR,
      SILK_MATERIAL
  );  // Note: most of these stats will never be used

  public static final class_1792 SILK_ELYTRA = LighterEndItems.register(
      "silk_elytra",
      settings -> new ArmoredElytra(settings, SILK_ARMOR, 100, 0.95F, false),
      new class_1793()
  );

  public static void initialize() {
  }

}
