package io.github.openbagtwo.lighterend.registries;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.ChorusCrab;
import io.github.openbagtwo.lighterend.mobs.Cubozoa;
import io.github.openbagtwo.lighterend.mobs.Dragonfly;
import io.github.openbagtwo.lighterend.mobs.EndFish;
import io.github.openbagtwo.lighterend.mobs.EndSlime;
import io.github.openbagtwo.lighterend.mobs.GlossyMooshroom;
import io.github.openbagtwo.lighterend.mobs.SilkMoth;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1430;
import net.minecraft.class_1480;
import net.minecraft.class_1621;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1826;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9169;

public class LighterEndMobs {

  public static final LighterEndMob<SilkMoth> SILK_MOTH = new LighterEndMob<>("silk_moth",
      class_1299.class_1300.method_5903(SilkMoth::new, class_1311.field_6294).method_17687(
          0.6F, 0.6F).method_55687(0.3F).method_27299(8));

  public static final LighterEndMob<Dragonfly> DRAGONFLY = new LighterEndMob<>("dragonfly",
      class_1299.class_1300.method_5903(Dragonfly::new, class_1311.field_6303).method_17687(
          0.6F, 0.5F).method_55687(0.25F).method_27299(8));

  public static final LighterEndMob<EndFish> END_FISH = new LighterEndMob<>("end_fish",
      class_1299.class_1300.method_5903(EndFish::new, class_1311.field_24460).method_17687(
          0.5F, 0.5F).method_55687(0.25F).method_27299(4));

  public static final LighterEndMob<Cubozoa> CUBOZOA = new LighterEndMob<>("cubozoa",
      class_1299.class_1300.method_5903(Cubozoa::new, class_1311.field_6300).method_17687(
          0.6F, 1.0F).method_55687(0.5F).method_27299(4));

  public static final LighterEndMob<EndSlime> END_SLIME = new LighterEndMob<>(
      "end_slime",
      class_1299.class_1300.method_5903(EndSlime::new, class_1311.field_6302).method_17687(0.5F, 0.5F)
          .method_55687(0.325F).method_58630(4.0F).method_27299(10)
  );

  public static final LighterEndMob<GlossyMooshroom> MOOSHROOM = new LighterEndMob<>(
      "glossy_mooshroom",
      class_1299.class_1300.method_5903(GlossyMooshroom::new, class_1311.field_6294)
          .method_17687(0.9F, 1.4F)
          .method_55687(1.3F)
          .method_55689(1.36875F)
          .method_27299(10)
  );

  public static final LighterEndMob<ChorusCrab> CHORUS_CRAB = new LighterEndMob<>(
      "chorus_crab",
      class_1299.class_1300.method_5903(ChorusCrab::new, class_1311.field_6294)
          .method_17687(2.0F, 1.2F)
          .method_55687(1.1F)
          .method_55690(new class_243(0, 0.9F, -0.5F))
          .method_27299(4)
  );

  public static class LighterEndMob<T extends class_1297> {

    public final class_1299<T> mob;
    public final class_1792 spawnEgg;

    public LighterEndMob(String name, class_1299.class_1300<T> settings) {
      mob = class_2378.method_10230(class_7923.field_41177,
          LighterEnd.of(name),
          settings.method_5905(
              class_5321.method_29179(
                  class_7924.field_41266, LighterEnd.of(name))));
      spawnEgg = LighterEndItems.register(
          name + "_spawn_egg",
          (properties) -> new class_1826(properties.method_72499(mob)),
          new class_1793()
      );
    }
  }

  public static void initialize() {
    FabricDefaultAttributeRegistry.register(SILK_MOTH.mob, SilkMoth.createAttributes());
    FabricDefaultAttributeRegistry.register(DRAGONFLY.mob, Dragonfly.createAttributes());
    FabricDefaultAttributeRegistry.register(END_FISH.mob, EndFish.createAttributes());
    FabricDefaultAttributeRegistry.register(CUBOZOA.mob, Cubozoa.createAttributes());
    FabricDefaultAttributeRegistry.register(END_SLIME.mob, EndSlime.createAttributes());
    FabricDefaultAttributeRegistry.register(MOOSHROOM.mob, class_1430.method_26883());
    FabricDefaultAttributeRegistry.register(CHORUS_CRAB.mob, ChorusCrab.createCrabAttributes());

    class_1317.method_20637(
        DRAGONFLY.mob,
        class_9169.field_48742,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canDragonflySpawn
    );
    class_1317.method_20637(
        END_FISH.mob,
        class_9169.field_48743,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canAquaticMobSpawn
    );
    class_1317.method_20637(
        CUBOZOA.mob,
        class_9169.field_48743,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canAquaticMobSpawn
    );
    class_1317.method_20637(
        END_SLIME.mob,
        class_9169.field_48745,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canSlimeSpawn
    );
    class_1317.method_20637(
        MOOSHROOM.mob,
        class_9169.field_48745,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canPassiveSpawn
    );
    class_1317.method_20637(
        CHORUS_CRAB.mob,
        class_9169.field_48745,
        class_2902.class_2903.field_13203,
        LighterEndMobs::canCrabSpawn
    );
  }

  public static boolean canAquaticMobSpawn(class_1299<? extends class_1480> type,
      class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
    return world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517)
        && world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382);
  }

  public static boolean canSlimeSpawn(
      class_1299<? extends class_1621> type,
      class_1936 world, class_3730 reason, class_2338 pos, class_5819 random
  ) {
    if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.SLIME_SPAWNABLE)) {
      return false;
    }
    return random.method_43048(4) == 0;
  }

  public static boolean canDragonflySpawn(
      class_1299<? extends class_1297> type,
      class_1936 world, class_3730 reason, class_2338 pos, class_5819 random
  ) {
    return random.method_43048(32) == 0;
  }

  public static boolean canCrabSpawn(
      class_1299<? extends class_1297> type,
      class_1936 world, class_3730 reason, class_2338 pos, class_5819 random
  ) {
    //TODO: check for nearby water
    return random.method_43048(16) == 0;
  }

  public static boolean canPassiveSpawn(
      class_1299<? extends class_1297> type,
      class_1936 world, class_3730 reason, class_2338 pos, class_5819 random
  ) {
    return true;
  }

}
