package io.github.openbagtwo.lighterend.world;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Agave.AgaveFeature;
import io.github.openbagtwo.lighterend.blocks.EndLily.EndLilyFeature;
import io.github.openbagtwo.lighterend.blocks.EndLotus.EndLotusFeature;
import io.github.openbagtwo.lighterend.blocks.Lumecorn;
import io.github.openbagtwo.lighterend.blocks.ShadowBerry;
import io.github.openbagtwo.lighterend.blocks.SilkMothNest.SilkMothNestFeature;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.world.features.AuroraCrystalFormation;
import io.github.openbagtwo.lighterend.world.features.BuriedBlob;
import io.github.openbagtwo.lighterend.world.features.Geyser;
import io.github.openbagtwo.lighterend.world.features.IceStar;
import io.github.openbagtwo.lighterend.world.features.LotusLeaf;
import io.github.openbagtwo.lighterend.world.features.PurplePolypores;
import io.github.openbagtwo.lighterend.world.features.StarterChest;
import io.github.openbagtwo.lighterend.world.features.SulphurCave;
import io.github.openbagtwo.lighterend.world.features.SulphurLake;
import io.github.openbagtwo.lighterend.world.features.SurfaceVent;
import io.github.openbagtwo.lighterend.world.features.UmbralithArch;
import io.github.openbagtwo.lighterend.world.features.UnderwaterPlants;
import io.github.openbagtwo.lighterend.world.features.trees.DragonTree;
import io.github.openbagtwo.lighterend.world.features.trees.Glowshroom;
import io.github.openbagtwo.lighterend.world.features.trees.TenaneaTree;
import io.github.openbagtwo.lighterend.world.features.trees.UmbrellaTree;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3124;
import net.minecraft.class_3175;
import net.minecraft.class_3819;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5321;
import net.minecraft.class_5927;
import net.minecraft.class_5932;
import net.minecraft.class_6012;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class LighterEndConfiguredFeatures {

  public static final class_5321<class_2975<?, ?>> END_MOSS_PATCH
      = of("end_moss_patch");
  public static final class_5321<class_2975<?, ?>> END_MOSS_PATCH_BONEMEAL
      = of("end_moss_patch_bonemeal");
  public static final class_5321<class_2975<?, ?>> END_MOSS_VEGETATION
      = of("end_moss_vegetation");
  public static final class_5321<class_2975<?, ?>> SHADOW_MOSS_PATCH
      = of("end_moss_patch_shadow");
  public static final class_5321<class_2975<?, ?>> SHADOW_MOSS_PATCH_BONEMEAL
      = of("end_moss_patch_bonemeal_shadow");
  public static final class_5321<class_2975<?, ?>> SHADOW_MOSS_VEGETATION
      = of("end_moss_vegetation_shadow");


  public static final class_3031<class_3111> LUMECORN_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("lumecorn"),
      new Lumecorn.LumecornFeature());
  public static final class_5321<class_2975<?, ?>> LUMECORN = of(
      "lumecorn");

  public static final class_3031<class_3111> TENANEA_TREE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("tenanea_tree"),
      new TenaneaTree());
  public static final class_5321<class_2975<?, ?>> TENANEA_TREE = of(
      "tenanea_tree");

  public static final class_3031<class_3111> UMBRELLA_TREE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("umbrella_tree"),
      new UmbrellaTree());
  public static final class_5321<class_2975<?, ?>> UMBRELLA_TREE = of(
      "umbrella_tree");

  public static final class_3031<class_3111> MOTH_NEST_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("silk_moth_nest"),
      new SilkMothNestFeature()
  );
  public static final class_5321<class_2975<?, ?>> MOTH_NEST = of("silk_moth_nest");

  public static final class_3031<class_3111> UNDERWATER_PLANTS = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("aquatic_end_plants"),
      new UnderwaterPlants()
  );
  public static final class_5321<class_2975<?, ?>> WATER_PLANTS = of("aquatic_end_plants");

  public static final class_3031<class_3111> END_LILY_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("end_lily"),
      new EndLilyFeature());
  public static final class_5321<class_2975<?, ?>> END_LILY = of(
      "end_lily");

  public static final class_3031<class_3111> END_LOTUS_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("end_lotus"),
      new EndLotusFeature());
  public static final class_5321<class_2975<?, ?>> END_LOTUS = of(
      "end_lotus");

  public static final class_3031<class_3111> LOTUS_LEAF_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("end_lotus_leaf"),
      new LotusLeaf());
  public static final class_5321<class_2975<?, ?>> LOTUS_LEAF = of(
      "end_lotus_leaf");

  public static final class_3031<class_3111> ARCH_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("umbralith_arch"),
      new UmbralithArch());
  public static final class_5321<class_2975<?, ?>> UMRBALITH_ARCH = of(
      "umbralith_arch");

  public static final class_3031<class_3111> THIN_ARCH_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("umbralith_arch_thin"),
      new UmbralithArch.Thin());
  public static final class_5321<class_2975<?, ?>> UMRBALITH_ARCH_THIN = of(
      "umbralith_arch_thin");

  public static final class_3031<class_3111> GLOWSHROOM_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("glowshroom"),
      new Glowshroom());
  public static final class_5321<class_2975<?, ?>> GLOWSHROOM = of("glowshroom");

  public static final class_3031<class_3111> AGAVE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("agave"),
      new AgaveFeature()
  );
  public static final class_5321<class_2975<?, ?>> AGAVE = of("agave");

  public static final class_3031<IceStar.Config> ICE_STAR_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("ice_star"),
      new IceStar()
  );
  public static final class_5321<class_2975<?, ?>> ICE_STAR_COPPER = of(
      "ice_star_copper");
  public static final class_5321<class_2975<?, ?>> ICE_STAR_COPPER_SMALL = of(
      "ice_star_copper_small");
  public static final class_5321<class_2975<?, ?>> ICE_STAR_IRON = of(
      "ice_star_iron");
  public static final class_5321<class_2975<?, ?>> ICE_STAR_IRON_SMALL = of(
      "ice_star_iron_small");
  public static final class_5321<class_2975<?, ?>> ICE_STAR_GOLD = of(
      "ice_star_gold");
  public static final class_5321<class_2975<?, ?>> ICE_STAR_GOLD_SMALL = of(
      "ice_star_gold_small");

  public static final class_3031<BuriedBlob.Config> BURIED_BLOB = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("buried_blob"),
      new BuriedBlob()
  );

  public static final List<class_5321<class_2975<?, ?>>> JADESTONE_BLOBS = List.of(
      of("jadestone_blob_azure"),
      of("jadestone_blob_sandy"),
      of("jadestone_blob_virid")
  );

  public static final class_3031<class_3111> AURORA_CRYSTAL_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("aurora_crystal_formation"),
      new AuroraCrystalFormation()
  );

  public static final class_5321<class_2975<?, ?>> AURORA_CRYSTAL = of(
      "aurora_crystal_formation");

  public static final class_5321<class_2975<?, ?>> END_STONE_REDSTONE_ORE = of(
      "end_stone_redstone_ore");
  public static final class_5321<class_2975<?, ?>> END_STONE_QUARTZ_ORE = of(
      "end_stone_quartz_ore");
  public static final class_5321<class_2975<?, ?>> UMBRALITH_REDSTONE_ORE = of(
      "umbralith_redstone_ore");
  public static final class_5321<class_2975<?, ?>> UMBRALITH_QUARTZ_ORE = of(
      "umbralith_quartz_ore");

  public static final class_3031<class_3111> SULPHUR_LAKE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("sulphur_lake"),
      new SulphurLake()
  );
  public static final class_5321<class_2975<?, ?>> SULPHUR_LAKE = of("sulphur_lake");

  public static final class_3031<class_3111> SULPHUR_CAVE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("sulphur_cave"),
      new SulphurCave()
  );
  public static final class_5321<class_2975<?, ?>> SULPHUR_CAVE = of("sulphur_cave");

  public static final class_3031<class_3111> SURFACE_VENT_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("surface_vent"),
      new SurfaceVent()
  );
  public static final class_5321<class_2975<?, ?>> SURFACE_VENT = of("surface_vent");

  public static final class_3031<class_3111> GEYSER_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("geyser"),
      new Geyser()
  );
  public static final class_5321<class_2975<?, ?>> GEYSER = of("geyser");

  public static final class_3031<class_3111> DRAGON_TREE_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("dragon_tree"),
      new DragonTree());
  public static final class_5321<class_2975<?, ?>> DRAGON_TREE = of(
      "dragon_tree");

  public static final class_3031<PurplePolypores.Config> PURPLE_POLYPORES_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("purple_polypores"),
      new PurplePolypores()
  );
  public static final class_5321<class_2975<?, ?>> PURPLE_POLYPORES = of(
      "purple_polypores");

  public static final class_3031<class_3111> STARTER_CHEST_FEATURE = class_2378.method_10230(
      class_7923.field_41144,
      LighterEnd.of("starter_chest"),
      new StarterChest()
  );
  public static final class_5321<class_2975<?, ?>> STARTER_CHEST = of("starter_chest");


  public static void bootstrap(class_7891<class_2975<?, ?>> context) {
    class_7871<class_2975<?, ?>> lookup = context.method_46799(
        class_7924.field_41239
    );

    class_6803.method_39708(
        context,
        END_MOSS_PATCH,
        class_3031.field_13518,
        new class_3175(
            new class_4657(
                class_6012.<class_2680>method_66215()
                    .method_34975(LighterEndBlocks.CREEPING_MOSS.method_9564(), 10)
                    .method_34975(LighterEndBlocks.UMBRELLA_FERN.method_9564(), 10)
                    .method_34975(LighterEndBlocks.LUMECORN_SEED.method_9564(), 1)
            )
        )
    );
    class_6803.method_39708(
        context,
        END_MOSS_VEGETATION,
        class_3031.field_13518,
        new class_3175(
            new class_4657(
                class_6012.<class_2680>method_66215()
                    .method_34975(LighterEndBlocks.CREEPING_MOSS.method_9564(), 10)
                    .method_34975(LighterEndBlocks.UMBRELLA_FERN.method_9564(), 10)
            )
        )
    );
    class_6803.method_39708(
        context,
        END_MOSS_PATCH_BONEMEAL,
        class_3031.field_29250,
        new class_5927(
            LighterEndTags.END_MOSS_REPLACEABLE,
            class_4651.method_38432(LighterEndBlocks.END_MOSS),
            class_6817.method_40369(
                lookup.method_46747(END_MOSS_PATCH)
            ),
            class_5932.field_29314,
            class_6016.method_34998(1),
            0.0F,
            2,
            0.1F,
            class_6019.method_35017(0, 1),
            0.25F)
    );

    class_6803.method_39708(
        context,
        SHADOW_MOSS_PATCH,
        class_3031.field_13518,
        new class_3175(
            new class_4657(
                class_6012.<class_2680>method_66215()
                    .method_34975(LighterEndBlocks.SHADOW_GRASS.method_9564(), 40)
                    .method_34975(LighterEndBlocks.NEEDLEGRASS.method_9564(), 20)
                    .method_34975(
                        LighterEndBlocks.SHADOW_BERRY.method_9564().method_11657(ShadowBerry.field_10835, 0),
                        20)
                    .method_34975(LighterEndBlocks.MURKWEED.method_9564(), 20)
            )
        )
    );
    class_6803.method_39708(
        context,
        SHADOW_MOSS_VEGETATION,
        class_3031.field_13518,
        new class_3175(
            new class_4657(
                class_6012.<class_2680>method_66215()
                    .method_34975(LighterEndBlocks.SHADOW_GRASS.method_9564(), 40)
                    .method_34975(LighterEndBlocks.NEEDLEGRASS.method_9564(), 40)
                    .method_34975(
                        LighterEndBlocks.SHADOW_BERRY.method_9564()
                            .method_11657(ShadowBerry.field_10835, ShadowBerry.field_31079),
                        10
                    ).method_34975(LighterEndBlocks.MURKWEED.method_9564(), 10)
            )
        )
    );
    class_6803.method_39708(
        context,
        SHADOW_MOSS_PATCH_BONEMEAL,
        class_3031.field_29250,
        new class_5927(
            LighterEndTags.END_MOSS_REPLACEABLE,
            class_4651.method_38432(LighterEndBlocks.END_MOSS),
            class_6817.method_40369(
                lookup.method_46747(SHADOW_MOSS_PATCH)
            ),
            class_5932.field_29314,
            class_6016.method_34998(1),
            0.0F,
            2,
            0.1F,
            class_6019.method_35017(0, 1),
            0.25F)
    );

    class_6803.method_40364(context, LUMECORN, LUMECORN_FEATURE);
    class_6803.method_40364(context, TENANEA_TREE, TENANEA_TREE_FEATURE);
    class_6803.method_40364(context, MOTH_NEST, MOTH_NEST_FEATURE);
    class_6803.method_40364(context, UMBRELLA_TREE, UMBRELLA_TREE_FEATURE);
    class_6803.method_40364(context, WATER_PLANTS, UNDERWATER_PLANTS);
    class_6803.method_40364(context, END_LILY, END_LILY_FEATURE);
    class_6803.method_40364(context, END_LOTUS, END_LOTUS_FEATURE);
    class_6803.method_40364(context, LOTUS_LEAF, LOTUS_LEAF_FEATURE);
    class_6803.method_40364(context, UMRBALITH_ARCH, ARCH_FEATURE);
    class_6803.method_40364(context, UMRBALITH_ARCH_THIN, THIN_ARCH_FEATURE);
    class_6803.method_40364(context, GLOWSHROOM, GLOWSHROOM_FEATURE);
    class_6803.method_40364(context, AGAVE, AGAVE_FEATURE);

    class_6803.method_39708(
        context,
        ICE_STAR_COPPER,
        ICE_STAR_FEATURE,
        new IceStar.Config(0, 5, 15, 10, 25)
    );
    class_6803.method_39708(
        context,
        ICE_STAR_COPPER_SMALL,
        ICE_STAR_FEATURE,
        new IceStar.Config(0, 3, 5, 7, 12)
    );
    class_6803.method_39708(
        context,
        ICE_STAR_IRON,
        ICE_STAR_FEATURE,
        new IceStar.Config(1, 5, 15, 10, 25)
    );
    class_6803.method_39708(
        context,
        ICE_STAR_IRON_SMALL,
        ICE_STAR_FEATURE,
        new IceStar.Config(1, 3, 5, 7, 12)
    );
    class_6803.method_39708(
        context,
        ICE_STAR_GOLD,
        ICE_STAR_FEATURE,
        new IceStar.Config(2, 5, 15, 10, 25)
    );
    class_6803.method_39708(
        context,
        ICE_STAR_GOLD_SMALL,
        ICE_STAR_FEATURE,
        new IceStar.Config(2, 3, 5, 7, 12)
    );

    class_6803.method_39708(
        context,
        JADESTONE_BLOBS.get(0),
        BURIED_BLOB,
        new BuriedBlob.Config(
            class_2246.field_10471.method_9564(),
            LighterEndBlocks.AZURE_JADESTONE.baseBlock.method_9564(),
            class_6019.method_35017(3, 7),
            6
        )
    );
    class_6803.method_39708(
        context,
        JADESTONE_BLOBS.get(1),
        BURIED_BLOB,
        new BuriedBlob.Config(
            class_2246.field_10471.method_9564(),
            LighterEndBlocks.SANDY_JADESTONE.baseBlock.method_9564(),
            class_6019.method_35017(3, 7),
            6
        )
    );
    class_6803.method_39708(
        context,
        JADESTONE_BLOBS.get(2),
        BURIED_BLOB,
        new BuriedBlob.Config(
            class_2246.field_10471.method_9564(),
            LighterEndBlocks.VIRID_JADESTONE.baseBlock.method_9564(),
            class_6019.method_35017(3, 7),
            6
        )
    );

    class_6803.method_40364(context, AURORA_CRYSTAL, AURORA_CRYSTAL_FEATURE);

    class_6803.method_39708(
        context,
        END_STONE_REDSTONE_ORE,
        class_3031.field_13517,
        new class_3124(
            new class_3819(class_2246.field_10471),
            LighterEndBlocks.END_STONE_REDSTONE_ORE.method_9564(),
            5
        )
    );
    class_6803.method_39708(
        context,
        END_STONE_QUARTZ_ORE,
        class_3031.field_13517,
        new class_3124(
            new class_3819(class_2246.field_10471),
            LighterEndBlocks.END_STONE_QUARTZ_ORE.method_9564(),
            7
        )
    );

    class_6803.method_39708(
        context,
        UMBRALITH_REDSTONE_ORE,
        class_3031.field_13517,
        new class_3124(
            new class_3819(LighterEndBlocks.UMBRALITH.baseBlock),
            LighterEndBlocks.UMBRALITH_REDSTONE_ORE.method_9564(),
            5
        )
    );
    class_6803.method_39708(
        context,
        UMBRALITH_QUARTZ_ORE,
        class_3031.field_13517,
        new class_3124(
            new class_3819(LighterEndBlocks.UMBRALITH.baseBlock),
            LighterEndBlocks.UMBRALITH_QUARTZ_ORE.method_9564(),
            7
        )
    );

    class_6803.method_40364(context, SULPHUR_LAKE, SULPHUR_LAKE_FEATURE);
    class_6803.method_40364(context, SULPHUR_CAVE, SULPHUR_CAVE_FEATURE);
    class_6803.method_40364(context, SURFACE_VENT, SURFACE_VENT_FEATURE);
    class_6803.method_40364(context, GEYSER, GEYSER_FEATURE);

    class_6803.method_40364(context, DRAGON_TREE, DRAGON_TREE_FEATURE);
    class_6803.method_39708(
        context,
        PURPLE_POLYPORES,
        PURPLE_POLYPORES_FEATURE,
        new PurplePolypores.Config(3)
    );

    class_6803.method_40364(context, STARTER_CHEST, STARTER_CHEST_FEATURE);
  }

  public static void initialize() {
  }

  public static class_5321<class_2975<?, ?>> of(String id) {
    return class_5321.method_29179(class_7924.field_41239, LighterEnd.of(id));
  }
}
