package io.github.openbagtwo.lighterend.world;

import com.mojang.datafixers.util.Pair;
import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import java.util.List;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5843;
import net.minecraft.class_6019;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class LighterEndPlacedFeatures {

  public static final class_5321<class_6796> END_MOSS_VEGETATION = of("end_moss_vegetation");
  public static final class_5321<class_6796> LUMECORN = of("lumecorn");
  public static final class_5321<class_6796> TENANEA_TREE = of("tenanea_tree");
  public static final class_5321<class_6796> MOTH_NEST = of("moth_nest");
  public static final class_5321<class_6796> UMBRELLA_TREE = of("umbrella_tree");
  public static final class_5321<class_6796> WATER_PLANTS = of("aquatic_end_plants");
  public static final class_5321<class_6796> END_LILY = of("end_lily");
  public static final class_5321<class_6796> END_LOTUS = of("end_lotus");
  public static final class_5321<class_6796> LOTUS_LEAF = of("end_lotus_leaf");
  public static final class_5321<class_6796> UMBRALITH_ARCH = of("umbralith_arch");
  public static final class_5321<class_6796> UMBRALITH_ARCH_THIN = of("umbralith_arch_thin");
  public static final class_5321<class_6796> GLOWSHROOM = of("glowshroom");
  public static final class_5321<class_6796> AGAVE = of("agave");
  public static final List<class_5321<class_6796>> BARRENS_ICE_STARS = List.of(
      of("barrens_ice_star_copper"),
      of("barrens_ice_star_copper_small"),
      of("barrens_ice_star_iron"),
      of("barrens_ice_star_iron_small"),
      of("barrens_ice_star_gold"),
      of("barrens_ice_star_gold_small")
  );
  public static final List<class_5321<class_6796>> STARFIELD_ICE_STARS = List.of(
      of("starfield_ice_star_copper"),
      of("starfield_ice_star_copper_small"),
      of("starfield_ice_star_iron"),
      of("starfield_ice_star_iron_small"),
      of("starfield_ice_star_gold"),
      of("starfield_ice_star_gold_small")
  );
  public static final List<class_5321<class_6796>> JADESTONE_BLOBS = List.of(
      of("jadestone_blob_azure"),
      of("jadestone_blob_sandy"),
      of("jadestone_blob_virid")
  );
  public static final List<class_5321<class_6796>> JADESTONE_BLOBS_BM = List.of(
      of("jadestone_blob_azure_bm"),
      of("jadestone_blob_sandy_bm"),
      of("jadestone_blob_virid_bm")
  );

  public static final class_5321<class_6796> AURORA_CRYSTAL = of("aurora_crystal_formation");
  public static final class_5321<class_6796> END_STONE_REDSTONE_ORE = of(
      "end_stone_redstone_ore");
  public static final class_5321<class_6796> END_STONE_QUARTZ_ORE = of("end_stone_quartz_ore");
  public static final class_5321<class_6796> UMBRALITH_REDSTONE_ORE = of(
      "umbralith_redstone_ore");
  public static final class_5321<class_6796> UMBRALITH_QUARTZ_ORE = of("umbralith_quartz_ore");

  public static final class_5321<class_6796> SULPHUR_LAKE = of("sulphur_lake");
  public static final class_5321<class_6796> SULPHUR_CAVE = of("sulphur_cave");
  public static final class_5321<class_6796> SURFACE_VENT = of("surface_vent");
  public static final class_5321<class_6796> GEYSER = of("geyser");

  public static final class_5321<class_6796> DRAGON_TREE = of("dragon_tree");
  public static final class_5321<class_6796> SHADOW_FOREST_VEGETATION = of(
      "shadow_forest_vegetation"
  );
  public static final class_5321<class_6796> PURPLE_POLYPORES = of("purple_polypores");


  public static void bootstrap(class_7891<class_6796> context) {

    var configuredFeatures = context.method_46799(class_7924.field_41239);

    context.method_46838(
        END_MOSS_VEGETATION,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.END_MOSS_VEGETATION),
            List.of(
                class_6793.method_39623(20),
                class_5450.method_39639(),
                class_6817.field_36078,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        LUMECORN,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.LUMECORN),
            class_6819.method_39741(
                class_6817.method_39736(3, 0.5f, 2),
                LighterEndBlocks.LUMECORN_SEED)
        )
    );
    context.method_46838(
        TENANEA_TREE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.TENANEA_TREE),
            class_6819.method_39741(
                class_6817.method_39736(10, 0.5f, 2),
                LighterEndBlocks.TENANEA_SAPLING)
        )
    );
    context.method_46838(
        MOTH_NEST,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.MOTH_NEST),
            class_6819.method_39738(2)
        )
    );
    context.method_46838(
        UMBRELLA_TREE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.UMBRELLA_TREE),
            class_6819.method_39741(
                class_6817.method_39736(1, 0.1f, 1),
                LighterEndBlocks.UMBRELLA_TREE_SAPLING
            )
        )
    );
    context.method_46838(
        WATER_PLANTS,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.WATER_PLANTS),
            List.of(
                class_5450.method_39639(),
                class_6817.field_36081,
                class_6793.method_39623(30),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        END_LILY,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.END_LILY),
            List.of(
                class_6793.method_39624(class_6019.method_35017(6, 18)),
                class_5450.method_39639(),
                class_6817.field_36081,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        END_LOTUS,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.END_LOTUS),
            List.of(
                class_6793.method_39624(class_6019.method_35017(4, 12)),
                class_5450.method_39639(),
                class_6817.field_36081,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        LOTUS_LEAF,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.LOTUS_LEAF),
            List.of(
                class_6793.method_39624(class_6019.method_35017(4, 12)),
                class_5450.method_39639(),
                class_6817.field_36080,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        UMBRALITH_ARCH,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.UMRBALITH_ARCH),
            List.of(
                class_6799.method_39659(20),
                class_6817.field_36080,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        UMBRALITH_ARCH_THIN,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.UMRBALITH_ARCH_THIN),
            List.of(
                class_6799.method_39659(20),
                class_6817.field_36080,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        GLOWSHROOM,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.GLOWSHROOM),
            class_6819.method_39741(
                class_6799.method_39659(8),
                LighterEndBlocks.GLOWSHROOM_SAPLING
            )
        )
    );
    context.method_46838(
        AGAVE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.AGAVE),
            class_6819.method_39741(
                class_6817.method_39736(3, 0.5f, 2),
                LighterEndBlocks.AGAVE_SEED)
        )
    );

    for (Pair<Integer, List<class_5321<class_6796>>> pair : List.of(
        Pair.of(32, STARFIELD_ICE_STARS),
        Pair.of(1024, BARRENS_ICE_STARS)
    )) {
      int rarity = pair.getFirst();
      List<class_5321<class_6796>> features = pair.getSecond();

      context.method_46838(
          features.get(0),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_COPPER),
              List.of(
                  class_6799.method_39659(rarity * 2),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
      context.method_46838(
          features.get(1),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_COPPER_SMALL),
              List.of(
                  class_6799.method_39659(rarity),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
      context.method_46838(
          features.get(2),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_IRON),
              List.of(
                  class_6799.method_39659(rarity * 2),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
      context.method_46838(
          features.get(3),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_IRON_SMALL),
              List.of(
                  class_6799.method_39659(rarity),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
      context.method_46838(
          features.get(4),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_GOLD),
              List.of(
                  class_6799.method_39659(rarity * 2),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
      context.method_46838(
          features.get(5),
          new class_6796(
              configuredFeatures.method_46747(LighterEndConfiguredFeatures.ICE_STAR_GOLD_SMALL),
              List.of(
                  class_6799.method_39659(rarity),
                  class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(256)),
                  class_5450.method_39639()
                  // lack of BiomePlacementModifier is intentional--the effects are dramatic
              )
          )
      );
    }

    for (List<class_5321<class_6796>> blobs : List.of(JADESTONE_BLOBS, JADESTONE_BLOBS_BM)) {
      for (int i = 0; i < 3; i++) {
        context.method_46838(
            blobs.get(i),
            new class_6796(
                configuredFeatures.method_46747(LighterEndConfiguredFeatures.JADESTONE_BLOBS.get(i)),
                List.of(
                    class_6793.method_39623(5),
                    class_5450.method_39639(),
                    class_6817.field_36082,
                    class_6792.method_39614()
                )
            )
        );
      }
    }
    context.method_46838(
        AURORA_CRYSTAL,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.AURORA_CRYSTAL),
            List.of(
                class_6799.method_39659(16),
                class_6817.field_36080,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        END_STONE_REDSTONE_ORE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.END_STONE_REDSTONE_ORE),
            List.of(
                class_6793.method_39623(10),
                class_5450.method_39639(),
                class_6817.field_36082,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        END_STONE_QUARTZ_ORE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.END_STONE_QUARTZ_ORE),
            List.of(
                class_6793.method_39623(10),
                class_5450.method_39639(),
                class_6817.field_36082,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        UMBRALITH_REDSTONE_ORE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.UMBRALITH_REDSTONE_ORE),
            List.of(
                class_6793.method_39623(20),
                class_5450.method_39639(),
                class_6817.field_36082,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        UMBRALITH_QUARTZ_ORE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.UMBRALITH_QUARTZ_ORE),
            List.of(
                class_6793.method_39623(20),
                class_5450.method_39639(),
                class_6817.field_36082,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        SULPHUR_LAKE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.SULPHUR_LAKE),
            List.of(
                class_6799.method_39659(8),
                class_6817.field_36080,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        SULPHUR_CAVE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.SULPHUR_CAVE),
            List.of(
                class_6793.method_39623(2),
                class_6817.field_36082,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        SURFACE_VENT,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.SURFACE_VENT),
            List.of(
                class_6799.method_39659(2),
                class_6817.field_36080,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        GEYSER,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.GEYSER),
            List.of(
                class_6799.method_39659(8),
                class_6817.field_36080,
                class_5450.method_39639(),
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        SHADOW_FOREST_VEGETATION,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.SHADOW_MOSS_VEGETATION),
            List.of(
                class_6793.method_39623(32),
                class_5450.method_39639(),
                class_6817.field_36080,
                class_6792.method_39614()
            )
        )
    );
    context.method_46838(
        DRAGON_TREE,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.DRAGON_TREE),
            class_6819.method_39741(
                class_6817.method_39736(10, 0.5f, 2),
                LighterEndBlocks.DRAGON_SAPLING)
        )
    );
    context.method_46838(
        PURPLE_POLYPORES,
        new class_6796(
            configuredFeatures.method_46747(LighterEndConfiguredFeatures.PURPLE_POLYPORES),
            List.of(
                class_6793.method_39623(5),
                class_5450.method_39639(),
                class_6817.field_36080,
                class_6792.method_39614()
            )
        )
    );


  }

  public static class_5321<class_6796> of(String id) {
    return class_5321.method_29179(class_7924.field_41245, LighterEnd.of(id));
  }

}
