package io.github.openbagtwo.lighterend.world.features;

import com.google.common.collect.Sets;
import io.github.openbagtwo.lighterend.BlockFixer;
import io.github.openbagtwo.lighterend.blocks.HydrothermalVent;
import io.github.openbagtwo.lighterend.blocks.TubeWorm;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class SulphurCave extends class_3031<class_3111> {

  public SulphurCave() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> context) {
    final class_5819 random = context.method_33654();
    class_2338 pos = context.method_33655();
    final class_5281 world = context.method_33652();
    int radius = class_3532.method_15395(random, 10, 30);

    int top = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
    class_2339 bpos = new class_2339();
    bpos.method_33097(pos.method_10263());
    bpos.method_33099(pos.method_10260());
    bpos.method_33098(top - 1);

    class_2680 state = world.method_8320(bpos);
    while (!state.method_26164(LighterEndTags.END_STONES) && bpos.method_10264() > 5) {
      bpos.method_33098(bpos.method_10264() - 1);
      state = world.method_8320(bpos);
    }
    if (bpos.method_10264() < 10) {
      return false;
    }
    top = (int) (bpos.method_10264() - (radius * 1.3F + 5));

    while (state.method_26164(LighterEndTags.END_STONES)
        || !state.method_26227().method_15769() && bpos.method_10264() > 5) {
      bpos.method_33098(bpos.method_10264() - 1);
      state = world.method_8320(bpos);
    }
    int bottom = (int) (bpos.method_10264() + radius * 1.3F + 5);

    if (top <= bottom) {
      return false;
    }

    class_2339 mut = new class_2339();
    pos = new class_2338(pos.method_10263(), class_3532.method_15395(random, bottom, top), pos.method_10260());

    OpenSimplexNoise noise = new OpenSimplexNoise(MathUtils.getSeed(534, pos.method_10263(), pos.method_10260()));

    int x1 = pos.method_10263() - radius - 5;
    int z1 = pos.method_10260() - radius - 5;
    int x2 = pos.method_10263() + radius + 5;
    int z2 = pos.method_10260() + radius + 5;
    int y1 = class_3532.method_15357(pos.method_10264() - (radius + 5) / 1.6);
    int y2 = class_3532.method_15357(pos.method_10264() + (radius + 5) / 1.6);

    double hr = radius * 0.75;
    double nr = radius * 0.25;

    Set<class_2338> brimstone = Sets.newHashSet();
    class_2680 rock = LighterEndBlocks.BORNITE.baseBlock.method_9564();
    int waterLevel = pos.method_10264()
        + class_3532.method_15395(random, class_3532.method_15357(radius * 0.8), radius);
    for (int x = x1; x <= x2; x++) {
      int xsq = x - pos.method_10263();
      xsq *= xsq;
      mut.method_33097(x);
      for (int z = z1; z <= z2; z++) {
        int zsq = z - pos.method_10260();
        zsq *= zsq;
        mut.method_33099(z);
        for (int y = y1; y <= y2; y++) {
          int ysq = y - pos.method_10264();
          ysq *= 1.6;
          ysq *= ysq;
          mut.method_33098(y);
          double r = noise.eval(x * 0.1, y * 0.1, z * 0.1) * nr + hr;
          double r2 = r + 5;
          double dist = xsq + ysq + zsq;
          if (dist < r * r) {
            state = world.method_8320(mut);
            if (isReplaceable(state)) {
              world.method_8652(
                  mut,
                  y < waterLevel ? class_2246.field_10382.method_9564()
                      : class_2246.field_10543.method_9564(),
                  Flags.SILENT
              );
            }
          } else if (dist < r2 * r2) {
            state = world.method_8320(mut);
            if (state.method_26164(LighterEndTags.END_STONES) || state.method_27852(class_2246.field_10124)) {
              double v = noise.eval(x * 0.1, y * 0.1, z * 0.1) + noise.eval(
                  x * 0.03,
                  y * 0.03,
                  z * 0.03
              ) * 0.5;
              if (v > 0.4) {
                brimstone.add(mut.method_10062());
              } else {
                world.method_8652(mut, rock, Flags.SILENT);
              }
            }
          }
        }
      }
    }
    brimstone.forEach((blockPos) -> {
      SulphurLake.placeBrimstone(world, blockPos, random);
    });

    if (random.method_43048(4) == 0) {
      int count = class_3532.method_15395(random, 5, 20);
      for (int i = 0; i < count; i++) {
        mut.method_10101(pos)
            .method_10100(
                class_3532.method_15357(random.method_43059() * 2 + 0.5),
                0,
                class_3532.method_15357(random.method_43059() * 2 + 0.5)
            );
        int dist = class_3532.method_15357(
            3 - Math.sqrt(
                Math.pow(mut.method_10263() - pos.method_10263(), 2) + Math.pow(mut.method_10260() - pos.method_10260(), 2))
        ) + random.method_43048(2);
        if (dist > 0) {
          state = world.method_8320(mut);
          while (
              !state.method_26227().method_15769() || state.method_26164(LighterEndTags.AQUATIC_END_VEGETATION)
          ) {
            mut.method_33098(mut.method_10264() - 1);
            state = world.method_8320(mut);
          }
          if (
              state.method_26164(LighterEndTags.END_STONES)
                  && !world.method_8320(mut.method_10084()).method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)
          ) {
            for (int j = 0; j <= dist; j++) {
              world.method_8652(
                  mut,
                  LighterEndBlocks.BORNITE.baseBlock.method_9564(),
                  Flags.SILENT
              );
              for (class_2350 dir : class_2350.class_2353.field_11062.method_43342(random)) {
                class_2338 p = mut.method_10093(dir);
                if (random.method_43056() && world.method_8320(p).method_27852(class_2246.field_10382)) {
                  world.method_8652(
                      p,
                      LighterEndBlocks.TUBE_WORM.method_9564().method_11657(TubeWorm.FACING, dir),
                      Flags.SILENT
                  );
                }
              }
              mut.method_33098(mut.method_10264() + 1);
            }
            world.method_8652(
                mut,
                LighterEndBlocks.HYDROTHERMAL_VENT.method_9564()
                    .method_11657(HydrothermalVent.ACTIVATED, false)
                    .method_11657(HydrothermalVent.WATERLOGGED, true),
                Flags.SILENT
            );
            mut.method_33098(mut.method_10264() + 1);
            state = world.method_8320(mut);
            while (state.method_27852(class_2246.field_10382)) {
              world.method_8652(
                  mut,
                  LighterEndBlocks.VENT_BUBBLE_COLUMN.method_9564(),
                  Flags.SILENT
              );
              world.method_39283(
                  mut.method_10062(),
                  LighterEndBlocks.VENT_BUBBLE_COLUMN,
                  class_3532.method_15395(random, 8, 32)
              );
              mut.method_33098(mut.method_10264() + 1);
              state = world.method_8320(mut);
            }
          }
        }
      }
    }

    BlockFixer.fixBlocks(world, new class_2338(x1, y1, z1), new class_2338(x2, y2, z2));

    return true;
  }

  private static boolean isReplaceable(class_2680 state) {
    return state.method_26164(LighterEndTags.END_STONES)
        || state.method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)
        || state.method_27852(LighterEndBlocks.VENT_BUBBLE_COLUMN)
        || state.method_27852(LighterEndBlocks.SULPHUR_CRYSTAL)
        || MiscUtils.replaceableOrPlant(state)
        || state.method_26164(LighterEndTags.AQUATIC_END_VEGETATION)
        || state.method_26164(class_3481.field_15503);
  }

}
