package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class DragonTree extends class_3031<class_3111> {

  private static final Function<class_2680, Boolean> REPLACE;
  private static final Function<class_2680, Boolean> IGNORE;
  private static final Function<PosInfo, class_2680> POST;
  private static final List<Vector3f> BRANCH;
  private static final List<Vector3f> SIDE1;
  private static final List<Vector3f> SIDE2;
  private static final List<Vector3f> ROOT;

  public DragonTree() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featureConfig) {
    final class_5819 random = featureConfig.method_33654();
    final class_2338 pos = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();
    if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
      return false;
    }

    float size = class_3532.method_15344(random, 10, 25);
    List<Vector3f> spline = MathUtils.makeSpline(0, 0, 0, 0, size, 0, 6);
    MathUtils.offsetParts(spline, random, 1F, 0, 1F);

    if (!MathUtils.canGenerate(spline, pos, world, REPLACE)) {
      return false;
    }
    world.method_8652(pos, class_2246.field_10124.method_9564(), Flags.SILENT);

    Vector3f last = MathUtils.getPos(spline, 3.5F);
    OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
    float radius = size * class_3532.method_15344(random, 0.5F, 0.7F);
    makeCap(world, pos.method_10069((int) last.x(), (int) last.y(), (int) last.z()), radius, random, noise);

    last = spline.get(0);
    makeRoots(world, pos.method_10069((int) last.x(), (int) last.y(), (int) last.z()), radius, random);

    radius = class_3532.method_15344(random, 1.2F, 2.3F);
    SDF function = MathUtils.buildSDF(
        spline,
        radius,
        1.2F,
        (bpos) -> LighterEndBlocks.DRAGON.wood.method_9564()
    );

    function.setReplaceFunction(REPLACE);
    function.addPostProcess(POST);
    function.fillRecursiveIgnore(world, pos, IGNORE);

    return true;
  }

  private void makeCap(class_5281 world, class_2338 pos, float radius, class_5819 random,
      OpenSimplexNoise noise) {
    int count = (int) radius;
    int offset = (int) (BRANCH.get(BRANCH.size() - 1).y() * radius);
    for (int i = 0; i < count; i++) {
      float angle = (float) i / (float) count * class_3532.field_29846;
      float scale = radius * class_3532.method_15344(random, 0.85F, 1.15F);

      List<Vector3f> branch = MathUtils.copySpline(BRANCH);
      MathUtils.rotateSpline(branch, angle);
      MathUtils.scale(branch, scale);
      MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos,
          REPLACE);

      branch = MathUtils.copySpline(SIDE1);
      MathUtils.rotateSpline(branch, angle);
      MathUtils.scale(branch, scale);
      MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos,
          REPLACE);

      branch = MathUtils.copySpline(SIDE2);
      MathUtils.rotateSpline(branch, angle);
      MathUtils.scale(branch, scale);
      MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos,
          REPLACE);
    }
    leavesBall(world, pos.method_10086(offset), radius * 1.15F + 2, random, noise);
  }

  private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random) {
    int count = (int) (radius * 1.5F);
    for (int i = 0; i < count; i++) {
      float angle = (float) i / (float) count * class_3532.field_29846;
      float scale = radius * class_3532.method_15344(random, 0.85F, 1.15F);

      List<Vector3f> branch = MathUtils.copySpline(ROOT);
      MathUtils.rotateSpline(branch, angle);
      MathUtils.scale(branch, scale);
      Vector3f last = branch.get(branch.size() - 1);
      if (world.method_8320(pos.method_10069((int) last.x(), (int) last.y(), (int) last.z()))
          .method_26164(LighterEndTags.END_STONES)) {
        MathUtils.fillSpline(
            branch,
            world,
            LighterEndBlocks.DRAGON.wood.method_9564(),
            pos,
            REPLACE
        );
      }
    }
  }

  private void leavesBall(
      class_5281 world,
      class_2338 pos,
      float radius,
      class_5819 random,
      OpenSimplexNoise noise
  ) {
    SDF sphere = new SDFSphere().setRadius(radius)
        .setBlock(LighterEndBlocks.DRAGON_LEAVES.method_9564()
            .method_11657(class_2397.field_11199, 6));
    SDF sub = new SDFScale().setScale(5).setSource(sphere);
    sub = new SDFTranslate().setTranslate(0, -radius * 5, 0).setSource(sub);
    sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
    sphere = new SDFScale3D().setScale(1, 0.5F, 1).setSource(sphere);
    sphere = new SDFDisplace().setFunction((vec) -> (float) noise.eval(
        vec.x() * 0.2,
        vec.y() * 0.2,
        vec.z() * 0.2
    ) * 1.5F).setSource(sphere);
    sphere = new SDFDisplace().setFunction((vec) -> random.method_43057() * 3F - 1.5F)
        .setSource(sphere);
    class_2339 mut = new class_2339();
    sphere.addPostProcess((info) -> {
      if (random.method_43048(5) == 0) {
        for (class_2350 dir : class_2350.values()) {
          class_2680 state = info.getState(dir, 2);
          if (state.method_26215()) {
            return info.getState();
          }
        }
        info.setState(LighterEndBlocks.DRAGON.wood.method_9564());
        for (int x = -6; x < 7; x++) {
          int ax = Math.abs(x);
          mut.method_33097(x + info.getPos().method_10263());
          for (int z = -6; z < 7; z++) {
            int az = Math.abs(z);
            mut.method_33099(z + info.getPos().method_10260());
            for (int y = -6; y < 7; y++) {
              int ay = Math.abs(y);
              int d = ax + ay + az;
              if (d < 7) {
                mut.method_33098(y + info.getPos().method_10264());
                class_2680 state = info.getState(mut);
                if (state.method_26204() instanceof class_2397) {
                  int distance = state.method_11654(class_2397.field_11199);
                  if (d < distance) {
                    info.setState(mut, state.method_11657(class_2397.field_11199, d));
                  }
                }
              }
            }
          }
        }
      }
      return info.getState();
    });
    sphere.fillRecursiveIgnore(world, pos, IGNORE);

    if (radius > 5) {
      int count = (int) (radius * 2.5F);
      for (int i = 0; i < count; i++) {
        class_2338 p = pos.method_10069(
            (int) (random.method_43059() * 1),
            (int) (random.method_43059() * 1),
            (int) (random.method_43059() * 1)
        );
        boolean place = true;
        for (class_2350 d : class_2350.values()) {
          class_2680 state = world.method_8320(p.method_10093(d));
          if (
              !state.method_27852(LighterEndBlocks.DRAGON.wood)
                  && !state.method_27852(LighterEndBlocks.DRAGON.log)
                  && !state.method_27852(LighterEndBlocks.DRAGON_LEAVES)
          ) {
            place = false;
            break;
          }
        }
        if (place) {
          world.method_8652(p, LighterEndBlocks.DRAGON.wood.method_9564(), Flags.SILENT);
        }
      }
    }

    world.method_8652(pos, LighterEndBlocks.DRAGON.wood.method_9564(), Flags.SILENT);
  }

  static {
    REPLACE = (state) -> {
			/*if (state.is(CommonBlockTags.END_STONES)) {
				return true;
			}*/
      if (state.method_26204() == LighterEndBlocks.DRAGON_LEAVES) {
        return true;
      }
      return MiscUtils.replaceableOrPlant(state);
    };

    IGNORE = state -> (
        state.method_27852(LighterEndBlocks.DRAGON.wood) || state.method_27852(LighterEndBlocks.DRAGON.log)
    );

    POST = (info) -> {
      if (
          (
              info.getStateUp().method_27852(LighterEndBlocks.DRAGON.wood)
                  || info.getStateUp().method_27852(LighterEndBlocks.DRAGON.log)
          ) && (
              info.getStateDown().method_27852(LighterEndBlocks.DRAGON.wood)
                  || info.getStateUp().method_27852(LighterEndBlocks.DRAGON.log)
          )
      ) {
        return LighterEndBlocks.DRAGON.log.method_9564();
      }

      return info.getState();
    };

    BRANCH = Lists.newArrayList(
        new Vector3f(0, 0, 0),
        new Vector3f(0.1F, 0.3F, 0),
        new Vector3f(0.4F, 0.6F, 0),
        new Vector3f(0.8F, 0.8F, 0),
        new Vector3f(1, 1, 0)
    );
    SIDE1 = Lists.newArrayList(new Vector3f(0.4F, 0.6F, 0), new Vector3f(0.8F, 0.8F, 0),
        new Vector3f(1, 1, 0));
    SIDE2 = MathUtils.copySpline(SIDE1);

    Vector3f offset1 = new Vector3f(-0.4F, -0.6F, 0);
    Vector3f offset2 = new Vector3f(0.4F, 0.6F, 0);

    MathUtils.offset(SIDE1, offset1);
    MathUtils.offset(SIDE2, offset1);
    MathUtils.rotateSpline(SIDE1, 0.5F);
    MathUtils.rotateSpline(SIDE2, -0.5F);
    MathUtils.offset(SIDE1, offset2);
    MathUtils.offset(SIDE2, offset2);

    ROOT = Lists.newArrayList(
        new Vector3f(0F, 1F, 0),
        new Vector3f(0.1F, 0.7F, 0),
        new Vector3f(0.3F, 0.3F, 0),
        new Vector3f(0.7F, 0.05F, 0),
        new Vector3f(0.8F, -0.2F, 0)
    );
    MathUtils.offset(ROOT, new Vector3f(0, -0.45F, 0));
  }

}
