/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2473;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6908;
import net.minecraft.class_8813;

public class Lumecorn
extends class_2248 {
    public static final class_2754<LumecornShape> SHAPE = class_2754.method_11850((String)"shape", LumecornShape.class);
    private static final class_265 SHAPE_BOTTOM = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SHAPE_TOP = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
    public static final class_8813 LUMECORN_GENERATOR = new class_8813("lighterend:lumecorn", Optional.empty(), Optional.empty(), Optional.empty());

    public Lumecorn(class_4970.class_2251 settings) {
        super(settings.method_31710(class_3620.field_25708).method_51368(class_2766.field_12651).method_9626(class_2498.field_11547).method_9632(0.2f).method_50013().method_9631(bs -> ((LumecornShape)((Object)((Object)bs.method_11654(SHAPE)))).getLight()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return state.method_11654(SHAPE) == LumecornShape.LIGHT_TOP ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        LumecornShape shape = (LumecornShape)((Object)state.method_11654(SHAPE));
        if (shape == LumecornShape.LIGHT_TOP) {
            return world.method_8320(pos.method_10074()).method_27852((class_2248)this) || world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.LUMECORN_STEM);
        }
        return (world.method_8320(pos.method_10074()).method_27852((class_2248)this) || world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.LUMECORN_STEM)) && world.method_8320(pos.method_10084()).method_27852((class_2248)this);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799((class_1935)LighterEndItems.LUMECORN_EAR);
    }

    public static enum LumecornShape implements class_3542
    {
        LIGHT_TOP("light_top", 15),
        LIGHT_TOP_MIDDLE("light_top_middle", 15),
        LIGHT_MIDDLE("light_middle", 15),
        LIGHT_BOTTOM("light_bottom", 15),
        MIDDLE("middle", 0),
        BOTTOM_BIG("bottom_big", 0),
        BOTTOM_SMALL("bottom_small", 0);

        private final String name;
        private final int light;

        private LumecornShape(String name, int light) {
            this.name = name;
            this.light = light;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }
    }

    public static class LumecornFeature
    extends class_3031<class_3111> {
        public LumecornFeature() {
            super(class_3111.field_24893);
        }

        public boolean method_13151(class_5821<class_3111> featureConfig) {
            class_5819 random = featureConfig.method_33654();
            class_2338 pos = featureConfig.method_33655();
            class_5281 world = featureConfig.method_33652();
            int height = random.method_39332(4, 7);
            class_2338.class_2339 mut = new class_2338.class_2339().method_10101((class_2382)pos);
            for (int i = 1; i < height; ++i) {
                mut.method_10098(class_2350.field_11036);
                if (world.method_22347((class_2338)mut)) continue;
                return false;
            }
            mut.method_10101((class_2382)pos);
            class_2680 topMiddle = (class_2680)LighterEndBlocks.LUMECORN.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.LIGHT_TOP_MIDDLE));
            class_2680 middle = (class_2680)LighterEndBlocks.LUMECORN.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.LIGHT_MIDDLE));
            class_2680 bottom = (class_2680)LighterEndBlocks.LUMECORN.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.LIGHT_BOTTOM));
            class_2680 top = (class_2680)LighterEndBlocks.LUMECORN.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.LIGHT_TOP));
            if (height == 4) {
                world.method_8652((class_2338)mut, (class_2680)LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.BOTTOM_SMALL)), 18);
                world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), bottom, 18);
                world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), topMiddle, 18);
                world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), top, 18);
                return true;
            }
            if (random.method_43056()) {
                world.method_8652((class_2338)mut, (class_2680)LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.BOTTOM_SMALL)), 18);
            } else {
                world.method_8652((class_2338)mut, (class_2680)LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.BOTTOM_BIG)), 18);
                world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), (class_2680)LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(SHAPE, (Comparable)((Object)LumecornShape.MIDDLE)), 18);
                --height;
            }
            world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), bottom, 18);
            for (int i = 4; i < height; ++i) {
                world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), middle, 18);
            }
            world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), topMiddle, 18);
            world.method_8652((class_2338)mut.method_10098(class_2350.field_11036), top, 18);
            return true;
        }
    }

    public static class LumecornSeed
    extends class_2473 {
        public static final class_2758 AGE = class_2758.method_11867((String)"age", (int)0, (int)3);

        public LumecornSeed(class_4970.class_2251 settings) {
            super(LUMECORN_GENERATOR, settings.method_31710(class_3620.field_25705).method_9634().method_9618().method_9626(class_2498.field_17580).method_50012(class_3619.field_15971).method_50013().method_9640());
            this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
        }

        public void method_10507(class_3218 world, class_2338 pos, class_2680 state, class_5819 random) {
            if (!LumecornSeed.isAllowedToGrow((class_4538)world, pos)) {
                return;
            }
            if ((Integer)state.method_11654((class_2769)AGE) < 3) {
                world.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 4);
            } else {
                if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
                    return;
                }
                class_5821 context = new class_5821(null, (class_5281)world, world.method_14178().method_12129(), random, pos, (class_3037)new class_3111());
                new LumecornFeature().method_13151((class_5821<class_3111>)context);
            }
        }

        protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
            return floor.method_26164(LighterEndTags.END_SOIL);
        }

        protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
            if (random.method_43048(3) == 0) {
                this.method_10507(world, pos, state, random);
            }
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
            builder.method_11667(new class_2769[]{AGE});
        }

        public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
            return LumecornSeed.isAllowedToGrow(world, pos);
        }

        private static boolean isAllowedToGrow(class_4538 world, class_2338 pos) {
            return !LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd() || world.method_23753(pos).method_40220(class_6908.field_37394);
        }
    }

    public static class LumecornStem
    extends class_2248 {
        public LumecornStem(class_4970.class_2251 settings) {
            super(settings.method_31710(class_3620.field_25706).method_51368(class_2766.field_12651).method_9626(class_2498.field_11547).method_9632(0.5f).method_50013().method_9631(bs -> 0));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{SHAPE});
        }

        protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return SHAPE_BOTTOM;
        }

        protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            LumecornShape shape = (LumecornShape)((Object)state.method_11654(SHAPE));
            if (shape == LumecornShape.BOTTOM_BIG || shape == LumecornShape.BOTTOM_SMALL) {
                return world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL);
            }
            return world.method_8320(pos.method_10074()).method_27852((class_2248)this) && (world.method_8320(pos.method_10084()).method_27852((class_2248)this) || world.method_8320(pos.method_10084()).method_27852(LighterEndBlocks.LUMECORN));
        }

        protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
            if (!this.method_9558(state, world, pos)) {
                return class_2246.field_10124.method_9564();
            }
            return state;
        }

        protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
            return new class_1799((class_1935)LighterEndBlocks.LUMECORN_SEED);
        }
    }
}

