/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.config;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.shadow.org.yaml.snakeyaml.DumperOptions;
import io.github.openbagtwo.lighterend.shadow.org.yaml.snakeyaml.Yaml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Path config_path = FabricLoader.getInstance().getConfigDir().resolve("lighterend.yaml").toAbsolutePath();
    protected boolean generateBiomes;
    protected boolean generateOres;
    protected boolean playEndBiomeMusic;
    protected double endGravity;
    private double serverEndGravity;
    protected boolean disableEndGravityWhileFlying;
    private boolean serverDisableEndGravityWhileFlying;
    protected boolean endPlantsOnlyGrowInTheEnd;
    protected boolean musicDiscsInEndCities;
    protected boolean customEndFishing;
    protected boolean bonemealUnderwaterInEndMakesEndVegetation;
    protected boolean endSpawn;
    private static final boolean DEFAULT_BIOME_GENERATION = true;
    private static final boolean DEFAULT_GENERATE_ORES = false;
    private static final boolean DEFAULT_PLAY_END_BIOME_MUSIC = true;
    private static final double DEFAULT_END_GRAVITY = 0.3;
    private static final boolean DEFAULT_END_GRAVITY_DISABLED_WHILE_FLYING = false;
    private static final boolean DEFAULT_END_PLANTS_ONLY_GROW_IN_THE_END = true;
    private static final boolean DEFAULT_MUSIC_DISCS_IN_END_CITIES = true;
    private static final boolean DEFAULT_CUSTOM_END_FISHING = true;
    private static final boolean DEFAULT_UNDERWATER_BONEMEAL_SETTING = true;
    private static final boolean DEFAULT_END_SPAWN = false;
    private static final DumperOptions configFormat = new DumperOptions(){
        {
            this.setIndent(2);
            this.setPrettyFlow(true);
            this.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        }
    };

    public boolean generateBiomes() {
        return this.generateBiomes;
    }

    public boolean generateOres() {
        return this.generateOres;
    }

    public boolean playEndBiomeMusic() {
        return this.playEndBiomeMusic;
    }

    public double getEndGravity() {
        return this.serverEndGravity;
    }

    public void setServerEndGravity(double gravity) {
        this.serverEndGravity = gravity;
    }

    public boolean disableEndGravityWhileFlying() {
        return this.serverDisableEndGravityWhileFlying;
    }

    public void setServerFlyFix(boolean enable) {
        this.serverDisableEndGravityWhileFlying = enable;
    }

    public boolean endPlantsOnlyGrowInTheEnd() {
        return this.endPlantsOnlyGrowInTheEnd;
    }

    public boolean musicDiscsAreFoundInEndCities() {
        return this.musicDiscsInEndCities;
    }

    public boolean endFishingHasCustomLootTable() {
        return this.customEndFishing;
    }

    public boolean bonemealingUnderwaterInEndProducesEndVegetation() {
        return this.bonemealUnderwaterInEndMakesEndVegetation;
    }

    public boolean enableEndSpawn() {
        return this.endSpawn;
    }

    public static Config loadConfiguration() {
        Config config;
        try {
            config = Config.fromConfigFile();
            LighterEnd.LOGGER.debug("Loaded Lighter End configuration.");
        }
        catch (FileNotFoundException e) {
            LighterEnd.LOGGER.warn("No Lighter End configuration file found.");
            try {
                Config.writeDefaultConfigFile();
            }
            catch (ConfigException writee) {
                LighterEnd.LOGGER.error("Could not write Lighter End configuration:\n" + String.valueOf(writee));
            }
            config = Config.getDefaultConfiguration();
        }
        catch (ConfigException e) {
            LighterEnd.LOGGER.error("Lighter End configuration is invalid:\n" + String.valueOf(e));
            config = Config.getDefaultConfiguration();
        }
        return config;
    }

    protected void writeConfigToFile() throws ConfigException {
        FileWriter configWriter;
        try {
            configWriter = new FileWriter(config_path.toFile());
        }
        catch (IOException e) {
            throw new ConfigException("Could not open " + String.valueOf(config_path) + " for writing.", e);
        }
        LinkedHashMap<String, Comparable<Boolean>> writeme = new LinkedHashMap<String, Comparable<Boolean>>();
        writeme.put("generate_biomes", Boolean.valueOf(this.generateBiomes));
        writeme.put("generate_ores", Boolean.valueOf(this.generateOres));
        writeme.put("play_biome_music", Boolean.valueOf(this.playEndBiomeMusic));
        writeme.put("end_gravity", Double.valueOf(this.endGravity));
        writeme.put("disable_end_gravity_while_flying", Boolean.valueOf(this.disableEndGravityWhileFlying));
        writeme.put("end_plants_only_grow_in_the_end", Boolean.valueOf(this.endPlantsOnlyGrowInTheEnd));
        writeme.put("music_discs_found_in_end_cities", Boolean.valueOf(this.musicDiscsInEndCities));
        writeme.put("customize_end_fishing", Boolean.valueOf(this.customEndFishing));
        writeme.put("bonemealing_underwater_in_the_end_produces_end_vegetation", Boolean.valueOf(this.bonemealUnderwaterInEndMakesEndVegetation));
        writeme.put("spawn_in_end", Boolean.valueOf(this.endSpawn));
        new Yaml(configFormat).dump(writeme, configWriter);
        LighterEnd.LOGGER.info("Wrote Lighter End configuration file to " + String.valueOf(config_path));
    }

    private static Config getDefaultConfiguration() {
        LighterEnd.LOGGER.info("Loading default Lighter End configuration");
        Config config = new Config();
        config.generateBiomes = true;
        config.generateOres = false;
        config.playEndBiomeMusic = true;
        config.endGravity = 0.3;
        config.disableEndGravityWhileFlying = false;
        config.endPlantsOnlyGrowInTheEnd = true;
        config.musicDiscsInEndCities = true;
        config.customEndFishing = true;
        config.bonemealUnderwaterInEndMakesEndVegetation = true;
        config.endSpawn = false;
        return config;
    }

    private static void writeDefaultConfigFile() throws ConfigException {
        Config.getDefaultConfiguration().writeConfigToFile();
    }

    private static Config fromConfigFile() throws FileNotFoundException, ConfigException {
        LighterEnd.LOGGER.debug("Reading Lighter End configuration from " + String.valueOf(config_path));
        FileInputStream configReader = new FileInputStream(config_path.toFile());
        HashMap settings = new HashMap((Map)new Yaml().load(configReader));
        try {
            Config config = new Config();
            config.generateBiomes = Boolean.parseBoolean(((Object)settings.getOrDefault("generate_biomes", true)).toString());
            config.generateOres = Boolean.parseBoolean(((Object)settings.getOrDefault("generate_ores", false)).toString());
            config.playEndBiomeMusic = Boolean.parseBoolean(((Object)settings.getOrDefault("play_biome_music", true)).toString());
            config.endGravity = Double.parseDouble(((Object)settings.getOrDefault("end_gravity", 0.3)).toString());
            config.disableEndGravityWhileFlying = Boolean.parseBoolean(((Object)settings.getOrDefault("disable_end_gravity_while_flying", false)).toString());
            config.endPlantsOnlyGrowInTheEnd = Boolean.parseBoolean(((Object)settings.getOrDefault("end_plants_only_grow_in_the_end", true)).toString());
            config.musicDiscsInEndCities = Boolean.parseBoolean(((Object)settings.getOrDefault("music_discs_found_in_end_cities", true)).toString());
            config.customEndFishing = Boolean.parseBoolean(((Object)settings.getOrDefault("customize_end_fishing", true)).toString());
            config.bonemealUnderwaterInEndMakesEndVegetation = Boolean.parseBoolean(((Object)settings.getOrDefault("bonemealing_underwater_in_the_end_produces_end_vegetation", true)).toString());
            config.endSpawn = Boolean.parseBoolean(((Object)settings.getOrDefault("spawn_in_end", false)).toString());
            config.serverEndGravity = config.endGravity;
            config.serverDisableEndGravityWhileFlying = config.disableEndGravityWhileFlying;
            return config;
        }
        catch (Exception e) {
            throw new ConfigException(String.valueOf(config_path) + " is not a valid Lighter End configuration.", e);
        }
    }

    protected static class ConfigException
    extends Exception {
        ConfigException(String message, Exception e) {
            super(message, e);
        }

        ConfigException(String message) {
            super(message);
        }
    }
}

