/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Polypore;
import io.github.openbagtwo.lighterend.mobs.GlossyMooshroom;
import io.github.openbagtwo.lighterend.mobs.states.GlossyMooshroomRenderState;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_560;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_776;
import net.minecraft.class_922;
import net.minecraft.class_9990;

@Environment(value=EnvType.CLIENT)
public class GlossyMooshroomRenderer
extends class_9990<GlossyMooshroom, class_10042, class_560> {
    private static final List<class_2960> TEXTURES = Arrays.asList(LighterEnd.of("textures/entity/glossy_mooshroom.png"));
    private static final List<class_1921> GLOW = Arrays.asList(class_1921.method_23026((class_2960)LighterEnd.of("textures/entity/glossy_mooshroom_glow.png")));

    public GlossyMooshroomRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new class_560(context.method_32167(class_5602.field_27615)), (class_583)new class_560(context.method_32167(class_5602.field_53835)), 0.7f);
        this.method_4046(new PolyporeFeatureRenderer((class_3883<class_10042, class_560>)this, context.method_43337()));
        this.method_4046((class_3887)new class_4606<class_10042, class_560>(this, (class_3883)this){

            public class_1921 method_23193() {
                return GLOW.get(0);
            }

            public void render(class_4587 matrices, class_11659 queue, int light, class_10042 state, float limbAngle, float limbDistance) {
                if (state instanceof GlossyMooshroomRenderState) {
                    GlossyMooshroomRenderState cowState = (GlossyMooshroomRenderState)state;
                    queue.method_73529(1).method_73490((class_3879)this.method_17165(), (Object)state, matrices, GLOW.get(cowState.variant % GLOW.size()), light, class_4608.field_21444, -1, null, state.field_61821, null);
                }
            }
        });
    }

    public class_2960 method_3885(class_10042 state) {
        int variant = 0;
        if (state instanceof GlossyMooshroomRenderState) {
            GlossyMooshroomRenderState cowState = (GlossyMooshroomRenderState)state;
            variant = cowState.variant;
        }
        return TEXTURES.get(variant % TEXTURES.size());
    }

    public GlossyMooshroomRenderState createRenderState() {
        return new GlossyMooshroomRenderState();
    }

    public void updateRenderState(GlossyMooshroom cow, class_10042 state, float f) {
        super.method_62355((class_1309)cow, state, f);
        if (state instanceof GlossyMooshroomRenderState) {
            GlossyMooshroomRenderState cowState = (GlossyMooshroomRenderState)state;
            cowState.variant = cow.getVariant();
            cowState.sheared = cow.isSheared();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PolyporeFeatureRenderer
    extends class_3887<class_10042, class_560> {
        private final class_776 blockRenderManager;

        public PolyporeFeatureRenderer(class_3883<class_10042, class_560> context, class_776 blockRenderManager) {
            super(context);
            this.blockRenderManager = blockRenderManager;
        }

        public void render(class_4587 matrixStack, class_11659 queue, int light, class_10042 state, float f, float g) {
            if (state instanceof GlossyMooshroomRenderState) {
                GlossyMooshroomRenderState cowState = (GlossyMooshroomRenderState)state;
                if (!cowState.sheared && !cowState.field_53457) {
                    boolean renderAsModel;
                    boolean bl = renderAsModel = cowState.method_72997() && cowState.field_53333;
                    if (!cowState.field_53333 || renderAsModel) {
                        class_2680 polyphore;
                        if (cowState.variant == 0) {
                            polyphore = (class_2680)LighterEndBlocks.AURANT_POLYPORE.method_9564().method_11657(Polypore.FACING, (Comparable)class_2350.field_11039);
                        } else if (cowState.variant == 1) {
                            polyphore = (class_2680)LighterEndBlocks.PURPLE_POLYPORE.method_9564().method_11657(Polypore.FACING, (Comparable)class_2350.field_11039);
                        } else {
                            return;
                        }
                        int overlay = class_922.method_23622((class_10042)cowState, (float)0.0f);
                        class_1087 blockStateModel = this.blockRenderManager.method_3349(polyphore);
                        matrixStack.method_22903();
                        matrixStack.method_22905(-0.3f, -0.5f, 0.5f);
                        matrixStack.method_46416(-2.25f, -1.5f, 0.0f);
                        this.renderMushroom(matrixStack, queue, light, renderAsModel, polyphore, overlay, blockStateModel, cowState.field_61821);
                        matrixStack.method_22909();
                        blockStateModel = this.blockRenderManager.method_3349((class_2680)polyphore.method_11657(Polypore.FACING, (Comparable)class_2350.field_11034));
                        matrixStack.method_22903();
                        matrixStack.method_22905(0.3f, -0.5f, -0.5f);
                        matrixStack.method_46416(-2.25f, -1.5f, -0.2f);
                        this.renderMushroom(matrixStack, queue, light, renderAsModel, polyphore, overlay, blockStateModel, cowState.field_61821);
                        matrixStack.method_22909();
                    }
                }
            }
        }

        private void renderMushroom(class_4587 matrices, class_11659 queue, int light, boolean renderAsModel, class_2680 mushroomState, int overlay, class_1087 mushroomModel, int color) {
            if (renderAsModel) {
                queue.method_73484(matrices, class_1921.method_23287((class_2960)class_1059.field_5275), mushroomModel, 0.0f, 0.0f, 0.0f, light, overlay, color);
            } else {
                queue.method_73481(matrices, mushroomState, light, overlay, color);
            }
        }
    }
}

