/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFCoordsModify;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFRotate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFTorus;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7833;

public class UmbralithArch
extends class_3031<class_3111> {
    public UmbralithArch() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_5281 world = featurePlaceContext.method_33652();
        class_2338 origin = featurePlaceContext.method_33655();
        class_5819 random = featurePlaceContext.method_33654();
        class_2338 pos = world.method_8598(class_2902.class_2903.field_13194, new class_2338(origin.method_10263() & 0xFFFFFFF0 | 7, 0, origin.method_10260() & 0xFFFFFFF0 | 7));
        if (!world.method_8320(pos.method_10087(5)).method_26164(LighterEndTags.END_STONES)) {
            return false;
        }
        float bigRadius = class_3532.method_15344((class_5819)random, (float)10.0f, (float)20.0f);
        float smallRadius = class_3532.method_15344((class_5819)random, (float)3.0f, (float)7.0f);
        if (smallRadius + bigRadius > 23.0f) {
            smallRadius = 23.0f - bigRadius;
        }
        SDF arch = new SDFTorus().setBigRadius(bigRadius).setSmallRadius(smallRadius).setBlock(LighterEndBlocks.UMBRALITH.baseBlock);
        arch = new SDFRotate().setRotation(MathUtils.randomHorizontal(random), 1.5707964f).setSource(arch);
        float smallRadiusF = smallRadius;
        OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
        arch = new SDFDisplace().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3 + 100.0, (double)vec.z() * 0.3)) * (double)1.3f) - smallRadiusF * Math.abs(1.0f - vec.y() / bigRadius))).setSource(arch);
        arch.addPostProcess(info -> {
            if (info.getStateUp().method_26215()) {
                return LighterEndBlocks.UMBRALITH.baseBlock.method_9564();
            }
            return info.getState();
        });
        float side = (bigRadius + smallRadius + 3.0f) * 2.0f;
        if (side > 47.0f) {
            side = 47.0f;
        }
        arch.fillArea((class_5425)world, pos, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)side, (double)side, (double)side));
        return true;
    }

    public static class Thin
    extends class_3031<class_3111> {
        public Thin() {
            super(class_3111.field_24893);
        }

        public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
            class_5281 world = featurePlaceContext.method_33652();
            class_2338 origin = featurePlaceContext.method_33655();
            class_5819 random = featurePlaceContext.method_33654();
            class_2338 pos = world.method_8598(class_2902.class_2903.field_13194, new class_2338(origin.method_10263() & 0xFFFFFFF0 | 7, 0, origin.method_10260() & 0xFFFFFFF0 | 7));
            if (!world.method_8320(pos.method_10087(5)).method_26164(LighterEndTags.END_STONES)) {
                return false;
            }
            SDF sdf = null;
            float bigRadius = class_3532.method_15344((class_5819)random, (float)15.0f, (float)20.0f);
            float variation = bigRadius * 0.3f;
            int count = class_3532.method_15395((class_5819)random, (int)2, (int)4);
            for (int i = 0; i < count; ++i) {
                float smallRadius = class_3532.method_15344((class_5819)random, (float)0.6f, (float)1.3f);
                SDF arch = new SDFTorus().setBigRadius(bigRadius - random.method_43057() * variation).setSmallRadius(smallRadius).setBlock(LighterEndBlocks.UMBRALITH.baseBlock);
                float angle = ((float)i - (float)count * 0.5f) * 0.3f + random.method_43057() * 0.05f + 1.5707964f;
                arch = new SDFRotate().setRotation(class_7833.field_40714, angle).setSource(arch);
                sdf = sdf == null ? arch : new SDFUnion().setSourceA(sdf).setSourceB(arch);
            }
            sdf = new SDFRotate().setRotation(MathUtils.randomHorizontal(random), random.method_43057() * ((float)Math.PI * 2)).setSource(sdf);
            OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
            sdf = new SDFCoordsModify().setFunction(vec -> {
                float dx = (float)noise.eval((double)vec.y() * 0.02, (double)vec.z() * 0.02);
                float dy = (float)noise.eval((double)vec.x() * 0.02, (double)vec.z() * 0.02);
                float dz = (float)noise.eval((double)vec.x() * 0.02, (double)vec.y() * 0.02);
                vec.add(dx * 10.0f, dy * 10.0f, dz * 10.0f);
            }).setSource(sdf);
            sdf = new SDFDisplace().setFunction(vec -> {
                float offset = vec.y() / bigRadius - 0.5f;
                return Float.valueOf(class_3532.method_15363((float)(offset * 3.0f), (float)-10.0f, (float)0.0f));
            }).setSource(sdf);
            float side = (bigRadius + 2.5f) * 2.0f;
            if (side > 47.0f) {
                side = 47.0f;
            }
            sdf.fillArea((class_5425)world, pos, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)side, (double)side, (double)side));
            return true;
        }
    }
}

