/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.BlockEntityRenderer;
import io.github.openbagtwo.lighterend.blocks.BlockLayerRenderer;
import io.github.openbagtwo.lighterend.mobs.EntityModels;
import io.github.openbagtwo.lighterend.networking.GravityPayload;
import io.github.openbagtwo.lighterend.particles.Geyser;
import io.github.openbagtwo.lighterend.particles.GlowingSphere;
import io.github.openbagtwo.lighterend.particles.Snowflake;
import io.github.openbagtwo.lighterend.particles.Sulphur;
import io.github.openbagtwo.lighterend.particles.TenaneaPetal;
import io.github.openbagtwo.lighterend.registries.LighterEndParticles;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class LighterEndClient
implements ClientModInitializer {
    public void onInitializeClient() {
        BlockLayerRenderer.initialize();
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.TENANEA_PETAL, TenaneaPetal.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.AMBER_SPHERE, GlowingSphere.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.GLOWING_SPHERE, GlowingSphere.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.SNOWFLAKE, Snowflake.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.SULPHUR, Sulphur.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)LighterEndParticles.GEYSER, Geyser.Factory::new);
        BlockEntityRenderer.initialize();
        EntityModels.initialize();
        FabricLoader.getInstance().getModContainer("lighterend").ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)LighterEnd.of("wing_trims"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcepacks.lighterend.wing_trims.title"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED));
        ClientPlayNetworking.registerGlobalReceiver(GravityPayload.ID, (packet, context) -> {
            LighterEnd.CONFIG.setServerEndGravity(packet.gravity());
            LighterEnd.CONFIG.setServerFlyFix(packet.flyFix());
            LighterEnd.LOGGER.info("Received gravity settings from server");
        });
    }
}

