package io.github.openbagtwo.lighterend;

import com.google.common.collect.Sets;
import io.github.openbagtwo.lighterend.blocks.Fur;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class BlockFixer {

  private static final class_2680 AIR = class_2246.field_10124.method_9564();
  private static final class_2680 WATER = class_2246.field_10382.method_9564();

  public static void fixBlocks(class_1936 level, class_2338 start, class_2338 end) {
    final class_2378<class_2874> registry = level.method_30349()
        .method_30530(class_7924.field_41241);
    final class_2960 dimKey = registry.method_10221(level.method_8597());
    if (dimKey != null && "world_blender".equals(dimKey.method_12836())) {
      return;
    }
    final Set<class_2338> doubleCheck = Sets.newConcurrentHashSet();
    final int dx = end.method_10263() - start.method_10263() + 1;
    final int dz = end.method_10260() - start.method_10260() + 1;
    final int count = dx * dz;
    final int minY = Math.max(start.method_10264(), level.method_31607());
    final int maxY = Math.min(end.method_10264(), level.method_31600());
    IntStream.range(0, count).forEach(index -> {
      class_2339 POS = new class_2339();
      POS.method_33097((index % dx) + start.method_10263());
      POS.method_33099((index / dx) + start.method_10260());
      class_2680 state;
      for (int y = minY; y <= maxY; y++) {
        POS.method_33098(y);
        state = level.method_8320(POS);

        if (state.method_26204() instanceof Fur) {
          doubleCheck.add(POS.method_10062());
        }
        // Liquids
        else if (!state.method_26227().method_15769()) {
          if (!state.method_26184(level, POS)) {
            setWithoutUpdate(level, POS, WATER);
            POS.method_33098(POS.method_10264() - 1);
            state = level.method_8320(POS);
            while (!state.method_26184(level, POS)) {
              state = state.method_26227().method_15769() ? AIR : WATER;
              setWithoutUpdate(level, POS, state);
              POS.method_33098(POS.method_10264() - 1);
              state = level.method_8320(POS);
            }
          }
          POS.method_33098(y - 1);
          if (level.method_22347(POS)) {
            POS.method_33098(y);
            while (!level.method_8316(POS).method_15769()) {
              setWithoutUpdate(level, POS, AIR);
              POS.method_33098(POS.method_10264() + 1);
            }
            continue;
          }
          for (class_2350 dir : class_2350.class_2353.field_11062) {
            if (level.method_22347(POS.method_10093(dir))) {
              try {
                level.method_39283(POS, state.method_26227().method_15772(), 0);
              } catch (Exception e) {
              }
              break;
            }
          }
//        } else if (state.isOf(EndBlocks.SMARAGDANT_CRYSTAL) || state.isOf(
//            EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
//          POS.setY(POS.getY() - 1);
//          if (level.isAir(POS)) {
//            POS.setY(POS.getY() + 1);
//            while (state.isOf(EndBlocks.SMARAGDANT_CRYSTAL) || state.isOf(
//                EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
//              setWithoutUpdate(level, POS, AIR);
//              POS.setY(POS.getY() + 1);
//              state = level.getBlockState(POS);
//            }
//          }
//        } else if (state.getBlock() instanceof StalactiteBlock) {
//          if (!state.canPlaceAt(level, POS)) {
//            if (level.getBlockState(POS.up()).getBlock() instanceof StalactiteBlock) {
//              while (state.getBlock() instanceof StalactiteBlock) {
//                setWithoutUpdate(level, POS, AIR);
//                POS.setY(POS.getY() + 1);
//                state = level.getBlockState(POS);
//              }
//            } else {
//              while (state.getBlock() instanceof StalactiteBlock) {
//                setWithoutUpdate(level, POS, AIR);
//                POS.setY(POS.getY() - 1);
//                state = level.getBlockState(POS);
//              }
//            }
//          }
//        } else if (state.isOf(EndBlocks.CAVE_PUMPKIN)) {
//          if (!level.getBlockState(POS.up()).isOf(EndBlocks.CAVE_PUMPKIN_SEED)) {
//            setWithoutUpdate(level, POS, AIR);
//          }
        } else if (!state.method_26184(level, POS)) {
          // Chorus
          if (state.method_27852(class_2246.field_10021)) {
            Set<class_2338> ends = Sets.newHashSet();
            Set<class_2338> add = Sets.newHashSet();
            ends.add(POS.method_10062());

            for (int i = 0; i < 64 && !ends.isEmpty(); i++) {
              ends.forEach((pos) -> {
                setWithoutUpdate(level, pos, AIR);
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                  class_2338 p = pos.method_10093(dir);
                  class_2680 st = level.method_8320(p);
                  if ((st.method_27852(class_2246.field_10021) || st.method_27852(class_2246.field_10528))
                      && !st.method_26184(
                      level,
                      p
                  )) {
                    add.add(p);
                  }
                }
                class_2338 p = pos.method_10084();
                class_2680 st = level.method_8320(p);
                if ((st.method_27852(class_2246.field_10021) || st.method_27852(class_2246.field_10528))
                    && !st.method_26184(
                    level,
                    p
                )) {
                  add.add(p);
                }
              });
              ends.clear();
              ends.addAll(add);
              add.clear();
            }
          }
          // Falling blocks
          else if (state.method_26204() instanceof class_2346) {
            class_2680 falling = state;

            POS.method_33098(POS.method_10264() - 1);
            state = level.method_8320(POS);

            int ray = PosInfo.downRayRep(level, POS.method_10062(), 64);
            if (ray > 32) {
              setWithoutUpdate(level, POS, class_2246.field_10471.method_9564());
              if (level.method_8409().method_43056()) {
                POS.method_33098(POS.method_10264() - 1);
                state = level.method_8320(POS);
                setWithoutUpdate(level, POS, class_2246.field_10471.method_9564());
              }
            } else {
              POS.method_33098(y);
              class_2680 replacement = AIR;
              for (class_2350 dir : class_2350.class_2353.field_11062) {
                state = level.method_8320(POS.method_10093(dir));
                if (!state.method_26227().method_15769()) {
                  replacement = state;
                  break;
                }
              }
              setWithoutUpdate(level, POS, replacement);
              POS.method_33098(y - ray);
              setWithoutUpdate(level, POS, falling);
            }
          }
          // Blocks without support
          else {
            setWithoutUpdate(level, POS, getAirOrFluid(state));
          }
        }
      }
    });

    doubleCheck.forEach((pos) -> {
      if (!level.method_8320(pos).method_26184(level, pos)) {
        setWithoutUpdate(level, pos, AIR);
      }
    });
  }

  private static class_2680 getAirOrFluid(class_2680 state) {
    return state.method_26227().method_15769() ? AIR : state.method_26227().method_15759();
  }

  private static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2680 state) {
    synchronized (world) {
      world.method_8652(pos, state, Flags.SILENT);
    }
  }
}
