package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class EndLily extends class_2248 implements class_2402 {

  public static final class_2746 IS_TOP = class_2746.method_11825("is_top");

  private static final class_265 SHAPE_BOTTOM = class_2248.method_9541(
      4, 0, 4, 12, 16, 12
  );
  private static final class_265 SHAPE_TOP = class_2248.method_9541(
      2, 0, 2, 14, 6, 14
  );

  public EndLily(class_2251 settings) {
    super(settings
        .method_31710(class_3620.field_16019)
        .method_51371()
        .method_9634()
        .method_22488()
        .method_9618()
        .method_49229(class_2250.field_10657)
        .method_9626(class_2498.field_11534)
        .method_50012(class_3619.field_15971)
        .method_9631((state) -> state.method_11654(IS_TOP) ? 13 : 0)
    );
  }

  @Override
  protected void method_9515(class_2690<class_2248, class_2680> builder) {
    builder.method_11667(IS_TOP);
  }

  @Override
  public class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      tickView.method_64310(pos, this, 1);
    }
    return state;
  }

  @Override
  protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    if (!state.method_26184(world, pos)) {
      world.method_22352(pos, true);
    }
  }

  @Override
  protected class_265 method_9530(
      class_2680 state, class_1922 world, class_2338 pos, class_3726 context
  ) {
    class_243 vec3d = state.method_26226(pos);
    class_265 shape = state.method_11654(IS_TOP) ? SHAPE_TOP : SHAPE_BOTTOM;
    return shape.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
  }

  @Override
  public class_3610 method_9545(class_2680 state) {
    return state.method_11654(IS_TOP) ? class_3612.field_15906.method_15785() : class_3612.field_15910.method_15729(false);
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    if (state.method_11654(IS_TOP)) {
      return world.method_8320(pos.method_10074()).method_26204() == this;
    } else {
      class_2680 down = world.method_8320(pos.method_10074());
      return down.method_26164(LighterEndTags.AQUATIC_END_SOIL) || down.method_26204() == this;
    }
  }

  @Override
  protected class_1799 method_9574(
      class_4538 world,
      class_2338 pos,
      class_2680 state,
      boolean includeData
  ) {
    return new class_1799(LighterEndBlocks.END_LILY_SEED);
  }

  @Override
  public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos,
      class_2680 state, class_3611 fluid) {
    return false;
  }

  @Override
  public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state,
      class_3610 fluidState) {
    return false;
  }

  public static class Seed extends Sapling implements class_2402 {

    public Seed(class_2251 settings) {
      super(EndLilyFeature::new, settings, 7);
    }

    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
      return floor.method_26206(world, pos, class_2350.field_11036) && floor.method_26164(
          LighterEndTags.AQUATIC_END_SOIL);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
      class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
      return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15761() == 8
          ? super.method_9605(
          ctx) : null;
    }

    @Override
    protected class_3610 method_9545(class_2680 state) {
      return class_3612.field_15910.method_15729(false);
    }

    @Override
    public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos,
        class_2680 state, class_3611 fluid) {
      return false;
    }

    @Override
    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state,
        class_3610 fluidState) {
      return false;
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
      return EndLily.canGrow(world, pos);
    }

  }

  public static class EndLilyFeature extends class_3031<class_3111> {

    public EndLilyFeature() {
      super(class_3111.field_24893);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> featureConfig) {
      final class_2338 pos = featureConfig.method_33655();
      final class_5281 world = featureConfig.method_33652();

      if (EndLily.canGrow(world, pos)) {
        world.method_8652(
            pos,
            LighterEndBlocks.END_LILY.method_9564().method_11657(EndLily.IS_TOP, false),
            Flags.SILENT
        );

        class_2338 up = pos.method_10084();
        while (world.method_8316(up).method_15771()) {
          world.method_8652(up,
              LighterEndBlocks.END_LILY.method_9564().method_11657(EndLily.IS_TOP, false),
              Flags.SILENT
          );
          up = up.method_10084();
        }
        world.method_8652(
            up,
            LighterEndBlocks.END_LILY.method_9564().method_11657(EndLily.IS_TOP, true),
            Flags.SILENT
        );
        return true;
      }
      return false;
    }
  }

  private static boolean canGrow(class_1936 world, class_2338 pos) {
    if (!world.method_8320(pos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
      return false;
    }
    class_2339 bpos = new class_2339();
    bpos.method_10101(pos);
    while (world.method_8320(bpos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
      bpos.method_33098(bpos.method_10264() + 1);
    }
    return world.method_22347(bpos) && world.method_22347(bpos.method_10084());
  }

}
