package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class Polypore extends class_2248 {

  private static final EnumMap<class_2350, class_265> SHAPES = Maps.newEnumMap(ImmutableMap.of(
      class_2350.field_11043, method_9541(1, 1, 8, 15, 15, 16),
      class_2350.field_11035, method_9541(1, 1, 0, 15, 15, 8),
      class_2350.field_11039, method_9541(8, 1, 1, 16, 15, 15),
      class_2350.field_11034, method_9541(0, 1, 1, 8, 15, 15),
      class_2350.field_11036, method_9541(0, 0, 0, 0, 0, 0),
      class_2350.field_11033, method_9541(0, 0, 0, 0, 0, 0)
  ));
  public static final class_2754<class_2350> FACING = class_2741.field_12525;

  public Polypore(class_2251 settings, class_3620 color, int luminance) {
    super(
        settings
            .method_49229(class_2250.field_10656)
            .method_31710(color)
            .method_22488()
            .method_9618()
            .method_50012(class_3619.field_15971)
            .method_9634()
            .method_36557(0.2F)
            .method_9631(bs -> luminance)
            .method_9626(class_2498.field_11547)
    );
    method_9590(method_9564().method_11657(FACING, class_2350.field_11036));
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
    stateManager.method_11667(FACING);
  }

  @Override
  public class_265 method_9530(
      class_2680 state,
      class_1922 view,
      class_2338 pos,
      class_3726 ePos
  ) {
    return SHAPES.get(state.method_11654(FACING));
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2350 direction = state.method_11654(FACING);
    class_2338 blockPos = pos.method_10093(direction.method_10153());
    class_2680 blockState = world.method_8320(blockPos);
    return blockState.method_51367() && blockState.method_26206(world, pos, direction);
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    class_2680 blockState = this.method_9564();
    class_4538 worldView = ctx.method_8045();
    class_2338 blockPos = ctx.method_8037();
    class_2350[] directions = ctx.method_7718();
    for (class_2350 direction : directions) {
      if (direction.method_10166().method_10179()) {
        class_2350 direction2 = direction.method_10153();
        blockState = blockState.method_11657(FACING, direction2);
        if (blockState.method_26184(worldView, blockPos)) {
          return blockState;
        }
      }
    }
    return null;
  }

  @Override
  public class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      return class_2246.field_10124.method_9564();
    } else {
      return state;
    }
  }

  @Override
  public class_2680 method_9598(class_2680 state, class_2470 rotation) {
    return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
  }

  @Override
  public class_2680 method_9569(class_2680 state, class_2415 mirror) {
    return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
  }
}
