package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class VentBubbleColumn extends class_2248 implements class_2263, class_2402 {

  public VentBubbleColumn(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16019)
            .method_51371()
            .method_9634()
            .method_42327()
            .method_50012(class_3619.field_15971)
            .method_51177()
            .method_9626(class_2498.field_44608)
            .method_22488()
    );
  }

  @Override
  public class_1799 method_9700(
      @Nullable class_1309 drainer,
      class_1936 world,
      class_2338 pos,
      class_2680 state
  ) {
    world.method_8652(pos, class_2246.field_10124.method_9564(), 11);
    return new class_1799(class_1802.field_8705);
  }

  @Override
  public class_2464 method_9604(class_2680 state) {
    return class_2464.field_11455;
  }

  @Override
  public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    class_2680 blockState = world.method_8320(pos.method_10074());
    return blockState.method_27852(this) || blockState.method_27852(LighterEndBlocks.HYDROTHERMAL_VENT);
  }

  @Override
  public class_265 method_9530(
      class_2680 state,
      class_1922 world,
      class_2338 pos,
      class_3726 context
  ) {
    return class_259.method_1073();
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!state.method_26184(world, pos)) {
      return class_2246.field_10382.method_9564();
    } else {
      class_2338 up = pos.method_10084();
      if (world.method_8320(up).method_27852(class_2246.field_10382)) {
        if (world instanceof class_3218 serverWorld) {
          serverWorld.method_8652(up, this.method_9564(), Flags.SILENT);
          serverWorld.method_39283(up, this, 5);
        }
      }
    }
    return state;
  }

  public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
    if (random.method_43048(4) == 0) {
      double px = pos.method_10263() + random.method_43058();
      double py = pos.method_10264() + random.method_43058();
      double pz = pos.method_10260() + random.method_43058();
      world.method_8494(class_2398.field_11238, px, py, pz, 0, 0.04, 0);
    }
    if (random.method_43048(200) == 0) {
      world.method_8486(
          pos.method_10263(),
          pos.method_10264(),
          pos.method_10260(),
          class_3417.field_15161,
          class_3419.field_15245,
          0.2F + random.method_43057() * 0.2F,
          0.9F + random.method_43057() * 0.15F,
          false
      );
    }
  }

  @Override
  protected void method_9548(
      class_2680 state,
      class_1937 world,
      class_2338 pos,
      class_1297 entity,
      class_10774 handler,
      boolean bl
  ) {
    if (entity.method_5864().method_20210(LighterEndTags.IGNORES_GEYSER_BUBBLES)) {
      return;
    }
    class_2680 blockState = world.method_8320(pos.method_10084());
    if (blockState.method_26215()) {
      entity.method_5700(false, pos.method_10084());
      if (!world.method_8608()) {
        class_3218 serverWorld = (class_3218) world;

        for (int i = 0; i < 2; ++i) {
          serverWorld.method_65096(
              class_2398.field_11202,
              (double) pos.method_10263() + world.field_9229.method_43058(),
              pos.method_10264() + 1,
              (double) pos.method_10260() + world.field_9229.method_43058(),
              1,
              0.0D,
              0.0D,
              0.0D,
              1.0D
          );
          serverWorld.method_65096(
              class_2398.field_11247,
              (double) pos.method_10263() + world.field_9229.method_43058(),
              pos.method_10264() + 1,
              (double) pos.method_10260() + world.field_9229.method_43058(),
              1,
              0.0D,
              0.01D,
              0.0D,
              0.2D
          );
        }
      }
    } else {
      entity.method_5764(false);
    }
  }

  @Override
  protected class_1799 method_9574(
      class_4538 world,
      class_2338 pos,
      class_2680 state,
      boolean includeData
  ) {
    return new class_1799(class_2246.field_10382);
  }

  @Override
  public boolean method_10310(
      @Nullable class_1309 filler,
      class_1922 world,
      class_2338 pos,
      class_2680 state,
      class_3611 fluid
  ) {
    return false;
  }

  @Override
  public boolean method_10311(
      class_1936 world,
      class_2338 pos,
      class_2680 state,
      class_3610 fluidState
  ) {
    return false;
  }

  @Override
  public class_3610 method_9545(class_2680 state) {
    return class_3612.field_15910.method_15729(false);
  }


  @Override
  public Optional<class_3414> method_32351() {
    return class_3612.field_15910.method_32359();
  }
}
