package io.github.openbagtwo.lighterend.blocks.entities;

import io.github.openbagtwo.lighterend.blocks.HydrothermalVent;
import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndParticles;
import io.github.openbagtwo.lighterend.utils.GlobalState;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9334;

public class Updraft extends class_2586 {

  private final static class_243 POSITIVE_Y = new class_243(0.0f, 1.0f, 0.0f);

  public Updraft(class_2338 blockPos, class_2680 blockState) {
    super(LighterEndBlockEntities.UPDRAFT, blockPos, blockState);
  }

  public static <T extends class_2586> void tick(
      class_1937 level,
      class_2338 worldPosition,
      class_2680 state,
      T uncastedEntity
  ) {

    if (
        level != null
            && uncastedEntity instanceof Updraft updraft
            && state.method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)
    ) {
      particleTick(level, worldPosition, state, updraft);
      serverTick(level, worldPosition, state, updraft);
    }
  }

  private static void particleTick(
      class_1937 level,
      class_2338 worldPosition,
      class_2680 state,
      Updraft updraft
  ) {
    boolean active = state.method_11654(HydrothermalVent.ACTIVATED);
    if (active && level.field_9229.method_43048(20) == 0) {
      double x = worldPosition.method_10263() + 0.5 * level.field_9229.method_43058();
      double y = worldPosition.method_10264() + 0.9 + level.field_9229.method_43058() * 0.3;
      double z = worldPosition.method_10260() + 0.5 * level.field_9229.method_43058();
      level.method_8406(LighterEndParticles.GEYSER, x, y, z, 0, 0.125, 0);
    }
  }

  private static void serverTick(
      class_1937 level,
      class_2338 worldPosition,
      class_2680 state,
      Updraft updraft
  ) {
    final class_2339 POS = GlobalState.stateForThread().POS;
    boolean active = state.method_11654(HydrothermalVent.ACTIVATED);
    POS.method_10101(worldPosition).method_10098(class_2350.field_11036);
    int height = active ? 85 : 25;
    class_238 box = new class_238(POS.method_10069(-1, 0, -1).method_46558(), POS.method_10069(1, height, 1).method_46558());
    List<class_1309> entities = level.method_18467(class_1309.class, box);
    if (entities.size() > 0) {
      while (POS.method_10264() < box.field_1325) {
        class_2680 blockState = level.method_8320(POS);
        if (blockState.method_26216()) {
          break;
        }
        if (blockState.method_26215()) {
          double mult = active ? 3.0 : 5.0;
          float force = (float) ((1.0 - (POS.method_10264() / box.field_1325)) / mult);
          entities.stream()
              .filter(entity -> (int) entity.method_23318() == POS.method_10264() && hasElytra(entity)
                  && entity
                  .method_6128())
              .forEach(entity -> entity.method_5724(force, POSITIVE_Y));
        }
        POS.method_10098(class_2350.field_11036);
      }
    }
  }

  private static boolean hasElytra(class_1309 entity) {
    return entity.method_6118(class_1304.field_6174).method_57826(class_9334.field_54197);
  }
}
