package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.misc.StatusEffects;
import io.github.openbagtwo.lighterend.registries.LighterEndBiomes;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndEquipment;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_1959;
import net.minecraft.class_2027;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2102;
import net.minecraft.class_2135;
import net.minecraft.class_2148;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_4711;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5409;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7924;
import net.minecraft.class_8508;
import net.minecraft.class_8779;
import net.minecraft.class_8782.class_8797;

public class AdvancementProvider extends FabricAdvancementProvider {

  protected AdvancementProvider(
      FabricDataOutput output,
      CompletableFuture<class_7874> registryLookup
  ) {
    super(output, registryLookup);
  }

  @Override
  public void generateAdvancement(
      class_7874 lookup,
      Consumer<class_8779> consumer
  ) {
    class_8779 root = class_161.class_162.method_707().method_697(
        LighterEndItems.AURORA_CRYSTAL_SHARD,
        title("root"),
        description("root"),
        LighterEnd.of("block/ender_block"),
        class_189.field_1250,
        false,
        false,
        false
    ).method_705(
        LighterEnd.MOD_ID + "_loaded",
        class_2135.class_2137.method_43137(class_2090.class_2091.method_22484())
    ).method_694(consumer, LighterEnd.MOD_ID + "/root");

    // end_lake was created by hand
    class_8779 end_lake = new class_8779(class_2960.method_60654(LighterEnd.MOD_ID + "/end_lake"),
        null);

    class_8779 sulphur_springs = class_161.class_162.method_707().method_701(end_lake).method_697(
        LighterEndBlocks.HYDROTHERMAL_VENT.method_8389(),
        title("sulphur_springs"),
        description("sulphur_springs"),
        null,
        class_189.field_1254,
        true,
        true,
        false
    ).method_705(
        "found_sulphur_spring",
        class_2135.class_2137.method_43137(
            class_2090.class_2091.method_53180(
                lookup.method_46762(class_7924.field_41236).method_46747(LighterEndBiomes.SULPHUR_SPRINGS)
            )
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/sulphur_springs");

    class_8779 craft_spectral_arrow = class_161.class_162.method_707().method_701(end_lake).method_697(
        LighterEndItems.GLOW_BARB,
        title("craft_spectral_arrow"),
        description("craft_spectral_arrow"),
        null,
        class_189.field_1249,
        true,
        true,
        false
    ).method_705(
        "craft_spectral_arrows",
        class_8508.class_8509.method_51352(
            class_5321.method_29179(class_7924.field_52178, LighterEnd.of("combat/spectral_arrow"))
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/craft_spectral_arrows");

    class_8779 tether_totem = class_161.class_162.method_707().method_701(root).method_697(
        LighterEndBlocks.OBELISK.method_8389(),
        title("use_obelisk"),
        description("use_obelisk"),
        null,
        class_189.field_1254,
        true,
        true,
        false
    ).method_705(
        "use_obelisk",
        class_4711.class_4712.method_27981(
            class_2090.class_2091.method_22484().method_27989(
                class_4550.class_4710.method_23880().method_27962(
                    lookup.method_46762(class_7924.field_41254),
                    LighterEndBlocks.OBELISK
                )
            ),
            class_2073.class_2074.method_8973().method_8977(
                lookup.method_46762(class_7924.field_41197),
                LighterEndItems.TOTEM_OF_TELEPORTATION
            )
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/use_obelisk");

    class_8779 use_totem = class_161.class_162.method_707().method_701(tether_totem).method_697(
        LighterEndItems.TOTEM_OF_TELEPORTATION,
        title("use_totem"),
        description("use_totem"),
        null,
        class_189.field_1249,
        true,
        true,
        false
    ).method_705(
        "use_totem",
        class_2148.class_2150.method_9170(
            lookup.method_46762(class_7924.field_41197),
            LighterEndItems.TOTEM_OF_TELEPORTATION
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/use_totem");

    class_8779 acquire_claw = class_161.class_162.method_707().method_701(root).method_697(
        LighterEndItems.CRAB_CLAW,
        title("acquire_claw"),
        description("acquire_claw"),
        null,
        class_189.field_1254,
        true,
        true,
        false
    ).method_705(
        "acquire_claw", class_2066.class_2068.method_8959(LighterEndItems.CRAB_CLAW)
    ).method_694(consumer, LighterEnd.MOD_ID + "/acquire_claw");

    class_8779 shear_mooshroom = class_161.class_162.method_707().method_701(acquire_claw).method_697(
        class_1802.field_8868,
        title("shear_mooshroom"),
        description("shear_mooshroom"),
        null,
        class_189.field_1254,
        true,
        true,
        false
    ).method_705(
        "shear_mooshroom",
        class_5409.class_5410.method_43278(
            class_2073.class_2074.method_8973()
                .method_8977(lookup.method_46762(class_7924.field_41197), class_1802.field_8868),
            Optional.of(
                class_2048.method_53134(
                    class_2048.class_2049.method_8916()
                        .method_8921(
                            lookup.method_46762(class_7924.field_41266),
                            LighterEndMobs.MOOSHROOM.mob
                        )
                )
            )
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/shear_mooshroom");

    class_8779 wear_fur = class_161.class_162.method_707().method_701(acquire_claw).method_697(
            LighterEndBlocks.AGAVE_FUR.method_8389(),
            title("wear_fur"),
            description("wear_fur"),
            null,
            class_189.field_1254,
            true,
            true,
            false
        ).method_704(class_8797.field_1257)
        .method_705(
            "wear_agave_fur", class_2066.class_2068.method_8959(LighterEndItems.AGAVE_FUR)
        ).method_705(
            "wear_glowshroom_fur",
            class_2066.class_2068.method_8959(LighterEndItems.GLOWSHROOM_FUR)
        ).method_694(consumer, LighterEnd.MOD_ID + "/wear_fur");

    class_8779 drink_end_veil_potion = class_161.class_162.method_707().method_701(wear_fur).method_697(
        class_1802.field_8575,
        title("drink_end_veil_potion"),
        description("drink_end_veil_potion"),
        null,
        class_189.field_1249,
        true,
        true,
        false
    ).method_705(
        "drink_end_veil_potion",
        class_2027.class_2029.method_8869(
            class_2102.class_8748.method_53200().method_53201(StatusEffects.END_VEIL)
        )
    ).method_694(consumer, LighterEnd.MOD_ID + "/drink_end_veil_potion");

    class_8779 acquire_silk = class_161.class_162.method_707().method_701(acquire_claw).method_697(
            LighterEndItems.SILK,
            title("acquire_silk"),
            description("acquire_silk"),
            null,
            class_189.field_1254,
            true,
            true,
            false
        ).method_704(class_8797.field_1257)
        .method_705(
            "acquire_silk", class_2066.class_2068.method_8959(LighterEndItems.SILK)
        ).method_705(
            "acquire_silk_matrix",
            class_2066.class_2068.method_8959(LighterEndItems.SILK_MATRIX)
        ).method_694(consumer, LighterEnd.MOD_ID + "/acquire_silk");

    class_8779 acquire_silk_elytra = class_161.class_162.method_707().method_701(acquire_silk)
        .method_697(
            LighterEndEquipment.SILK_ELYTRA,
            title("acquire_silk_elytra"),
            description("acquire_silk_elytra"),
            null,
            class_189.field_1250,
            true,
            true,
            false
        ).method_705(
            "acquire_silk_elytra",
            class_2066.class_2068.method_8959(LighterEndEquipment.SILK_ELYTRA)
        ).method_703(class_170.class_171.method_750(50))
        .method_694(consumer, LighterEnd.MOD_ID + "/acquire_silk_elytra");

    class_8779 acquire_end_cream = class_161.class_162.method_707().method_701(root).method_697(
        LighterEndItems.END_CREAM,
        title("acquire_end_cream"),
        description("acquire_end_cream"),
        null,
        class_189.field_1254,
        true,
        true,
        false
    ).method_705(
        "acquire_end_cream", class_2066.class_2068.method_8959(LighterEndItems.END_CREAM)
    ).method_694(consumer, LighterEnd.MOD_ID + "/acquire_end_cream");

    class_161.class_162 allBiomesBuilder = class_161.class_162.method_707().method_701(sulphur_springs)
        .method_697(
            LighterEndBlocks.END_MOSS.method_8389(),
            title("all_the_biomes"),
            description("all_the_biomes"),
            null,
            class_189.field_1250,
            false,
            false,
            false
        ).method_704(class_8797.field_16882);

    int xpReward = 0;
    for (class_5321<class_1959> biome : List.of(
        LighterEndBiomes.BLOSSOM_FOREST,
        LighterEndBiomes.UMBRELLA_JUNGLE,
        LighterEndBiomes.GLOWING_GRASSLAND,
        LighterEndBiomes.MEGALAKE,
        LighterEndBiomes.UMBRA_VALLEY,
        LighterEndBiomes.FOGGY_MUSHROOMLANDS,
        // starfield intentionally omitted (because it's just a variant on end barrens (read: void)
        LighterEndBiomes.SULPHUR_SPRINGS,
        LighterEndBiomes.SHADOW_FOREST
    )) {
      allBiomesBuilder = allBiomesBuilder.method_705(
          biome.method_29177().method_12832(),
          class_2135.class_2137.method_43137(class_2090.class_2091.method_53180(
                  lookup.method_46762(class_7924.field_41236).method_46747(biome)
              )
          )
      );
      xpReward += 50;
    }

    class_8779 all_the_biomes = allBiomesBuilder.method_703(
        class_170.class_171.method_750(xpReward)
    ).method_694(consumer, LighterEnd.MOD_ID + "/all_the_biomes");
  }

  private static class_5250 title(String path) {
    return class_2561.method_43471(String.format("advancements.%s.%s.title", LighterEnd.MOD_ID, path));
  }

  private static class_5250 description(String path) {
    return class_2561.method_43471(
        String.format("advancements.%s.%s.description", LighterEnd.MOD_ID, path));
  }
}
