package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks.Material;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;

public class BlockTagProvider extends FabricTagProvider.BlockTagProvider {

  protected BlockTagProvider(
      FabricDataOutput output, CompletableFuture<class_7874> future
  ) {
    super(output, future);
  }

  @Override
  protected void method_10514(class_7225.class_7874 lookup) {

    valueLookupBuilder(class_3481.field_15490).method_71554(LighterEndBlocks.AURORA_CRYSTAL);
    valueLookupBuilder(class_3481.field_42607).method_71554(LighterEndBlocks.END_MOSS);

    for (Material material : Arrays.asList(
        LighterEndBlocks.VIOLECITE,
        LighterEndBlocks.AZURE_JADESTONE,
        LighterEndBlocks.SANDY_JADESTONE,
        LighterEndBlocks.VIRID_JADESTONE,
        LighterEndBlocks.UMBRALITH,
        LighterEndBlocks.BORNITE
    )) {
      for (class_2248 block : material.blocks) {
        valueLookupBuilder(class_3481.field_33715).method_71554(block);
        valueLookupBuilder(class_3481.field_15504)
            .method_71558(
                material.baseWall,
                material.brickWall,
                material.polishedWall,
                material.tileWall
            );
        valueLookupBuilder(class_3481.field_44590).method_71554(material.button);
        valueLookupBuilder(class_3481.field_24077).method_71554(material.pressurePlate);
      }
    }

    for (WoodSet wood : Arrays.asList(
        LighterEndBlocks.TENANEA,
        LighterEndBlocks.UMBRELLA,
        LighterEndBlocks.LOTUS,
        LighterEndBlocks.GLOWSHROOM,
        LighterEndBlocks.DRAGON
    )) {
      for (class_2248 block : wood.blocks) {
        valueLookupBuilder(class_3481.field_33713).method_71554(block);
      }
      valueLookupBuilder(class_3481.field_33713).method_71558(wood.wallSign, wood.wallHangingSign);
      valueLookupBuilder(class_3481.field_15471).method_71554(wood.planks);
      valueLookupBuilder(class_3481.field_15499).method_71554(wood.button);
      valueLookupBuilder(class_3481.field_15494).method_71554(wood.door);
      valueLookupBuilder(class_3481.field_15502).method_71554(wood.stairs);
      valueLookupBuilder(class_3481.field_15468).method_71554(wood.slab);
      valueLookupBuilder(class_3481.field_17619).method_71554(wood.fence);
      valueLookupBuilder(class_3481.field_25147).method_71554(wood.gate);
      valueLookupBuilder(class_3481.field_15477).method_71554(wood.pressurePlate);
      valueLookupBuilder(class_3481.field_23210).method_71558(
          wood.log,
          wood.strippedLog,
          wood.wood,
          wood.strippedWood
      );  // this also adds them to #minecraft:logs
      valueLookupBuilder(class_3481.field_15491).method_71554(wood.trapdoor);
      valueLookupBuilder(class_3481.field_15472).method_71554(wood.sign);
      valueLookupBuilder(class_3481.field_15492).method_71554(wood.wallSign);
      valueLookupBuilder(class_3481.field_40103).method_71554(wood.hangingSign);
      valueLookupBuilder(class_3481.field_40104).method_71554(wood.wallHangingSign);
      valueLookupBuilder(class_3481.field_22414).method_71554(wood.ladder);
      valueLookupBuilder(class_3481.field_61211).method_71554(wood.shelf);
    }

    valueLookupBuilder(class_3481.field_33715)
        .method_71558(
            LighterEndBlocks.ENDER_BLOCK,
            LighterEndBlocks.MISSING_TILE,
            LighterEndBlocks.DRAGON_BONE_BLOCK,
            LighterEndBlocks.DRAGON_BONE_STAIRS,
            LighterEndBlocks.DRAGON_BONE_SLAB,
            LighterEndBlocks.END_MOSS,
            LighterEndBlocks.END_FURNACE,
            LighterEndBlocks.END_SMOKER,
            LighterEndBlocks.GOLD_CHANDELIER,
            LighterEndBlocks.IRON_CHANDELIER,
            LighterEndBlocks.EMERALD_ICE,
            LighterEndBlocks.FERROUS_ICE,
            LighterEndBlocks.AUROUS_ICE,
            LighterEndBlocks.END_STONE_QUARTZ_ORE,
            LighterEndBlocks.END_STONE_REDSTONE_ORE,
            LighterEndBlocks.UMBRALITH_QUARTZ_ORE,
            LighterEndBlocks.UMBRALITH_REDSTONE_ORE,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.HYDROTHERMAL_VENT
        );
    for (class_2248 chandelier : LighterEndBlocks.COPPER_CHANDELIERS.method_73128()) {
      valueLookupBuilder(class_3481.field_33715).method_71554(chandelier);
    }

    valueLookupBuilder(class_3481.field_33719)
        .method_71554(LighterEndBlocks.ENDER_BLOCK)
        .method_71554(LighterEndBlocks.HYDROTHERMAL_VENT);

    valueLookupBuilder(class_3481.field_33718)
        .method_71558(
            LighterEndBlocks.END_STONE_QUARTZ_ORE,
            LighterEndBlocks.END_STONE_REDSTONE_ORE,
            LighterEndBlocks.UMBRALITH_QUARTZ_ORE,
            LighterEndBlocks.UMBRALITH_REDSTONE_ORE
        );

    valueLookupBuilder(class_3481.field_15460).method_71554(
        LighterEndBlocks.END_MOSS
    );
    valueLookupBuilder(class_3481.field_15460).method_71553(LighterEndTags.FURS);

    valueLookupBuilder(class_3481.field_35567).method_71554(LighterEndBlocks.END_MOSS);
    valueLookupBuilder(class_3481.field_44470).method_71554(LighterEndBlocks.END_MOSS);
    valueLookupBuilder(class_3481.field_37399).method_71554(LighterEndBlocks.END_MOSS);

    valueLookupBuilder(class_3481.field_20339).method_71558(
        LighterEndBlocks.CREEPING_MOSS,
        LighterEndBlocks.UMBRELLA_FERN,
        LighterEndBlocks.TALL_UMBRELLA_FERN,
        LighterEndBlocks.TENANEA_FLOWER,
        LighterEndBlocks.END_LOTUS_FLOWER
    );

    valueLookupBuilder(class_3481.field_33713).method_71558(
        LighterEndBlocks.LUMECORN_STEM,
        LighterEndBlocks.END_LOTUS_STEM,
        LighterEndBlocks.UMBRELLA_TREE_CLUSTER,
        LighterEndBlocks.UMBRELLA_TREE_CLUSTER_EMPTY,
        LighterEndBlocks.GLOWSHROOM_CAP,
        LighterEndBlocks.GLOWSHROOM_HYMENOPHORE,
        LighterEndBlocks.END_LOTUS_STEM,
        LighterEndBlocks.AGAVE,
        LighterEndBlocks.AGAVE_BULB
    );

    valueLookupBuilder(class_3481.field_15462).method_71558(
        LighterEndBlocks.TENANEA_SAPLING,
        LighterEndBlocks.UMBRELLA_TREE_SAPLING,
        LighterEndBlocks.GLOWSHROOM_SAPLING,
        LighterEndBlocks.DRAGON_SAPLING
    );
    valueLookupBuilder(class_3481.field_15503).method_71558(
        LighterEndBlocks.TENANEA_LEAVES,
        LighterEndBlocks.GLOWSHROOM_FUR,
        LighterEndBlocks.AGAVE_FUR,
        LighterEndBlocks.DRAGON_LEAVES
    );

    valueLookupBuilder(class_3481.field_15470).method_71558(
        LighterEndBlocks.POTTED_TENANEA_SAPLING,
        LighterEndBlocks.POTTED_UMBRELLA_SAPLING,
        LighterEndBlocks.POTTED_GLOWSHROOM_SAPLING
    );

    valueLookupBuilder(class_3481.field_49051).method_71554(
        LighterEndBlocks.OBELISK
    );
    valueLookupBuilder(class_3481.field_17753).method_71554(
        LighterEndBlocks.OBELISK
    );
    valueLookupBuilder(class_3481.field_33757).method_71554(
        LighterEndBlocks.OBELISK
    );
    valueLookupBuilder(class_3481.field_33863).method_71554(
        LighterEndBlocks.OBELISK
    );
    valueLookupBuilder(class_3481.field_17754).method_71554(
        LighterEndBlocks.OBELISK
    );

    valueLookupBuilder(class_3481.field_15467).method_71558(
        LighterEndBlocks.EMERALD_ICE,
        LighterEndBlocks.FERROUS_ICE
    );

    valueLookupBuilder(class_3481.field_25588).method_71554(LighterEndBlocks.BRIMSTONE);

    valueLookupBuilder(LighterEndTags.END_MOSS_REPLACEABLE)
        .method_71558(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_22091,
            class_2246.field_10264,
            class_2246.field_10396,
            class_2246.field_10111,
            class_2246.field_10488,
            class_2246.field_10614,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE
        );
    valueLookupBuilder(LighterEndTags.END_SOIL)
        .method_71558(
            LighterEndBlocks.END_MOSS,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    valueLookupBuilder(LighterEndTags.END_STONES)
        .method_71558(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_22091,
            class_2246.field_10264,
            class_2246.field_10396,
            class_2246.field_10111,
            class_2246.field_10488,
            class_2246.field_10614,
            LighterEndBlocks.VIOLECITE.baseBlock,
            LighterEndBlocks.AZURE_JADESTONE.baseBlock,
            LighterEndBlocks.SANDY_JADESTONE.baseBlock,
            LighterEndBlocks.VIRID_JADESTONE.baseBlock,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    valueLookupBuilder(LighterEndTags.AQUATIC_END_SOIL)
        .method_71558(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_10102,
            class_2246.field_9979,
            class_2246.field_10534,
            class_2246.field_10344,
            class_2246.field_10255,
            class_2246.field_10566,
            class_2246.field_10253,
            class_2246.field_37576,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.END_MOSS,  // though pretty sure this won't survive underwater
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    valueLookupBuilder(LighterEndTags.AQUATIC_END_VEGETATION)
        .method_71558(
            LighterEndBlocks.CHARNIA_CYAN,
            LighterEndBlocks.CHARNIA_GREEN,
            LighterEndBlocks.CHARNIA_LIGHT_BLUE,
            LighterEndBlocks.CHARNIA_ORANGE,
            LighterEndBlocks.CHARNIA_PURPLE,
            LighterEndBlocks.CHARNIA_RED
        );
    valueLookupBuilder(LighterEndTags.FURS)
        .method_71558(
            LighterEndBlocks.AGAVE_FUR,
            LighterEndBlocks.GLOWSHROOM_FUR
        );
    valueLookupBuilder(LighterEndTags.SLIME_SPAWNABLE).method_71553(LighterEndTags.END_STONES);
    valueLookupBuilder(LighterEndTags.SLIME_SPAWNABLE).method_71553(LighterEndTags.END_SOIL);
    valueLookupBuilder(LighterEndTags.GROWS_SULPHUR_CRYSTALS).method_71554(LighterEndBlocks.BRIMSTONE);


  }

}
