package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndLootTables;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_52.class_53;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_77;

public class ChestLootTableProvider extends SimpleFabricLootTableProvider {


  public ChestLootTableProvider(
      FabricDataOutput output,
      CompletableFuture<class_7874> registryLookup
  ) {
    super(output, registryLookup, class_173.field_1179);
  }

  @Override
  public void method_10399(BiConsumer<class_5321<class_52>, class_53> lootTableBiConsumer) {
    lootTableBiConsumer.accept(
        LighterEndLootTables.STARTER_CHEST,
        class_52.method_324()
            .method_336(
                class_55.method_347()
                    .method_352(class_44.method_32448(1.0F))
                    .method_351(class_77.method_411(class_1802.field_61341))
                    .method_351(class_77.method_411(class_1802.field_8406).method_437(3))
            )
            .method_336(
                class_55.method_347()
                    .method_352(class_44.method_32448(1.0F))
                    .method_351(class_77.method_411(class_1802.field_61340))
                    .method_351(class_77.method_411(class_1802.field_8647).method_437(3))
            )
            .method_336(
                class_55.method_347()
                    .method_352(class_44.method_32448(3.0F))
                    .method_351(class_77.method_411(LighterEndItems.SHADOW_BERRY).method_437(5).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 2.0F))))
                    .method_351(class_77.method_411(LighterEndItems.POPPED_LUMECORN).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 2.0F))))
                    .method_351(class_77.method_411(LighterEndItems.CRAB_CAKE).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 2.0F))))
            )
            .method_336(
                class_55.method_347()
                    .method_352(class_44.method_32448(4.0F))
                    .method_351(class_77.method_411(class_1802.field_8600).method_437(10).method_438(
                        class_141.method_621(
                            class_5662.method_32462(1.0F, 12.0F))))
                    // the line below is kind of a troll, since Tenanea logs don't generate naturally
                    .method_351(class_77.method_411(LighterEndBlocks.TENANEA.log).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 3.0F))))
                    .method_351(class_77.method_411(LighterEndBlocks.UMBRELLA.log).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 3.0F))))
                    .method_351(class_77.method_411(LighterEndBlocks.LOTUS.log).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 3.0F))))
                    .method_351(class_77.method_411(LighterEndBlocks.GLOWSHROOM.log).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 3.0F))))
                    .method_351(class_77.method_411(LighterEndBlocks.DRAGON.log).method_437(3).method_438(
                        class_141.method_621(class_5662.method_32462(1.0F, 3.0F))))

            )
            .method_336(
                class_55.method_347()
                    .method_352(class_44.method_32448(1.0F))
                    .method_351(class_77.method_411(LighterEndItems.CRAB_CLAW).method_437(5).method_438(
                        class_141.method_621(class_5662.method_32462(2.0F, 4.0F))))
                    .method_351(class_77.method_411(class_1802.field_8868))
            )
    );
  }
}
