package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks.Material;
import io.github.openbagtwo.lighterend.registries.LighterEndEquipment;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;

public class ItemTagProvider extends FabricTagProvider.ItemTagProvider {

  public ItemTagProvider(
      FabricDataOutput output,
      CompletableFuture<class_7874> future
  ) {
    super(output, future);
  }

  @Override
  protected void method_10514(class_7225.class_7874 lookup) {
    for (WoodSet wood : Arrays.asList(
        LighterEndBlocks.TENANEA,
        LighterEndBlocks.UMBRELLA,
        LighterEndBlocks.LOTUS,
        LighterEndBlocks.GLOWSHROOM,
        LighterEndBlocks.DRAGON
    )) {
      valueLookupBuilder(LighterEndTags.LOG_TAGS.get(wood.baseName)).method_71558(
          wood.log.method_8389(),
          wood.strippedLog.method_8389(),
          wood.wood.method_8389(),
          wood.strippedWood.method_8389()
      );
      valueLookupBuilder(LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName)).method_71558(
          wood.strippedLog.method_8389(),
          wood.strippedWood.method_8389()
      );
      valueLookupBuilder(class_3489.field_23212).method_71553(
          LighterEndTags.LOG_TAGS.get(wood.baseName)
      );
      valueLookupBuilder(class_3489.field_15537).method_71554(wood.planks.method_8389());
      valueLookupBuilder(class_3489.field_15555).method_71554(wood.button.method_8389());
      valueLookupBuilder(class_3489.field_15552).method_71554(wood.door.method_8389());
      valueLookupBuilder(class_3489.field_15557).method_71554(wood.stairs.method_8389());
      valueLookupBuilder(class_3489.field_15534).method_71554(wood.slab.method_8389());
      valueLookupBuilder(class_3489.field_17620).method_71554(wood.fence.method_8389());
      valueLookupBuilder(class_3489.field_40858).method_71554(wood.gate.method_8389());
      valueLookupBuilder(class_3489.field_15540).method_71554(wood.pressurePlate.method_8389());
      valueLookupBuilder(class_3489.field_15550).method_71554(wood.trapdoor.method_8389());
      valueLookupBuilder(class_3489.field_15533).method_71554(wood.sign.method_8389());
      valueLookupBuilder(class_3489.field_40108).method_71554(wood.hangingSign.method_8389());
      valueLookupBuilder(class_3489.field_61218).method_71554(wood.shelf.method_8389());

    }
    for (Material material : Arrays.asList(
        LighterEndBlocks.VIOLECITE,
        LighterEndBlocks.AZURE_JADESTONE,
        LighterEndBlocks.SANDY_JADESTONE,
        LighterEndBlocks.VIRID_JADESTONE,
        LighterEndBlocks.UMBRALITH,
        LighterEndBlocks.BORNITE
    )) {
      valueLookupBuilder(class_3489.field_44592).method_71554(material.button.method_8389());
    }
    valueLookupBuilder(class_3489.field_49943).method_71554(LighterEndBlocks.LUMECORN_SEED.method_8389());
    valueLookupBuilder(class_3489.field_49942).method_71554(LighterEndBlocks.TENANEA_FLOWER.method_8389());
    valueLookupBuilder(class_3489.field_15558).method_71558(
        LighterEndBlocks.TENANEA_LEAVES.method_8389(),
        LighterEndItems.GLOWSHROOM_FUR,
        LighterEndItems.AGAVE_FUR,
        LighterEndBlocks.DRAGON_LEAVES.method_8389()
    );

    valueLookupBuilder(class_3489.field_15527).method_71554(LighterEndItems.RAW_END_FISH);

    valueLookupBuilder(class_3489.field_48803).method_71554(
        LighterEndEquipment.SILK_ELYTRA
    );

    valueLookupBuilder(class_3489.field_48296).method_71554(
        LighterEndEquipment.SILK_ELYTRA
    );  // this makes silk elytra trimmable

    valueLookupBuilder(class_3489.field_54554).method_71553(LighterEndTags.FUR_ITEMS);

    valueLookupBuilder(class_3489.field_54213).method_71554(LighterEndItems.END_POWDER);

    valueLookupBuilder(class_3489.field_49932).method_71558(
        LighterEndItems.CRAB_MEAT,
        LighterEndItems.CRAB_CAKE
    );

    valueLookupBuilder(class_3489.field_26988).method_71558(
        LighterEndItems.CRAB_MEAT,
        LighterEndItems.CRAB_CAKE
    );

    valueLookupBuilder(class_3489.field_41891).method_71554(
        LighterEndItems.AURORA_CRYSTAL_SHARD
    );

    valueLookupBuilder(LighterEndTags.REPAIRS_SILK_ARMOR).method_71554(LighterEndItems.SILK);

    valueLookupBuilder(LighterEndTags.FLETCHINGS).method_71558(
        class_1802.field_8153,
        LighterEndBlocks.CHARNIA_CYAN.method_8389(),
        LighterEndBlocks.CHARNIA_GREEN.method_8389(),
        LighterEndBlocks.CHARNIA_LIGHT_BLUE.method_8389(),
        LighterEndBlocks.CHARNIA_ORANGE.method_8389(),
        LighterEndBlocks.CHARNIA_PURPLE.method_8389(),
        LighterEndBlocks.CHARNIA_RED.method_8389()
    );
    valueLookupBuilder(LighterEndTags.FLETCHINGS).method_71553(LighterEndTags.FUR_ITEMS);

    valueLookupBuilder(LighterEndTags.FUR_ITEMS).method_71558(
        LighterEndItems.GLOWSHROOM_FUR,
        LighterEndItems.AGAVE_FUR
    );

    valueLookupBuilder(LighterEndTags.POLYPORES).method_71558(
        LighterEndBlocks.AURANT_POLYPORE.method_8389(),
        LighterEndBlocks.PURPLE_POLYPORE.method_8389()
    );

    valueLookupBuilder(LighterEndTags.MOOSHROOM_FOOD).method_71554(
        LighterEndItems.LUMECORN_EAR
    );
  }


}
