package io.github.openbagtwo.lighterend.mixin.client;

import io.github.openbagtwo.lighterend.LighterEnd;
import java.util.Optional;
import net.minecraft.class_10383;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5195;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8144;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_310.class)
public abstract class EndBiomeMusicMixin {

  @Shadow
  public @Nullable class_437 currentScreen;

  @Shadow
  public @Nullable class_746 player;

  @Shadow
  public class_329 inGameHud;


  @Inject(method = "getMusicInstance", at = @At("HEAD"), cancellable = true)
  public void checkForEndMusic(CallbackInfoReturnable<class_10383> cir) {
    class_5195 musicSound = class_8144.method_49077(this.currentScreen, class_437::method_50024);
    if (LighterEnd.CONFIG.playEndBiomeMusic() && musicSound == null && this.player != null) {
      class_1937 world = this.player.method_73183();
      if (
          world.method_27983() == class_1937.field_25181
              && !this.inGameHud.method_1740().method_1798()
      ) {
        class_6880<class_1959> registryEntry = world.method_23753(this.player.method_24515());
        class_1959 biome = registryEntry.comp_349();
        Optional<class_6012<class_5195>> biomeMusic = biome.method_27343();
        if (biomeMusic.isPresent()) {
          float f = biome.method_65133();
          Optional<class_5195> music = biomeMusic.get().method_34992(world.field_9229);
          cir.setReturnValue(new class_10383(music.orElse(null), f));
        } else {
          cir.setReturnValue(
              new class_10383(
                  new class_5195(class_3417.field_14631, 6000, 24000, false)
              )
          );
        }
        cir.cancel();
      }
    }

  }

}
