package io.github.openbagtwo.lighterend.mobs;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.models.CrabModel;
import io.github.openbagtwo.lighterend.mobs.models.CubozoaModel;
import io.github.openbagtwo.lighterend.mobs.models.DragonflyModel;
import io.github.openbagtwo.lighterend.mobs.models.EndFishModel;
import io.github.openbagtwo.lighterend.mobs.models.EndSlimeModel;
import io.github.openbagtwo.lighterend.mobs.models.SilkMothModel;
import io.github.openbagtwo.lighterend.mobs.renderers.CrabRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.CubozoaRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.DragonflyRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.EndFishRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.EndSlimeRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.GlossyMooshroomRenderer;
import io.github.openbagtwo.lighterend.mobs.renderers.SilkMothRenderer;
import io.github.openbagtwo.lighterend.registries.LighterEndMobs;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_560;
import net.minecraft.class_5601;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_927;

public class EntityModels {

  public static final class_5601 SILK_MOTH_MODEL = makeLayer("silk_moth");
  public static final class_5601 SILK_MOTH_BABY = makeLayer("silk_moth_baby");
  public static final class_5601 DRAGONFLY_MODEL = makeLayer("dragonfly");
  public static final class_5601 END_FISH_MODEL = makeLayer("end_fish");
  public static final class_5601 CUBOZOA_MODEL = makeLayer("cubozoa");
  public static final class_5601 END_SLIME_MODEL = makeLayer("end_slime");
  public static final class_5601 END_SLIME_SHELL_MODEL = makeLayer("end_slime_shell");
  public static final class_5601 MOOSHROOM_MODEL = makeLayer("mooshroom");
  public static final class_5601 CRAB_MODEL = makeLayer("chorus_crab");
  public static final class_5601 CRAB_BABY = makeLayer("chorus_crab_baby");

  public static void initialize() {
    EntityModelLayerRegistry.registerModelLayer(EntityModels.SILK_MOTH_MODEL,
        SilkMothModel::getTexturedModelData);
    register(LighterEndMobs.SILK_MOTH.mob, SilkMothRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(SILK_MOTH_BABY,
        () -> SilkMothModel.getTexturedModelData().method_62137(SilkMothModel.BABY_TRANSFORMER));

    EntityModelLayerRegistry.registerModelLayer(EntityModels.DRAGONFLY_MODEL,
        DragonflyModel::getTexturedModelData);
    register(LighterEndMobs.DRAGONFLY.mob, DragonflyRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(EntityModels.END_FISH_MODEL,
        EndFishModel::getTexturedModelData);
    register(LighterEndMobs.END_FISH.mob, EndFishRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(EntityModels.CUBOZOA_MODEL,
        CubozoaModel::getTexturedModelData);
    register(LighterEndMobs.CUBOZOA.mob, CubozoaRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(END_SLIME_MODEL,
        EndSlimeModel::getInnerTexturedModelData);
    EntityModelLayerRegistry.registerModelLayer(
        END_SLIME_SHELL_MODEL,
        EndSlimeModel::getOuterTexturedModelData
    );
    register(LighterEndMobs.END_SLIME.mob, EndSlimeRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(EntityModels.MOOSHROOM_MODEL,
        class_560::method_31990);
    register(LighterEndMobs.MOOSHROOM.mob, GlossyMooshroomRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(EntityModels.CRAB_MODEL,
        CrabModel::getTexturedModelData);
    register(LighterEndMobs.CHORUS_CRAB.mob, CrabRenderer::new);

    EntityModelLayerRegistry.registerModelLayer(CRAB_BABY,
        () -> CrabModel.getTexturedModelData().method_62137(CrabModel.BABY_TRANSFORMER));
  }

  private static void register(class_1299<?> type, Function<class_5618, class_927> renderer) {
    EntityRendererRegistry.register(type, renderer::apply);
  }

  private static class_5601 makeLayer(String name) {
    return new class_5601(LighterEnd.of(name), "main");
  }
}
