package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.EndSlime;
import io.github.openbagtwo.lighterend.mobs.EntityModels;
import io.github.openbagtwo.lighterend.mobs.models.EndSlimeModel;
import io.github.openbagtwo.lighterend.mobs.states.EndSlimeRenderState;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import net.minecraft.class_927;

public class EndSlimeRenderer extends
    class_927<EndSlime, EndSlimeRenderState, EndSlimeModel> {

  private static final List<class_2960> TEXTURES = Arrays.asList(
      LighterEnd.of("textures/entity/end_slime/end_slime.png"),
      LighterEnd.of("textures/entity/end_slime/end_slime_mossy.png"),
      LighterEnd.of("textures/entity/end_slime/end_slime_lake.png"),
      LighterEnd.of("textures/entity/end_slime/end_slime_amber.png")
  );
  private static final List<class_1921> GLOW = Arrays.asList(
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_slime/end_slime_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_slime/end_slime_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_slime/end_slime_lake_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_slime/end_slime_amber_glow.png"))
  );

  public EndSlimeRenderer(class_5617.class_5618 context) {
    super(context, new EndSlimeModel(context.method_32167(EntityModels.END_SLIME_MODEL), false), 0.25F);
    this.method_4046(new OverlayFeatureRenderer(this, context.method_32170()));
    this.method_4046(new class_4606<>(this) {
      @Override
      public class_1921 method_23193() {
        return GLOW.get(0);
      }

      @Override
      public void render(
          class_4587 matrices,
          class_11659 queue,
          int light,
          EndSlimeRenderState state,
          float limbAngle,
          float limbDistance
      ) {
        queue.method_73529(1)
            .method_73490(
                this.method_17165(),
                state,
                matrices,
                GLOW.get(state.variant % GLOW.size()),
                15728640,
                class_4608.field_21444,
                0xffffffff,
                null,
                state.field_61821,
                null
            );
      }
    });
  }

  @Override
  protected float getShadowRadius(EndSlimeRenderState state) {
    return state.size * 0.25F;
  }

  @Override
  protected void scale(EndSlimeRenderState state, class_4587 matrixStack) {
    float f = 0.999F;
    matrixStack.method_22905(0.999F, 0.999F, 0.999F);
    matrixStack.method_46416(0.0F, 0.001F, 0.0F);
    float g = state.size;
    float h = state.stretch / (g * 0.5F + 1.0F);
    float i = 1.0F / (h + 1.0F);
    matrixStack.method_22905(i * g, 1.0F / i * g, i * g);
  }

  @Override
  public class_2960 getTexture(EndSlimeRenderState state) {
    return TEXTURES.get(state.variant % TEXTURES.size());
  }

  @Override
  public EndSlimeRenderState method_55269() {
    return new EndSlimeRenderState();
  }

  @Override
  public void updateRenderState(EndSlime slime, EndSlimeRenderState state, float f) {
    super.method_62355(slime, state, f);
    state.variant = slime.getSlimeType();
    state.stretch = class_3532.method_16439(f, slime.field_7387, slime.field_7388);
    state.size = slime.method_7152();
  }

  public static class OverlayFeatureRenderer extends
      class_3887<EndSlimeRenderState, EndSlimeModel> {

    private final EndSlimeModel model;

    public OverlayFeatureRenderer(
        class_3883<EndSlimeRenderState, EndSlimeModel> context,
        class_5599 loader) {
      super(context);
      this.model = new EndSlimeModel(loader.method_32072(EntityModels.END_SLIME_SHELL_MODEL), true);
    }

    @Override
    public void render(
        class_4587 matrixStack,
        class_11659 queue,
        int light,
        EndSlimeRenderState state,
        float limbAngle,
        float limbDistance
    ) {
      this.model.method_2819(state);

      boolean renderAsModel = state.method_72997() && state.field_53333;
      if (!state.field_53333 || renderAsModel) {
        int j = class_922.method_23622(state, 0.0F);
        if (renderAsModel) {
          queue.method_73529(1)
              .method_73490(
                  this.model,
                  state,
                  matrixStack,
                  class_1921.method_23580(TEXTURES.get(state.variant % TEXTURES.size())),
                  light,
                  j,
                  -1,
                  null,
                  state.field_61821,
                  null
              );
        } else {
          queue.method_73529(1)
              .method_73490(
                  this.model,
                  state,
                  matrixStack,
                  class_1921.method_23580(TEXTURES.get(state.variant % TEXTURES.size())),
                  light,
                  j,
                  -1,
                  null,
                  state.field_61821,
                  null
              );
        }
      }
    }
  }


}
