package io.github.openbagtwo.lighterend.registries;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.blocks.Furnaces;
import io.github.openbagtwo.lighterend.blocks.Shelf;
import io.github.openbagtwo.lighterend.blocks.Signs.LighterEndHangingSignBlockEntity;
import io.github.openbagtwo.lighterend.blocks.Signs.LighterEndSignBlockEntity;
import io.github.openbagtwo.lighterend.blocks.entities.PedestalDisplay;
import io.github.openbagtwo.lighterend.blocks.entities.SilkMothNestEntity;
import io.github.openbagtwo.lighterend.blocks.entities.Updraft;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public class LighterEndBlockEntities {

  public static final class_2591<LighterEndSignBlockEntity> SIGN = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("sign"),
      FabricBlockEntityTypeBuilder.create(
          LighterEndSignBlockEntity::new,
          LighterEndBlocks.TENANEA.sign,
          LighterEndBlocks.TENANEA.wallSign,
          LighterEndBlocks.UMBRELLA.sign,
          LighterEndBlocks.UMBRELLA.wallSign,
          LighterEndBlocks.LOTUS.sign,
          LighterEndBlocks.LOTUS.wallSign,
          LighterEndBlocks.GLOWSHROOM.sign,
          LighterEndBlocks.GLOWSHROOM.wallSign,
          LighterEndBlocks.DRAGON.sign,
          LighterEndBlocks.DRAGON.wallSign
      ).build(null));

  public static final class_2591<LighterEndHangingSignBlockEntity> HANGING_SIGN = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("hanging_sign"),
      FabricBlockEntityTypeBuilder.create(
          LighterEndHangingSignBlockEntity::new,
          LighterEndBlocks.TENANEA.hangingSign,
          LighterEndBlocks.TENANEA.wallHangingSign,
          LighterEndBlocks.UMBRELLA.hangingSign,
          LighterEndBlocks.UMBRELLA.wallHangingSign,
          LighterEndBlocks.LOTUS.hangingSign,
          LighterEndBlocks.LOTUS.wallHangingSign,
          LighterEndBlocks.GLOWSHROOM.hangingSign,
          LighterEndBlocks.GLOWSHROOM.wallHangingSign,
          LighterEndBlocks.DRAGON.hangingSign,
          LighterEndBlocks.DRAGON.wallHangingSign
      ).build(null));

  public static final class_2591<Shelf.Entity> SHELF = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("shelf"),
      FabricBlockEntityTypeBuilder.create(
          Shelf.Entity::new,
          LighterEndBlocks.TENANEA.shelf,
          LighterEndBlocks.UMBRELLA.shelf,
          LighterEndBlocks.LOTUS.shelf,
          LighterEndBlocks.GLOWSHROOM.shelf,
          LighterEndBlocks.DRAGON.shelf
      ).build(null));

  public static final class_2591<Furnaces.EndFurnaceEntity> END_FURNACE = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("end_stone_furnace"),
      FabricBlockEntityTypeBuilder.create(
          Furnaces.EndFurnaceEntity::new, LighterEndBlocks.END_FURNACE
      ).build(null));

  public static final class_2591<Furnaces.EndSmokerEntity> END_SMOKER = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("end_stone_smoker"),
      FabricBlockEntityTypeBuilder.create(
          Furnaces.EndSmokerEntity::new, LighterEndBlocks.END_SMOKER
      ).build(null));

  public static final class_2591<SilkMothNestEntity> SILK_MOTH_NEST = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("silk_moth_nest"),
      FabricBlockEntityTypeBuilder.create(
          SilkMothNestEntity::new, LighterEndBlocks.SILK_MOTH_NEST
      ).build(null)
  );

  public static final class_2591<Updraft> UPDRAFT = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("updraft"),
      FabricBlockEntityTypeBuilder.create(
          Updraft::new, LighterEndBlocks.HYDROTHERMAL_VENT
      ).build(null)
  );

  public static final class_2591<PedestalDisplay> PEDESTAL = class_2378.method_10230(
      class_7923.field_41181,
      LighterEnd.of("pedestal"),
      FabricBlockEntityTypeBuilder.create(
          PedestalDisplay::new,
          LighterEndBlocks.VIOLECITE.pedestal,
          LighterEndBlocks.AZURE_JADESTONE.pedestal,
          LighterEndBlocks.SANDY_JADESTONE.pedestal,
          LighterEndBlocks.VIRID_JADESTONE.pedestal,
          LighterEndBlocks.UMBRALITH.pedestal,
          LighterEndBlocks.BORNITE.pedestal
      ).build(null)
  );

  public static void initialize() {
  }

}
