package io.github.openbagtwo.lighterend.registries;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.items.Fur;
import io.github.openbagtwo.lighterend.items.LighterEndFoodComponents;
import io.github.openbagtwo.lighterend.items.Matchstick;
import io.github.openbagtwo.lighterend.items.TPTotem;
import io.github.openbagtwo.lighterend.registries.LighterEndData.SilkLevelComponent;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3612;
import net.minecraft.class_4176;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class LighterEndItems {

  public static final class_1792 AURORA_CRYSTAL_SHARD = register(
      "aurora_crystal_shard",
      new class_1793().method_67189(LighterEndTrimming.AURORA)
  );
  public static final class_1792 LUMECORN_EAR = register("lumecorn_rod");
  public static final class_1792 POPPED_LUMECORN = register(
      "lumecorn_popped",
      new class_1793().method_62833(
          LighterEndFoodComponents.POPPED_LUMECORN_NUTRITION,
          LighterEndFoodComponents.POPPED_LUMECORN_EFFECT)
  );
  public static final class_1792 SILK = register("silk_fiber");
  public static final class_1792 SILK_MATRIX = register("silk_matrix");
  public static class_1792 SILK_MOTH_NEST = register(
      "silk_moth_nest",
      settings -> new class_1747(
          LighterEndBlocks.SILK_MOTH_NEST,
          settings
              .method_57349(LighterEndData.MOTHS, LighterEndData.MothsComponent.DEFAULT)
              .method_57349(LighterEndData.SILK_LEVEL, new SilkLevelComponent(0))
      ),
      new class_1793()
  );

  public static final class_1792 UMBRELLA_JUICE = register(
      "umbrella_juice",
      new class_1793()
          .method_62833(LighterEndFoodComponents.UMBRELLA_JUICE_NUTRITION,
              LighterEndFoodComponents.UMBRELLA_JUICE_EFFECT)
          .method_62834(class_1802.field_8469)
          .method_7896(class_1802.field_8469)
          .method_7889(16)
  );
  public static final class_1792 END_FISH_BUCKET = register("bucket_end_fish",
      settings -> new class_1785(
          LighterEndMobs.END_FISH.mob, class_3612.field_15910, class_3417.field_14912, settings),
      new class_1792.class_1793().method_7889(1)
          .method_57349(class_9334.field_49610, class_9279.field_49302));
  public static final class_1792 CUBOZOA_BUCKET = register("bucket_cubozoa",
      settings -> new class_1785(LighterEndMobs.CUBOZOA.mob, class_3612.field_15910,
          class_3417.field_14912, settings),
      new class_1792.class_1793().method_7889(1)
          .method_57349(class_9334.field_49610, class_9279.field_49302));
  public static final class_1792 RAW_END_FISH = register("end_fish", new class_1793()
      .method_19265(class_4176.field_18637));
  public static final class_1792 GLOW_BARB = register("glow_barb");

  public static final class_1792 END_LILY_LEAF = register("end_lily_leaf");
  public static final class_1792 DRIED_END_LILY_LEAF = register("end_lily_leaf_dried");

  public static final class_1792 GLOWSHROOM_FUR = register(
      "mossy_glowshroom_fur",
      settings -> new Fur(LighterEndBlocks.GLOWSHROOM_FUR, settings),
      new class_1793()
  );
  public static final class_1792 AGAVE_FUR = register(
      "blue_vine_fur",
      settings -> new Fur(LighterEndBlocks.AGAVE_FUR, settings),
      new class_1793()
  );

  public static final class_1792 END_CREAM = register("end_cream");
  public static final class_1792 END_POWDER = register("end_powder");

  public static final class_1792 CRAB_CLAW = register("crab_claw");
  public static final class_1792 CRAB_MEAT = register(
      "crab_meat",
      new class_1793().method_62833(
          LighterEndFoodComponents.CRAB_MEAT,
          LighterEndFoodComponents.RAW_CRAB_MEAT_EFFECT
      )
  );
  public static final class_1792 CRAB_CAKE = register(
      "crab_cake",
      new class_1793().method_19265(LighterEndFoodComponents.CRAB_CAKE)
  );

  public static final class_1792 TOTEM_OF_TELEPORTATION = register(
      "totem_of_teleportation",
      TPTotem::new,
      new class_1793()
  );

  public static final class_1792 CRYSTALLINE_SULPHUR = register("sulphur_crystalline");

  public static final class_1792 MATCHSTICK = register("matchstick", Matchstick::new, new class_1793());

  public static final class_1792 SHADOW_BERRY_SEEDS = register(
      "shadow_berry_seeds",
      settings -> new class_1747(
          LighterEndBlocks.SHADOW_BERRY,
          settings.method_63687()
      ),
      new class_1793()
  );
  public static final class_1792 SHADOW_BERRY = register(
      "shadow_berry",
      new class_1793().method_19265(LighterEndFoodComponents.SHADOW_BERRY)
  );
  public static final class_1792 SHADOW_BERRY_COOKED = register(
      "shadow_berry_cooked",
      new class_1793().method_19265(LighterEndFoodComponents.SHADOW_BERRY_COOKED)
  );
  public static final class_1792 SHADOW_BERRY_JAM = register(
      "shadow_berry_jam",
      new class_1793().method_62833(
              LighterEndFoodComponents.SHADOW_BERRY_JAM,
              LighterEndFoodComponents.SHADOW_BERRY_JAM_EFFECT
          ).method_62834(class_1802.field_8469)
          .method_7896(class_1802.field_8469)
          .method_7889(16)
  );

  public static class_1792 register(String name) {
    return register(name, new class_1793());
  }

  public static class_1792 register(String name, class_1793 settings) {
    return register(name, class_1792::new, settings);
  }

  public static class_1792 register(String name, Function<class_1793, class_1792> factory, class_1793 settings) {
    class_2960 id = LighterEnd.of(name);
    class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, id);
    return class_2378.method_39197(class_7923.field_41178, key, factory.apply(settings.method_63686(key)));
  }

  public static void initialize() {
  }

}
