package io.github.openbagtwo.lighterend.world.features;

import io.github.openbagtwo.lighterend.blocks.EndLotus;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.utils.Flags;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class LotusLeaf extends class_3031<class_3111> {

  public LotusLeaf() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featureConfig) {

    final class_2338 pos = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();

    if (!canGenerate(world, pos)) {
      return false;
    }

    class_2339 p = new class_2339();
    class_2680 leaf = LighterEndBlocks.END_LOTUS_LEAF.method_9564();
    world.method_8652(pos, leaf.method_11657(EndLotus.Leaf.SHAPE, EndLotus.Shape.BOTTOM), Flags.SILENT);
    for (class_2350 move : class_2350.class_2353.field_11062) {
      world.method_8652(
          p.method_10101(pos).method_10098(move),
          leaf.method_11657(EndLotus.Leaf.HORIZONTAL_FACING, move)
              .method_11657(EndLotus.Leaf.SHAPE, EndLotus.Shape.MIDDLE),
          Flags.SILENT
      );
    }
    for (int i = 0; i < 4; i++) {
      class_2350 d1 = class_2350.class_2353.field_11062.method_29716().toList().get(i);
      class_2350 d2 = class_2350.class_2353.field_11062.method_29716().toList().get((i + 1) & 3);
      world.method_8652(
          p.method_10101(pos).method_10098(d1).method_10098(d2),
          leaf.method_11657(EndLotus.Leaf.HORIZONTAL_FACING, d1)
              .method_11657(EndLotus.Leaf.SHAPE, EndLotus.Shape.TOP),
          Flags.SILENT
      );
    }
    return true;
  }


  private boolean canGenerate(class_5281 world, class_2338 pos) {
    class_2339 p = new class_2339();
    p.method_33098(pos.method_10264());
    int count = 0;
    for (int x = -1; x < 2; x++) {
      p.method_33097(pos.method_10263() + x);
      for (int z = -1; z < 2; z++) {
        p.method_33099(pos.method_10260() + z);
        if (world.method_22347(p) && world.method_8320(p.method_10074()).method_27852(class_2246.field_10382)) {
          count++;
        }
      }
    }
    return count == 9;
  }

}
