package io.github.openbagtwo.lighterend.world.structures.pieces;

import com.google.common.collect.Maps;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndStructures;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902.class_2903;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;

public class LakePiece extends BasePiece {

  private static final class_2680 ENDSTONE = class_2246.field_10471.method_9564();
  private static final class_2680 WATER = class_2246.field_10382.method_9564();
  private static final class_2680 SAND = class_2246.field_10102.method_9564();

  private final Map<Integer, Byte> heightmap = Maps.newHashMap();
  private OpenSimplexNoise noise;
  private class_2338 center;
  private float radius;
  private float aspect;
  private float depth;
  private int seed;

  public LakePiece(class_2338 center, float radius, float depth, class_5819 random,
      class_6880<class_1959> biome) {
    super(LighterEndStructures.LAKE_PIECE, random.method_43054(), null);
    this.center = center;
    this.radius = radius;
    this.depth = depth;
    this.seed = random.method_43054();
    this.noise = new OpenSimplexNoise(this.seed);
    this.aspect = radius / depth;
    makeBoundingBox();
  }

  public LakePiece(class_6625 type, class_2487 tag) {
    super(LighterEndStructures.LAKE_PIECE, tag);
    makeBoundingBox();
  }

  @Override
  protected void addAdditionalSaveData(class_2487 tag) {
    tag.method_67494("center", class_2338.field_25064, center);
    tag.method_10548("radius", radius);
    tag.method_10548("depth", depth);
    tag.method_10569("seed", seed);
  }

  @Override
  protected void fromNbt(class_2487 tag) {
    center = tag.method_67491("center", class_2338.field_25064).orElse(class_2338.field_10980);
    radius = tag.method_10583("radius").get();
    depth = tag.method_10583("depth").get();
    seed = tag.method_10550("seed").get();
    noise = new OpenSimplexNoise(seed);
    aspect = radius / depth;
  }

  @Override
  public void method_14931(
      class_5281 world,
      class_5138 arg,
      class_2794 chunkGenerator,
      class_5819 random,
      class_3341 blockBox,
      class_1923 chunkPos,
      class_2338 blockPos
  ) {
    int minY = this.field_15315.method_35416();
    int maxY = this.field_15315.method_35419();
    int sx = class_4076.method_18688(chunkPos.field_9181);
    int sz = class_4076.method_18688(chunkPos.field_9180);
    class_2339 mut = new class_2339();
    class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
    for (int x = 0; x < 16; x++) {
      mut.method_33097(x);
      int wx = x | sx;
      double nx = wx * 0.1;
      int x2 = wx - center.method_10263();
      for (int z = 0; z < 16; z++) {
        mut.method_33099(z);
        int wz = z | sz;
        double nz = wz * 0.1;
        int z2 = wz - center.method_10260();
        float clamp = getHeightClamp(world, 8, wx, wz);
        if (clamp < 0.01) {
          continue;
        }

        double n = noise.eval(nx, nz) * 1.5 + 1.5;
        double x3 = Math.pow(x2 + noise.eval(nx, nz, 100) * 10, 2);
        double z3 = Math.pow(z2 + noise.eval(nx, nz, -100) * 10, 2);

        for (int y = maxY; y >= minY; y--) {
          mut.method_33098((int) (y + n));
          double y2 = Math.pow((y - center.method_10264()) * aspect, 2);
          double r2 = radius * clamp;
          double r3 = r2 + 8;
          r2 *= r2;
          r3 = r3 * r3 + 100;
          double dist = x3 + y2 + z3;
          if (dist < r2) {
            class_2680 state = chunk.method_8320(mut);
            if (state.method_26164(LighterEndTags.END_STONES) || state.method_26215()) {
              state = mut.method_10264() < center.method_10264() ? WATER : field_15314;
              chunk.method_66480(mut, state);
            }
          } else if (dist <= r3 && mut.method_10264() < center.method_10264()) {
            class_2680 state = chunk.method_8320(mut);
            class_2338 worldPos = mut.method_10069(sx, 0, sz);
            if (!state.method_26234(world, worldPos) && !state.method_26212(
                world,
                worldPos
            )) {
              state = chunk.method_8320(mut.method_10086(3));
              final class_2680 stateAbove = chunk.method_8320(mut.method_10084());
              if (stateAbove.method_26215() && state.method_26215()) {
                state =
                    random.method_43048(10) == 0 ? ENDSTONE
                        : LighterEndBlocks.END_MOSS.method_9564();
              } else if (stateAbove.method_26215()) {
                state =
                    random.method_43056() ? ENDSTONE : LighterEndBlocks.END_MOSS.method_9564();
              } else {
                state = state.method_26227().method_15769()
                    ? ENDSTONE
                    : SAND;
              }
              chunk.method_66480(mut, state);
            }
          }
        }
      }
    }
    fixWater(world, chunk, mut, random, sx, sz);
  }

  private void fixWater(
      class_5281 world,
      class_2791 chunk,
      class_2339 mut,
      class_5819 random,
      int sx,
      int sz
  ) {
    int minY = this.field_15315.method_35416();
    int maxY = this.field_15315.method_35419();
    for (int x = 0; x < 16; x++) {
      mut.method_33097(x);
      for (int z = 0; z < 16; z++) {
        mut.method_33099(z);
        for (int y = minY; y <= maxY; y++) {
          mut.method_33098(y);
          class_3610 state = chunk.method_8316(mut);
          if (!state.method_15769()) {
            mut.method_33098(y - 1);
            if (chunk.method_8320(mut).method_26215()) {
              mut.method_33098(y + 1);

              class_2680 bState = chunk.method_8320(mut);
              if (bState.method_26215()) {
                bState = random.method_43056()
                    ? ENDSTONE
                    : LighterEndBlocks.END_MOSS.method_9564();
              } else {
                bState = bState.method_26227().method_15769()
                    ? ENDSTONE
                    : SAND;
              }

              mut.method_33098(y);

              makeEndstonePillar(chunk, mut, bState);
            } else if (x > 1 && x < 15 && z > 1 && z < 15) {
              mut.method_33098(y);
              for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 wPos = mut.method_10069(dir.method_10148(), 0, dir.method_10165());
                if (chunk.method_8320(wPos).method_26215()) {
                  mut.method_33098(y + 1);
                  class_2680 bState = chunk.method_8320(mut);
                  if (bState.method_26215()) {
                    bState = random.method_43056()
                        ? ENDSTONE
                        : LighterEndBlocks.END_MOSS.method_9564();
                  } else {
                    bState = bState.method_26227().method_15769()
                        ? ENDSTONE
                        : SAND;
                  }
                  mut.method_33098(y);
                  makeEndstonePillar(chunk, mut, bState);
                  break;
                }
              }
            } else if (chunk.method_8320(mut.method_10098(class_2350.field_11036)).method_26215()) {
              chunk.method_12039(mut.method_10098(class_2350.field_11033).method_10062());
            }
          } else if (chunk.method_8320(mut).method_26229()) {
            chunk.method_12039(mut.method_10062());
          }
        }
      }
    }
  }

  private void makeEndstonePillar(class_2791 chunk, class_2339 mut, class_2680 terrain) {
    chunk.method_66480(mut, terrain);
    mut.method_33098(mut.method_10264() - 1);
    while (!chunk.method_8316(mut).method_15769()) {
      chunk.method_66480(mut, ENDSTONE);
      mut.method_33098(mut.method_10264() - 1);
    }
  }

  private int getHeight(class_5281 world, class_2338 pos) {
    int p = ((pos.method_10263() & 2047) << 11) | (pos.method_10260() & 2047);
    int h = heightmap.getOrDefault(p, Byte.MIN_VALUE);
    if (h > Byte.MIN_VALUE) {
      return h;
    }

    h = world.method_8624(class_2903.field_13194, pos.method_10263(), pos.method_10260());
    h = class_3532.method_15382(h - center.method_10264());
    h = h < 8 ? 1 : 0;

    heightmap.put(p, (byte) h);
    return h;
  }

  private float getHeightClamp(class_5281 world, int radius, int posX, int posZ) {
    class_2339 mut = new class_2339();
    int r2 = radius * radius;
    float height = 0;
    float max = 0;
    for (int x = -radius; x <= radius; x++) {
      mut.method_33097(posX + x);
      int x2 = x * x;
      for (int z = -radius; z <= radius; z++) {
        mut.method_33099(posZ + z);
        int z2 = z * z;
        if (x2 + z2 < r2) {
          float mult = 1 - (float) Math.sqrt(x2 + z2) / radius;
          max += mult;
          height += getHeight(world, mut) * mult;
        }
      }
    }
    height /= max;
    return class_3532.method_15363(height, 0, 1);
  }

  private void makeBoundingBox() {
    int minX = class_3532.method_15375(center.method_10263() - radius - 8);
    int minY = class_3532.method_15375(center.method_10264() - depth - 8);
    int minZ = class_3532.method_15375(center.method_10260() - radius - 8);
    int maxX = class_3532.method_15375(center.method_10263() + radius + 8);
    int maxY = class_3532.method_15375(center.method_10264() + depth);
    int maxZ = class_3532.method_15375(center.method_10260() + radius + 8);
    this.field_15315 = new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
  }
}
