/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_322;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class TenaneaFlowerRenderer {
    public static final class_2382[] COLORS = new class_2382[]{new class_2382(250, 111, 222), new class_2382(167, 89, 255), new class_2382(120, 207, 239), new class_2382(255, 87, 182)};

    public static class_322 getBlockColor() {
        return (state, world, pos, tintIndex) -> {
            if (pos == null) {
                pos = class_2338.field_10980;
            }
            long i = (TenaneaFlowerRenderer.getRandom(pos.method_10263(), pos.method_10260()) & 0x3F) + pos.method_10264();
            double delta = (double)i * 0.1;
            int index = class_3532.method_15357((double)delta);
            int index2 = index + 1 & 3;
            delta -= (double)index;
            class_2382 color1 = COLORS[index &= 3];
            class_2382 color2 = COLORS[index2];
            int r = class_3532.method_15357((double)class_3532.method_16436((double)delta, (double)color1.method_10263(), (double)color2.method_10263()));
            int g = class_3532.method_15357((double)class_3532.method_16436((double)delta, (double)color1.method_10264(), (double)color2.method_10264()));
            int b = class_3532.method_15357((double)class_3532.method_16436((double)delta, (double)color1.method_10260(), (double)color2.method_10260()));
            float[] hsb = TenaneaFlowerRenderer.RGBtoHSB(r, g, b, new float[3]);
            return TenaneaFlowerRenderer.HSBtoRGB(hsb[0], Math.max(0.5f, hsb[1]), hsb[2]);
        };
    }

    private static int getRandom(int x, int z) {
        int h = x * 374761393 + z * 668265263;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    private static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[4];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    private static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

