/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.openbagtwo.lighterend.blocks.Obelisk;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndData;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10132;
import net.minecraft.class_10133;
import net.minecraft.class_10134;
import net.minecraft.class_10216;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4019;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5699;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class TPTotem
extends class_1792 {
    public static final class_10216 TOTEM_EFFECTS = new class_10216(List.of(new class_10133(), new class_10132(List.of(new class_1293(class_1294.field_5924, 900, 1))), new FixedTeleport()));

    public TPTotem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7894(class_1814.field_8907).method_57349(class_9334.field_54274, (Object)TOTEM_EFFECTS));
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_57826(LighterEndData.TOTEM_TARGET) || super.method_7886(stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(blockPos);
        if (!state.method_27852(LighterEndBlocks.OBELISK)) {
            return super.method_7884(context);
        }
        switch ((Obelisk.Shape)((Object)state.method_61767(Obelisk.SHAPE, null))) {
            case TOP: {
                blockPos = blockPos.method_10074();
                break;
            }
            case BOTTOM: {
                blockPos = blockPos.method_10084();
                break;
            }
            case MIDDLE: {
                break;
            }
            default: {
                return super.method_7884(context);
            }
        }
        world.method_8396(null, blockPos, LighterEndSounds.TP_TOTEM_TARGET_SET, class_3419.field_15248, 1.0f, 1.0f);
        class_1657 playerEntity = context.method_8036();
        class_1799 itemStack = context.method_8041();
        Target target = new Target(Optional.of(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)blockPos)));
        if (!playerEntity.method_56992() && itemStack.method_7947() == 1) {
            itemStack.method_57379(LighterEndData.TOTEM_TARGET, (Object)target);
        } else {
            class_1799 newStack = itemStack.method_56701((class_1935)LighterEndItems.TOTEM_OF_TELEPORTATION, 1);
            itemStack.method_57008(1, (class_1309)playerEntity);
            newStack.method_57379(LighterEndData.TOTEM_TARGET, (Object)target);
            if (!playerEntity.method_31548().method_7394(newStack)) {
                playerEntity.method_7328(newStack, false);
            }
        }
        return class_1269.field_5812;
    }

    public record Target(Optional<class_4208> target) implements class_9299
    {
        public static final Codec<Target> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4208.field_25066.optionalFieldOf("target").forGetter(Target::target)).apply((Applicative)instance, Target::new));
        public static final class_9139<ByteBuf, Target> PACKET_CODEC = class_9139.method_56434((class_9139)class_4208.field_48451.method_56433(class_9135::method_56382), Target::target, Target::new);

        public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
            if (this.target.isEmpty()) {
                textConsumer.accept((class_2561)class_2561.method_43471((String)"item.lighterend.totem_of_teleportation.no_target").method_27692(class_124.field_1080));
            } else {
                textConsumer.accept((class_2561)class_2561.method_43469((String)"item.lighterend.totem_of_teleportation.targeting", (Object[])new Object[]{this.target.get().comp_2208().method_23854(), class_2561.method_43471((String)this.target.get().comp_2207().method_29177().method_42094())}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            }
        }
    }

    public record FixedTeleport(float diameter) implements class_10134
    {
        private static final float DEFAULT_DIAMETER = 0.0f;
        public static final MapCodec<FixedTeleport> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_34387.optionalFieldOf("diameter", (Object)Float.valueOf(0.0f)).forGetter(FixedTeleport::diameter)).apply((Applicative)instance, FixedTeleport::new));
        public static final class_9139<class_9129, FixedTeleport> PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_48552, FixedTeleport::diameter, FixedTeleport::new);

        public FixedTeleport() {
            this(0.0f);
        }

        public class_10134.class_10135<FixedTeleport> method_62864() {
            return LighterEndData.TOTEM_TELEPORT;
        }

        public boolean method_62866(class_1937 world, class_1799 stack, class_1309 user) {
            Target target = (Target)stack.method_57353().method_58694(LighterEndData.TOTEM_TARGET);
            if (target == null) {
                return false;
            }
            class_4208 tpTarget = target.target().orElse(null);
            if (tpTarget == null) {
                return false;
            }
            class_3218 destinationDimension = world.method_8503().method_3847(tpTarget.comp_2207());
            if (destinationDimension == null) {
                return false;
            }
            destinationDimension.method_8500(tpTarget.comp_2208()).method_12226(true);
            user.method_5731(new class_5454(destinationDimension, tpTarget.comp_2208().method_46558(), class_243.field_1353, user.method_36454(), user.method_36455(), class_5454.field_52245));
            world.method_43276((class_6880)class_5712.field_39446, tpTarget.comp_2208(), class_5712.class_7397.method_43285((class_1297)user));
            if (user instanceof class_4019) {
                world.method_54762(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_24630, class_3419.field_15254);
            } else if (user instanceof class_1657) {
                world.method_54762(null, user.method_23317(), user.method_23318(), user.method_23321(), LighterEndSounds.TOTEM_TELEPORT, class_3419.field_15248);
            }
            user.method_38785();
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                player.method_58396();
            }
            return true;
        }
    }
}

