/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3341;
import net.minecraft.class_5281;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class StructureWorld {
    private final Map<class_1923, Part> parts = Maps.newHashMap();
    private class_1923 lastPos;
    private Part lastPart;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public StructureWorld() {
    }

    public StructureWorld(class_2487 tag) {
        this.minX = tag.method_68083("minX", Integer.MAX_VALUE);
        this.maxX = tag.method_68083("maxX", Integer.MIN_VALUE);
        this.minY = tag.method_68083("minY", Integer.MAX_VALUE);
        this.maxY = tag.method_68083("maxY", Integer.MIN_VALUE);
        this.minZ = tag.method_68083("minZ", Integer.MAX_VALUE);
        this.maxZ = tag.method_68083("maxZ", Integer.MIN_VALUE);
        class_2499 map = (class_2499)tag.method_10554("parts").get();
        map.forEach(element -> {
            class_2487 compound = (class_2487)element;
            Part part = new Part(compound);
            int x = (Integer)compound.method_10550("x").get();
            int z = (Integer)compound.method_10550("z").get();
            this.parts.put(new class_1923(x, z), part);
        });
    }

    public void setBlock(class_2338 pos, class_2680 state) {
        class_1923 cPos = new class_1923(pos);
        if (cPos.equals((Object)this.lastPos)) {
            this.lastPart.addBlock(pos, state);
            return;
        }
        Part part = this.parts.get(cPos);
        if (part == null) {
            part = new Part();
            this.parts.put(cPos, part);
            if (cPos.field_9181 < this.minX) {
                this.minX = cPos.field_9181;
            }
            if (cPos.field_9181 > this.maxX) {
                this.maxX = cPos.field_9181;
            }
            if (cPos.field_9180 < this.minZ) {
                this.minZ = cPos.field_9180;
            }
            if (cPos.field_9180 > this.maxZ) {
                this.maxZ = cPos.field_9180;
            }
        }
        if (pos.method_10264() < this.minY) {
            this.minY = pos.method_10264();
        }
        if (pos.method_10264() > this.maxY) {
            this.maxY = pos.method_10264();
        }
        part.addBlock(pos, state);
        this.lastPos = cPos;
        this.lastPart = part;
    }

    public boolean placeChunk(class_5281 world, class_1923 chunkPos) {
        Part part = this.parts.get(chunkPos);
        if (part != null) {
            class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
            part.placeChunk(chunk);
            return true;
        }
        return false;
    }

    public class_2487 toBNT() {
        class_2487 tag = new class_2487();
        tag.method_10569("minX", this.minX);
        tag.method_10569("maxX", this.maxX);
        tag.method_10569("minY", this.minY);
        tag.method_10569("maxY", this.maxY);
        tag.method_10569("minZ", this.minZ);
        tag.method_10569("maxZ", this.maxZ);
        class_2499 map = new class_2499();
        tag.method_10566("parts", (class_2520)map);
        this.parts.forEach((pos, part) -> map.add((Object)part.toNBT(pos.field_9181, pos.field_9180)));
        return tag;
    }

    public class_3341 getBounds() {
        if (this.minX == Integer.MAX_VALUE || this.maxX == Integer.MIN_VALUE || this.minZ == Integer.MAX_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return class_3341.method_14665();
        }
        return new class_3341(this.minX << 4, this.minY, this.minZ << 4, this.maxX << 4 | 0xF, this.maxY, this.maxZ << 4 | 0xF);
    }

    public static Optional<class_2338> toBlockPos(class_2487 compoundTag, String string) {
        int[] is = (int[])compoundTag.method_10561(string).get();
        return is.length == 3 ? Optional.of(new class_2338(is[0], is[1], is[2])) : Optional.empty();
    }

    public static class_2495 fromBlockPos(class_2338 blockPos) {
        return new class_2495(new int[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
    }

    private static final class Part {
        Map<class_2338, class_2680> blocks = Maps.newHashMap();

        public Part() {
        }

        public Part(class_2487 tag) {
            class_2499 map = (class_2499)tag.method_10554("blocks").get();
            class_2499 map2 = (class_2499)tag.method_10554("states").get();
            class_2680[] states = new class_2680[map2.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = class_2512.method_10681((class_7871)class_7923.field_41175.method_40276(), (class_2487)((class_2487)map2.get(i)));
            }
            map.forEach(element -> {
                class_2487 block = (class_2487)element;
                class_2338 pos = StructureWorld.toBlockPos(block, "pos").orElse(null);
                if (pos != null) {
                    int stateID = (Integer)block.method_10550("state").get();
                    class_2680 state = stateID < states.length ? states[stateID] : class_2248.method_9531((int)stateID);
                    this.blocks.put(pos, state);
                }
            });
        }

        void addBlock(class_2338 pos, class_2680 state) {
            class_2338 inner = new class_2338(pos.method_10263() & 0xF, pos.method_10264(), pos.method_10260() & 0xF);
            this.blocks.put(inner, state);
        }

        void placeChunk(class_2791 chunk) {
            this.blocks.forEach((pos, state) -> chunk.method_66480(pos, state));
        }

        class_2487 toNBT(int x, int z) {
            class_2487 tag = new class_2487();
            tag.method_10569("x", x);
            tag.method_10569("z", z);
            class_2499 map = new class_2499();
            tag.method_10566("blocks", (class_2520)map);
            class_2499 stateMap = new class_2499();
            tag.method_10566("states", (class_2520)stateMap);
            int[] id = new int[1];
            HashMap states = Maps.newHashMap();
            this.blocks.forEach((pos, state) -> {
                int stateID = states.getOrDefault(states, -1);
                if (stateID < 0) {
                    int n = id[0];
                    id[0] = n + 1;
                    stateID = n;
                    states.put(state, stateID);
                    stateMap.add((Object)class_2512.method_10686((class_2680)state));
                }
                class_2487 block = new class_2487();
                block.method_10566("pos", (class_2520)StructureWorld.fromBlockPos(pos));
                block.method_10569("state", stateID);
                map.add((Object)block);
            });
            return tag;
        }
    }
}

