/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class DragonTree
extends class_3031<class_3111> {
    private static final Function<class_2680, Boolean> REPLACE = state -> {
        if (state.method_26204() == LighterEndBlocks.DRAGON_LEAVES) {
            return true;
        }
        return MiscUtils.replaceableOrPlant(state);
    };
    private static final Function<class_2680, Boolean> IGNORE = state -> state.method_27852(LighterEndBlocks.DRAGON.wood) || state.method_27852(LighterEndBlocks.DRAGON.log);
    private static final Function<PosInfo, class_2680> POST = info -> {
        if ((info.getStateUp().method_27852(LighterEndBlocks.DRAGON.wood) || info.getStateUp().method_27852(LighterEndBlocks.DRAGON.log)) && (info.getStateDown().method_27852(LighterEndBlocks.DRAGON.wood) || info.getStateUp().method_27852(LighterEndBlocks.DRAGON.log))) {
            return LighterEndBlocks.DRAGON.log.method_9564();
        }
        return info.getState();
    };
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.3f, 0.0f), new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE1 = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE2 = MathUtils.copySpline(SIDE1);
    private static final List<Vector3f> ROOT;

    public DragonTree() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
            return false;
        }
        float size = class_3532.method_15344((class_5819)random, (float)10.0f, (float)25.0f);
        List<Vector3f> spline = MathUtils.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 6);
        MathUtils.offsetParts(spline, random, 1.0f, 0.0f, 1.0f);
        if (!MathUtils.canGenerate(spline, pos, world, REPLACE)) {
            return false;
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 18);
        Vector3f last = MathUtils.getPos(spline, 3.5f);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
        float radius = size * class_3532.method_15344((class_5819)random, (float)0.5f, (float)0.7f);
        this.makeCap(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), radius, random, noise);
        last = spline.get(0);
        this.makeRoots(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), radius, random);
        radius = class_3532.method_15344((class_5819)random, (float)1.2f, (float)2.3f);
        SDF function = MathUtils.buildSDF(spline, radius, 1.2f, bpos -> LighterEndBlocks.DRAGON.wood.method_9564());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        return true;
    }

    private void makeCap(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise) {
        int count = (int)radius;
        int offset = (int)(BRANCH.get(BRANCH.size() - 1).y() * radius);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * class_3532.method_15344((class_5819)random, (float)0.85f, (float)1.15f);
            List<Vector3f> branch = MathUtils.copySpline(BRANCH);
            MathUtils.rotateSpline(branch, angle);
            MathUtils.scale(branch, scale);
            MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos, REPLACE);
            branch = MathUtils.copySpline(SIDE1);
            MathUtils.rotateSpline(branch, angle);
            MathUtils.scale(branch, scale);
            MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos, REPLACE);
            branch = MathUtils.copySpline(SIDE2);
            MathUtils.rotateSpline(branch, angle);
            MathUtils.scale(branch, scale);
            MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos, REPLACE);
        }
        this.leavesBall(world, pos.method_10086(offset), radius * 1.15f + 2.0f, random, noise);
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * class_3532.method_15344((class_5819)random, (float)0.85f, (float)1.15f);
            List<Vector3f> branch = MathUtils.copySpline(ROOT);
            MathUtils.rotateSpline(branch, angle);
            MathUtils.scale(branch, scale);
            Vector3f last = branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10069((int)last.x(), (int)last.y(), (int)last.z())).method_26164(LighterEndTags.END_STONES)) continue;
            MathUtils.fillSpline(branch, world, LighterEndBlocks.DRAGON.wood.method_9564(), pos, REPLACE);
        }
    }

    private void leavesBall(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((class_2680)LighterEndBlocks.DRAGON_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(6)));
        SDF.UnaryOperator sub = new SDFScale().setScale(5.0f).setSource(sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource(sub);
        sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFDisplace().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 1.5f)).setSource(sphere);
        sphere = new SDFDisplace().setFunction(vec -> Float.valueOf(random.method_43057() * 3.0f - 1.5f)).setSource(sphere);
        class_2338.class_2339 mut = new class_2338.class_2339();
        sphere.addPostProcess(info -> {
            if (random.method_43048(5) == 0) {
                for (class_2350 dir : class_2350.values()) {
                    class_2680 state = info.getState(dir, 2);
                    if (!state.method_26215()) continue;
                    return info.getState();
                }
                info.setState(LighterEndBlocks.DRAGON.wood.method_9564());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.method_33097(x + info.getPos().method_10263());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.method_33099(z + info.getPos().method_10260());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.method_33098(y + info.getPos().method_10264());
                            class_2680 state = info.getState((class_2338)mut);
                            if (!(state.method_26204() instanceof class_2397) || d >= (distance = ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue())) continue;
                            info.setState((class_2338)mut, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                class_2338 p = pos.method_10069((int)(random.method_43059() * 1.0), (int)(random.method_43059() * 1.0), (int)(random.method_43059() * 1.0));
                boolean place = true;
                for (class_2350 d : class_2350.values()) {
                    class_2680 state = world.method_8320(p.method_10093(d));
                    if (state.method_27852(LighterEndBlocks.DRAGON.wood) || state.method_27852(LighterEndBlocks.DRAGON.log) || state.method_27852(LighterEndBlocks.DRAGON_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                world.method_8652(p, LighterEndBlocks.DRAGON.wood.method_9564(), 18);
            }
        }
        world.method_8652(pos, LighterEndBlocks.DRAGON.wood.method_9564(), 18);
    }

    static {
        Vector3f offset1 = new Vector3f(-0.4f, -0.6f, 0.0f);
        Vector3f offset2 = new Vector3f(0.4f, 0.6f, 0.0f);
        MathUtils.offset(SIDE1, offset1);
        MathUtils.offset(SIDE2, offset1);
        MathUtils.rotateSpline(SIDE1, 0.5f);
        MathUtils.rotateSpline(SIDE2, -0.5f);
        MathUtils.offset(SIDE1, offset2);
        MathUtils.offset(SIDE2, offset2);
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        MathUtils.offset(ROOT, new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

