/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.blocks.UmbrellaMembrane;
import io.github.openbagtwo.lighterend.blocks.UmbrellaTreeCluster;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFFlatWave;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSmoothUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class UmbrellaTree
extends class_3031<class_3111> {
    private static final Function<class_2680, Boolean> REPLACE;
    private static final List<Vector3f> SPLINE;
    private static final List<Vector3f> ROOT;

    public UmbrellaTree() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        class_3111 config = (class_3111)featureConfig.method_33656();
        if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
            return false;
        }
        class_2680 wood = LighterEndBlocks.UMBRELLA.wood.method_9564();
        class_2680 membrane = (class_2680)LighterEndBlocks.UMBRELLA_MEMBRANE.method_9564().method_11657((class_2769)UmbrellaMembrane.COLOR, (Comparable)Integer.valueOf(1));
        class_2680 center = (class_2680)LighterEndBlocks.UMBRELLA_MEMBRANE.method_9564().method_11657((class_2769)UmbrellaMembrane.COLOR, (Comparable)Integer.valueOf(0));
        class_2680 fruit = (class_2680)LighterEndBlocks.UMBRELLA_TREE_CLUSTER.method_9564().method_11657((class_2769)UmbrellaTreeCluster.NATURAL, (Comparable)Boolean.valueOf(true));
        float size = class_3532.method_15344((class_5819)random, (float)10.0f, (float)20.0f);
        int count = (int)(size * 0.15f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = class_3532.method_15344((class_5819)random, (float)0.0f, (float)((float)Math.PI * 2));
        SDF sdf = null;
        ArrayList centers = Lists.newArrayList();
        float scale = 1.0f;
        if (config != null) {
            scale = class_3532.method_15344((class_5819)random, (float)1.0f, (float)1.7f);
        }
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + class_3532.method_15344((class_5819)random, (float)0.0f, (float)var) + start;
            List<Vector3f> spline = MathUtils.copySpline(SPLINE);
            float sizeXZ = size + class_3532.method_15344((class_5819)random, (float)0.0f, (float)(size * 0.5f)) * 0.7f;
            MathUtils.scale(spline, sizeXZ, sizeXZ * class_3532.method_15344((class_5819)random, (float)1.0f, (float)2.0f), sizeXZ);
            MathUtils.rotateSpline(spline, angle);
            MathUtils.offsetParts(spline, random, 0.5f, 0.0f, 0.5f);
            if (!MathUtils.canGenerate(spline, pos, world, REPLACE)) continue;
            float rScale = (scale - 1.0f) * 0.4f + 1.0f;
            SDF branch = MathUtils.buildSDF(spline, 1.2f * rScale, 0.8f * rScale, bpos -> wood);
            Vector3f vec = spline.get(spline.size() - 1);
            float radius = size + class_3532.method_15344((class_5819)random, (float)0.0f, (float)(size * 0.5f)) * 0.4f;
            sdf = sdf == null ? branch : new SDFUnion().setSourceA(sdf).setSourceB(branch);
            SDF mem = this.makeMembrane(radius, random, membrane, center);
            float px = (float)class_3532.method_15375((float)vec.x()) + 0.5f;
            float py = (float)class_3532.method_15375((float)vec.y()) + 0.5f;
            float pz = (float)class_3532.method_15375((float)vec.z()) + 0.5f;
            mem = new SDFTranslate().setTranslate(px, py, pz).setSource(mem);
            sdf = new SDFSmoothUnion().setRadius(2.0f).setSourceA(sdf).setSourceB(mem);
            centers.add(new Center((double)pos.method_10263() + (double)(px * scale), (double)pos.method_10264() + (double)(py * scale), (double)pos.method_10260() + (double)(pz * scale), radius * scale));
        }
        if (sdf == null) {
            return false;
        }
        if (scale > 1.0f) {
            sdf = new SDFScale().setScale(scale).setSource(sdf);
        }
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (Arrays.asList(LighterEndBlocks.UMBRELLA.wood, LighterEndBlocks.UMBRELLA.log).contains(info.getStateUp().method_26204()) && Arrays.asList(LighterEndBlocks.UMBRELLA.wood, LighterEndBlocks.UMBRELLA.log).contains(info.getStateDown().method_26204())) {
                return LighterEndBlocks.UMBRELLA.log.method_9564();
            }
            if (info.getState().equals((Object)membrane)) {
                Center min = (Center)centers.get(0);
                double d = Double.MAX_VALUE;
                class_2338 bpos = info.getPos();
                for (Center c : centers) {
                    double d2 = c.distance(bpos.method_10263(), bpos.method_10260());
                    if (!(d2 < d)) continue;
                    d = d2;
                    min = c;
                }
                int color = class_3532.method_15357((double)(d / (double)min.radius * 7.0));
                color = class_3532.method_15340((int)color, (int)1, (int)7);
                return (class_2680)info.getState().method_11657((class_2769)UmbrellaMembrane.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((class_5425)world, pos);
        this.makeRoots(world, pos, (size * 0.5f + 3.0f) * scale, random, wood);
        for (Center c : centers) {
            if (world.method_8320(new class_2338((int)c.px, (int)c.py, (int)c.pz)).method_26215()) continue;
            count = class_3532.method_15375((float)(class_3532.method_15344((class_5819)random, (float)5.0f, (float)10.0f) * scale));
            float startAngle = random.method_43057() * ((float)Math.PI * 2);
            for (int i = 0; i < count; ++i) {
                float angle = (float)i / (float)count * ((float)Math.PI * 2) + startAngle;
                float dist = class_3532.method_15344((class_5819)random, (float)1.5f, (float)2.5f) * scale;
                double px = c.px + Math.sin(angle) * (double)dist;
                double pz = c.pz + Math.cos(angle) * (double)dist;
                this.makeFruits(world, px, c.py - 1.0, pz, fruit);
            }
        }
        return true;
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random, class_2680 wood) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * class_3532.method_15344((class_5819)random, (float)0.85f, (float)1.15f);
            List<Vector3f> branch = MathUtils.copySpline(ROOT);
            MathUtils.rotateSpline(branch, angle);
            MathUtils.scale(branch, scale);
            Vector3f last = branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10069((int)last.x(), (int)last.y(), (int)last.z())).method_26164(LighterEndTags.END_STONES)) continue;
            MathUtils.fillSplineForce(branch, world, wood, pos, REPLACE);
        }
    }

    private SDF makeMembrane(float radius, class_5819 random, class_2680 membrane, class_2680 center) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(membrane);
        SDF.UnaryOperator sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource(sphere);
        sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource(sphere);
        float angle = random.method_43057() * ((float)Math.PI * 2);
        int count = (int)class_3532.method_15344((class_5819)random, (float)radius, (float)(radius * 2.0f));
        if (count < 5) {
            count = 5;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.6f).setSource(sphere);
        SDF.Primitive cent = new SDFSphere().setRadius(2.5f).setBlock(center);
        sphere = new SDFUnion().setSourceA(sphere).setSourceB(cent);
        return sphere;
    }

    private void makeFruits(class_5281 world, double px, double py, double pz, class_2680 fruit) {
        class_2338.class_2339 mut = new class_2338.class_2339().method_10102(px, py, pz);
        for (int i = 0; i < 8; ++i) {
            mut.method_10098(class_2350.field_11033);
            if (!world.method_22347((class_2338)mut)) continue;
            class_2680 state = world.method_8320(mut.method_10084());
            if (!state.method_27852(LighterEndBlocks.UMBRELLA_MEMBRANE) || (Integer)state.method_11654((class_2769)UmbrellaMembrane.COLOR) >= 2) break;
            world.method_8652((class_2338)mut, fruit, 18);
            break;
        }
    }

    static {
        SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        MathUtils.offset(ROOT, new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.method_27852(LighterEndBlocks.UMBRELLA_MEMBRANE)) {
                return true;
            }
            return MiscUtils.replaceableOrPlant(state);
        };
    }

    private static class Center {
        final double px;
        final double py;
        final double pz;
        final float radius;

        Center(double x, double y, double z, float radius) {
            this.px = x;
            this.py = y;
            this.pz = z;
            this.radius = radius;
        }

        double distance(float x, float z) {
            return Math.sqrt(Math.pow(this.px - (double)x, 2.0) + Math.pow(this.pz - (double)z, 2.0));
        }
    }
}

