/*
 * Decompiled with CFR 0.152.
 */
package io.github.openbagtwo.lighterend.world.gen;

import com.mojang.datafixers.util.Pair;
import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.config.Config;
import io.github.openbagtwo.lighterend.registries.LighterEndBiomes;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.world.LighterEndPlacedFeatures;
import io.github.openbagtwo.lighterend.world.gen.noise.NoiseParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class LighterEndWorldGen {
    public static class_1966 addBiomesToNoiseSource(class_6544.class_6547<class_6880<class_1959>> defaultBiomes, class_7871<class_1959> context) {
        ArrayList<Pair> biomeParams = new ArrayList<Pair>();
        biomeParams.addAll(List.of(Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.3f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.3f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)-0.5f), (float)0.0f), (Object)context.method_46747(LighterEndBiomes.BLOSSOM_FOREST)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.5f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.5f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.3f), (Object)context.method_46747(LighterEndBiomes.UMBRELLA_JUNGLE)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-0.5f, (float)-0.2f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.4f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.48f), (Object)context.method_46747(LighterEndBiomes.SHADOW_FOREST)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.5f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.8f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.0f), (Object)context.method_46747(LighterEndBiomes.MEGALAKE)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)-0.5f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-0.2f, (float)0.2f), (float)0.01f), (Object)context.method_46747(LighterEndBiomes.UMBRA_VALLEY)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-0.5f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.25f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.4f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.42f), (Object)context.method_46747(LighterEndBiomes.SULPHUR_SPRINGS)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-0.5f, (float)0.2f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.5f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.5f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.0f, (float)0.5f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.4f), (Object)context.method_46747(LighterEndBiomes.FOGGY_MUSHROOMLANDS)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.3f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)-0.15f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.4f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (float)0.1f), (Object)context.method_46747(LighterEndBiomes.STARFIELD)), Pair.of((Object)class_6544.method_38118((class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.5f, (float)1.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-1.4f, (float)0.0f), (class_6544.class_6546)class_6544.class_6546.method_38121((float)-0.5f, (float)0.5f), (float)0.3f), (Object)context.method_46747(LighterEndBiomes.GLOWING_GRASSLAND))));
        biomeParams.addAll(defaultBiomes.method_38128());
        LighterEnd.LOGGER.info("Injected Lighter End's biomes into multinoise worldgen");
        return class_4766.method_49501((class_6544.class_6547)new class_6544.class_6547(biomeParams));
    }

    public static void modifyWorldGen(Config config) {
        if (!config.generateBiomes()) {
            return;
        }
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.GLOWING_GRASSLAND, (double)2.0);
        TheEndBiomes.addMidlandsBiome(LighterEndBiomes.GLOWING_GRASSLAND, LighterEndBiomes.GLOWING_GRASSLAND, (double)2.0);
        TheEndBiomes.addSmallIslandsBiome(LighterEndBiomes.GLOWING_GRASSLAND, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.BLOSSOM_FOREST, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.SHADOW_FOREST, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.FOGGY_MUSHROOMLANDS, (double)0.5);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.UMBRELLA_JUNGLE, (double)1.0);
        TheEndBiomes.addMidlandsBiome(LighterEndBiomes.UMBRELLA_JUNGLE, LighterEndBiomes.UMBRELLA_JUNGLE, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.UMBRA_VALLEY, (double)1.0);
        TheEndBiomes.addMidlandsBiome(LighterEndBiomes.UMBRA_VALLEY, LighterEndBiomes.UMBRA_VALLEY, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.SULPHUR_SPRINGS, (double)1.0);
        TheEndBiomes.addMidlandsBiome(LighterEndBiomes.SULPHUR_SPRINGS, LighterEndBiomes.SULPHUR_SPRINGS, (double)1.0);
        TheEndBiomes.addHighlandsBiome(LighterEndBiomes.MEGALAKE, (double)1.0);
        TheEndBiomes.addSmallIslandsBiome(LighterEndBiomes.STARFIELD, (double)0.1);
        for (class_5321<class_1959> parentBiome : List.of(class_1972.field_9442, LighterEndBiomes.GLOWING_GRASSLAND, LighterEndBiomes.FOGGY_MUSHROOMLANDS, LighterEndBiomes.UMBRA_VALLEY, LighterEndBiomes.MEGALAKE, LighterEndBiomes.SULPHUR_SPRINGS)) {
            TheEndBiomes.addBarrensBiome(parentBiome, LighterEndBiomes.STARFIELD, (double)0.18);
            TheEndBiomes.addBarrensBiome(parentBiome, (class_5321)class_1972.field_9465, (double)1.0);
        }
        LighterEnd.LOGGER.info("Injected Lighter End's biomes into Fabric worldgen");
    }

    public static void addIceStars(Config config) {
        if (!config.generateBiomes()) {
            return;
        }
        ArrayList<class_5321> barrensBiomes = new ArrayList<class_5321>();
        barrensBiomes.add(class_1972.field_9465);
        try {
            barrensBiomes.add(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"nullscape", (String)"void_barrens")));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (class_5321<class_6796> star : LighterEndPlacedFeatures.BARRENS_ICE_STARS) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(barrensBiomes), (class_2893.class_2895)class_2893.class_2895.field_13173, star);
        }
    }

    public static void addJadestoneBlobs(Config config) {
        if (!config.generateBiomes()) {
            return;
        }
        ArrayList<class_5321> biomes = new ArrayList<class_5321>();
        biomes.add(class_1972.field_9442);
        try {
            biomes.add(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"nullscape", (String)"crystal_peaks")));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (class_5321<class_6796> blob : LighterEndPlacedFeatures.JADESTONE_BLOBS_BM) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(biomes), (class_2893.class_2895)class_2893.class_2895.field_13176, blob);
        }
    }

    public static void addOres(Config config) {
        if (!config.generateOres()) {
            return;
        }
        ArrayList<class_5321> endStoneBiomes = new ArrayList<class_5321>();
        endStoneBiomes.addAll(List.of(LighterEndBiomes.GLOWING_GRASSLAND, LighterEndBiomes.BLOSSOM_FOREST, LighterEndBiomes.UMBRELLA_JUNGLE, LighterEndBiomes.MEGALAKE, LighterEndBiomes.FOGGY_MUSHROOMLANDS, LighterEndBiomes.SULPHUR_SPRINGS, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457));
        ArrayList<class_5321<class_1959>> umbralithBiomes = new ArrayList<class_5321<class_1959>>();
        umbralithBiomes.add(LighterEndBiomes.UMBRA_VALLEY);
        try {
            endStoneBiomes.add(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"nullscape", (String)"crystal_peaks")));
            endStoneBiomes.add(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"nullscape", (String)"shadowlands")));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(endStoneBiomes), (class_2893.class_2895)class_2893.class_2895.field_13176, LighterEndPlacedFeatures.END_STONE_REDSTONE_ORE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(endStoneBiomes), (class_2893.class_2895)class_2893.class_2895.field_13176, LighterEndPlacedFeatures.END_STONE_QUARTZ_ORE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(umbralithBiomes), (class_2893.class_2895)class_2893.class_2895.field_13176, LighterEndPlacedFeatures.UMBRALITH_REDSTONE_ORE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(umbralithBiomes), (class_2893.class_2895)class_2893.class_2895.field_13176, LighterEndPlacedFeatures.UMBRALITH_QUARTZ_ORE);
    }

    public static class_6686.class_6708 updateSurfaceRules() {
        return class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.field_35222, (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{LighterEndBiomes.BLOSSOM_FOREST, LighterEndBiomes.UMBRELLA_JUNGLE, LighterEndBiomes.GLOWING_GRASSLAND, LighterEndBiomes.FOGGY_MUSHROOMLANDS, LighterEndBiomes.SHADOW_FOREST}), (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39053(NoiseParameters.END_MOSS_SURFACE, (double)-0.5, (double)0.5), (class_6686.class_6708)class_6686.method_39047((class_2680)LighterEndBlocks.END_MOSS.method_9564()))}))})), class_6686.method_39049((class_6686.class_6693)class_6686.field_36342, (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{LighterEndBiomes.UMBRA_VALLEY}), (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39053(NoiseParameters.VIOLECITE_SURFACE, (double)-0.05, (double)0.05), (class_6686.class_6708)class_6686.method_39047((class_2680)LighterEndBlocks.VIOLECITE.baseBlock.method_9564())), class_6686.method_39047((class_2680)LighterEndBlocks.UMBRALITH.baseBlock.method_9564())}))})), class_6686.method_39049((class_6686.class_6693)class_6686.field_36341, (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{LighterEndBiomes.SULPHUR_SPRINGS}), (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)class_6686.method_39053(NoiseParameters.SULPHUR_SURFACE, (double)-0.3, (double)0.3), (class_6686.class_6708)class_6686.method_39047((class_2680)LighterEndBlocks.BORNITE.baseBlock.method_9564())), class_6686.method_39047((class_2680)class_2246.field_10471.method_9564())}))}))});
    }
}

