package io.github.openbagtwo.lighterend.blocks;

import com.google.common.collect.Maps;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2402;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3621;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class EndLotus extends class_2248 {

  private static final class_265 SHAPE_OUTLINE = class_2248.method_9541(2, 0, 2, 14, 14, 14);
  private static final class_265 SHAPE_COLLISION = class_2248.method_9541(0, 0, 0, 16, 2, 16);

  public EndLotus(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16030)
            .method_51368(class_2766.field_12651)
            .method_9626(class_2498.field_11547)
            .method_9632(0.2F)
            .method_50013()
            .method_50012(class_3619.field_15971)
            .method_22488()
            .method_9618()
            .method_9631(bs -> 15)
    );
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      tickView.method_64310(pos, this, 1);
    }
    return state;
  }

  @Override
  protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    if (!state.method_26184(world, pos)) {
      world.method_22352(pos, true);
    }
  }

  @Override
  protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    return state.method_27852(LighterEndBlocks.END_LOTUS_STEM);
  }

  @Override
  protected class_265 method_9530(
      class_2680 state, class_1922 world, class_2338 pos, class_3726 context
  ) {
    return SHAPE_OUTLINE;
  }

  @Override
  public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos,
      class_3726 ePos) {
    return SHAPE_COLLISION;
  }

  @Override
  protected class_1799 method_9574(
      class_4538 world,
      class_2338 pos,
      class_2680 state,
      boolean includeData
  ) {
    return new class_1799(LighterEndBlocks.END_LOTUS_SEED);
  }

  public static class Stem extends class_2248 implements class_3737, class_2402 {

    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 LEAF = class_2746.method_11825("leaf");
    public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);
    private static final Map<class_2351, class_265> SHAPES = Maps.newEnumMap(class_2351.class);

    public Stem(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_15995)
              .method_51368(class_2766.field_12651)
              .method_9629(2.0F, 3.0F)
              .method_9626(class_2498.field_40314)
              .method_50012(class_3619.field_15971)
              .method_22488()
              .method_51369()
              .method_50013()
      );
      this.method_9590(method_9564()
          .method_11657(WATERLOGGED, false)
          .method_11657(SHAPE, Shape.MIDDLE)
          .method_11657(LEAF, false)
          .method_11657(FACING, class_2350.field_11036));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
      builder.method_11667(FACING, WATERLOGGED, SHAPE, LEAF);
    }

    @Override
    protected class_265 method_9530(
        class_2680 state, class_1922 world, class_2338 pos, class_3726 context
    ) {
      return state.method_11654(LEAF) ? SHAPES.get(class_2351.field_11052) : SHAPES.get(state.method_11654(FACING).method_10166());
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
      return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
      class_1936 worldAccess = ctx.method_8045();
      class_2338 blockPos = ctx.method_8037();
      return this.method_9564()
          .method_11657(WATERLOGGED, worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910)
          .method_11657(FACING, ctx.method_8038());
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
      return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
      return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighborPos,
        class_2680 neighborState,
        class_5819 random
    ) {
      if (state.method_11654(WATERLOGGED)) {
        tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
      }
      if (!method_9558(state, world, pos)) {
        tickView.method_64310(pos, this, 1);
      }
      return state;
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
      if (!state.method_26184(world, pos)) {
        world.method_22352(pos, true);
      }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
      class_2680 down = world.method_8320(pos.method_10074());
      return down.method_26164(LighterEndTags.AQUATIC_END_SOIL) || down.method_26204() == this;
    }

    static {
      SHAPES.put(class_2351.field_11048, class_2248.method_9541(0, 6, 6, 16, 10, 10));
      SHAPES.put(class_2351.field_11052, class_2248.method_9541(6, 0, 6, 10, 16, 10));
      SHAPES.put(class_2351.field_11051, class_2248.method_9541(6, 6, 0, 10, 10, 16));
    }
  }

  public static class Leaf extends class_2248 {

    public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;
    public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);
    private static final class_265 VSHAPE = class_2248.method_9541(0, 0, 0, 16, 1, 16);

    public Leaf(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_16030)
              .method_9618()
              .method_9626(class_2498.field_25183)
              .method_22488()
              .method_50012(class_3619.field_15971)
      );
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
      class_2680 down = world.method_8320(pos.method_10074());
      return !down.method_26227().method_15769() && down.method_26227()
          .method_15772() instanceof class_3621;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
      builder.method_11667(SHAPE, HORIZONTAL_FACING);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos,
        class_3726 ePos) {
      return VSHAPE;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
      return state.method_11657(HORIZONTAL_FACING, rotation.method_10503(state.method_11654(HORIZONTAL_FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
      return state.method_26186(mirror.method_10345(state.method_11654(HORIZONTAL_FACING)));
    }


    @Override
    protected class_1799 method_9574(
        class_4538 world,
        class_2338 pos,
        class_2680 state,
        boolean includeData
    ) {
      return new class_1799(LighterEndBlocks.END_LOTUS_SEED);
    }
  }

  public static class Seed extends Sapling implements class_2402 {

    public Seed(class_2251 settings) {
      super(EndLotusFeature::new, settings, 7);
    }

    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
      return floor.method_26206(world, pos, class_2350.field_11036) && floor.method_26164(
          LighterEndTags.AQUATIC_END_SOIL);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
      class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
      return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15761() == 8
          ? super.method_9605(
          ctx) : null;
    }

    @Override
    protected class_3610 method_9545(class_2680 state) {
      return class_3612.field_15910.method_15729(false);
    }

    @Override
    public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos,
        class_2680 state, class_3611 fluid) {
      return false;
    }

    @Override
    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state,
        class_3610 fluidState) {
      return false;
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
      return EndLotus.canGrow(world, pos);
    }

  }

  public static class EndLotusFeature extends class_3031<class_3111> {

    public EndLotusFeature() {
      super(class_3111.field_24893);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> featureConfig) {
      final class_2338 pos = featureConfig.method_33655();
      final class_5281 world = featureConfig.method_33652();
      final class_5819 random = featureConfig.method_33654();

      if (EndLotus.canGrow(world, pos)) {
        class_2680 startLeaf = LighterEndBlocks.END_LOTUS_STEM.method_9564()
            .method_11657(Stem.LEAF, true);
        class_2680 roots = LighterEndBlocks.END_LOTUS_STEM.method_9564()
            .method_11657(Stem.SHAPE, Shape.BOTTOM)
            .method_11657(Stem.WATERLOGGED, true);
        class_2680 stem = LighterEndBlocks.END_LOTUS_STEM.method_9564();
        class_2680 flower = LighterEndBlocks.END_LOTUS_FLOWER.method_9564();

        world.method_8652(pos, roots, Flags.SILENT);
        class_2339 bpos = new class_2339().method_10101(pos);
        bpos.method_33098(bpos.method_10264() + 1);
        while (world.method_8316(bpos).method_15771()) {
          world.method_8652(bpos, stem.method_11657(Stem.WATERLOGGED, true), Flags.SILENT);
          bpos.method_33098(bpos.method_10264() + 1);
        }

        int height =
            random.method_43056() ? 0 : random.method_43056() ? 1 : random.method_43056() ? 1 : -1;
        Shape shape = (height == 0) ? Shape.TOP : Shape.MIDDLE;
        class_2350 dir = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 leafCenter = bpos.method_10062().method_10093(dir);
        if (hasLeaf(world, leafCenter)) {
          generateLeaf(world, leafCenter);
          world.method_8652(
              bpos,
              startLeaf.method_11657(Stem.SHAPE, shape).method_11657(Stem.FACING, dir),
              Flags.SILENT
          );
        } else {
          world.method_8652(bpos, stem.method_11657(Stem.SHAPE, shape), Flags.SILENT);
        }

        bpos.method_33098(bpos.method_10264() + 1);
        for (int i = 1; i <= height; i++) {
          if (!world.method_22347(bpos)) {
            bpos.method_33098(bpos.method_10264() - 1);
            world.method_8652(bpos, flower, Flags.SILENT);
            bpos.method_33098(bpos.method_10264() - 1);
            stem = world.method_8320(bpos);
            world.method_8652(bpos, stem.method_11657(Stem.SHAPE, Shape.TOP), Flags.SILENT);
            return true;
          }
          world.method_8652(bpos, stem, Flags.SILENT);
          bpos.method_33098(bpos.method_10264() + 1);
        }

        if (!world.method_22347(bpos) || height < 0) {
          bpos.method_33098(bpos.method_10264() - 1);
        }

        world.method_8652(bpos, flower, Flags.SILENT);
        bpos.method_33098(bpos.method_10264() - 1);
        stem = world.method_8320(bpos);
        if (!stem.method_27852(LighterEndBlocks.END_LOTUS_STEM)) {
          stem = LighterEndBlocks.END_LOTUS_STEM.method_9564();
          if (!world.method_8320(bpos.method_10095()).method_26227().method_15769()) {
            stem = stem.method_11657(Stem.WATERLOGGED, true);
          }
        }

        if (world.method_8320(bpos.method_10093(dir)).method_27852(LighterEndBlocks.END_LOTUS_LEAF)) {
          stem = stem.method_11657(Stem.LEAF, true).method_11657(Stem.FACING, dir);
        }

        world.method_8652(bpos, stem.method_11657(Stem.SHAPE, Shape.TOP), Flags.SILENT);
        return true;
      }
      return false;
    }

    private void generateLeaf(class_5281 world, class_2338 pos) {
      class_2339 p = new class_2339();
      class_2680 leaf = LighterEndBlocks.END_LOTUS_LEAF.method_9564();
      world.method_8652(pos, leaf.method_11657(Leaf.SHAPE, Shape.BOTTOM), Flags.SILENT);
      for (class_2350 move : class_2350.class_2353.field_11062) {
        world.method_8652(
            p.method_10101(pos).method_10098(move),
            leaf.method_11657(Leaf.HORIZONTAL_FACING, move)
                .method_11657(Leaf.SHAPE, Shape.MIDDLE),
            Flags.SILENT
        );
      }
      for (int i = 0; i < 4; i++) {
        class_2350 d1 = class_2350.class_2353.field_11062.method_29716().toList().get(i);
        class_2350 d2 = class_2350.class_2353.field_11062.method_29716().toList().get((i + 1) & 3);
        world.method_8652(
            p.method_10101(pos).method_10098(d1).method_10098(d2),
            leaf.method_11657(Leaf.HORIZONTAL_FACING, d1)
                .method_11657(Leaf.SHAPE, Shape.TOP),
            Flags.SILENT
        );
      }
    }

    private boolean hasLeaf(class_5281 world, class_2338 pos) {
      class_2339 p = new class_2339();
      p.method_33098(pos.method_10264());
      int count = 0;
      for (int x = -1; x < 2; x++) {
        p.method_33097(pos.method_10263() + x);
        for (int z = -1; z < 2; z++) {
          p.method_33099(pos.method_10260() + z);
          if (world.method_22347(p) && !world.method_8316(p.method_10074()).method_15769()) {
            count++;
          }
        }
      }
      return count == 9;
    }
  }


  public enum Shape implements class_3542 {
    TOP("top"),
    MIDDLE("middle"),
    BOTTOM("bottom");

    private final String name;

    Shape(String name) {
      this.name = name;
    }

    @Override
    public String method_15434() {
      return name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

  private static boolean canGrow(class_1936 world, class_2338 pos) {
    if (!world.method_8320(pos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
      return false;
    }
    class_2339 bpos = new class_2339();
    bpos.method_10101(pos);
    while (world.method_8320(bpos).method_26227().method_15772().equals(class_3612.field_15910.method_15751())) {
      bpos.method_33098(bpos.method_10264() + 1);
    }
    return world.method_22347(bpos) && world.method_22347(bpos.method_10084());
  }

}
