package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndBiomes;
import io.github.openbagtwo.lighterend.world.LighterEndConfiguredFeatures;
import net.minecraft.class_10318;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3558;
import net.minecraft.class_3620;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class EndMoss extends class_10318 {
  /* One of the biggest differences between LighterEnd and BetterEnd in terms of design is that
     there will only be *one* EndTerrainBlock (onto which all LighterEnd plants can be planted).
     Different patternings / colorations / bonemealing outputs, if implemented, will be determined
     by the biome in which the blocks are placed.
   */

  private final class_5321<class_2975<?, ?>> feature;

  public EndMoss(class_2251 settings) {
    super(
        LighterEndConfiguredFeatures.END_MOSS_PATCH_BONEMEAL,
        settings
            .method_31710(class_3620.field_16026)
            .method_51368(class_2766.field_12653)
            .method_29292()
            .method_9629(1.5F, 4.5F)
            .method_9626(class_2498.field_22153)
            .method_50013()
            .method_9640()
    );
    this.feature = LighterEndConfiguredFeatures.END_MOSS_PATCH_BONEMEAL;
  }

  @Override
  protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    if (!stayAlive(state, world, pos)) {
      world.method_8501(pos, class_2246.field_10471.method_9564());
    }
  }

  private static boolean stayAlive(class_2680 state, class_4538 world, class_2338 pos) {
    class_2338 blockPos = pos.method_10084();
    class_2680 blockState = world.method_8320(blockPos);

    int i = class_3558.method_20049(
        state,
        blockState,
        class_2350.field_11036,
        blockState.method_26193()
    );
    return i < 15;
  }

  protected boolean canGrow(class_4538 world, class_2338 pos) {
    if (world.method_23753(pos).method_40220(class_6908.field_37394)) {
      return true;
    }
    if (LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd()) {
      return true;
    }
    return false;
  }

  @Override
  public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
    return canGrow(world, pos);
  }

  @Override
  public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
    return world.method_8320(pos.method_10084()).method_26215() && this.canGrow(world, pos);
  }

  @Override
  public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
    if (!canGrow(world, pos)) {
      return;
    }

    class_5321<class_2975<?, ?>> patch;
    if (world.method_23753(pos).method_40225(LighterEndBiomes.SHADOW_FOREST)) {
      patch = LighterEndConfiguredFeatures.SHADOW_MOSS_PATCH_BONEMEAL;
    } else {
      patch = LighterEndConfiguredFeatures.END_MOSS_PATCH_BONEMEAL;
    }

    world.method_30349()
        .method_46759(class_7924.field_41239)
        .flatMap(registry -> registry.method_46746(patch))
        .ifPresent(entry -> entry.comp_349().method_12862(
                world,
                world.method_14178().method_12129(),
                random,
                pos.method_10084()
            )
        );


  }
}
