package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2473;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2766;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6908;
import net.minecraft.class_8813;

public class Lumecorn extends class_2248 {

  public static final class_2754<LumecornShape> SHAPE = class_2754.method_11850(
      "shape",
      LumecornShape.class
  );
  private static final class_265 SHAPE_BOTTOM = class_2248.method_9541(
      6, 0, 6, 10, 16, 10
  );
  private static final class_265 SHAPE_TOP = class_2248.method_9541(
      6, 0, 6, 10, 8, 10
  );

  public Lumecorn(class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_25708)
            .method_51368(class_2766.field_12651)
            .method_9626(class_2498.field_11547)
            .method_9632(0.2F)
            .method_50013()
            .method_9631(bs -> bs.method_11654(SHAPE).getLight())
    );
  }

  @Override
  protected void method_9515(class_2690<class_2248, class_2680> builder) {
    builder.method_11667(SHAPE);
  }

  @Override
  protected class_265 method_9530(
      class_2680 state, class_1922 world, class_2338 pos, class_3726 context
  ) {
    return state.method_11654(SHAPE) == LumecornShape.LIGHT_TOP ? SHAPE_TOP : SHAPE_BOTTOM;
  }

  @Override
  protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
    LumecornShape shape = state.method_11654(SHAPE);
    if (shape == LumecornShape.LIGHT_TOP) {
      return (
          world.method_8320(pos.method_10074()).method_27852(this)
              || world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.LUMECORN_STEM)
      );
    } else {
      return (
          (
              world.method_8320(pos.method_10074()).method_27852(this)
                  || world.method_8320(pos.method_10074()).method_27852(LighterEndBlocks.LUMECORN_STEM)
          ) && world.method_8320(pos.method_10084()).method_27852(this)
      );
    }
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (!method_9558(state, world, pos)) {
      return class_2246.field_10124.method_9564();
    } else {
      return state;
    }
  }

  @Override
  protected class_1799 method_9574(
      class_4538 world,
      class_2338 pos,
      class_2680 state,
      boolean includeData
  ) {
    return new class_1799(LighterEndItems.LUMECORN_EAR);
  }

  public static class LumecornStem extends class_2248 {

    public LumecornStem(class_2251 settings) {
      super(
          settings
              .method_31710(class_3620.field_25706)
              .method_51368(class_2766.field_12651)
              .method_9626(class_2498.field_11547)
              .method_9632(0.5F)
              .method_50013()
              .method_9631(bs -> 0)
      );
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
      builder.method_11667(SHAPE);
    }

    @Override
    protected class_265 method_9530(
        class_2680 state, class_1922 world, class_2338 pos, class_3726 context
    ) {
      return SHAPE_BOTTOM;
    }

    @Override
    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
      LumecornShape shape = state.method_11654(SHAPE);
      if (shape == LumecornShape.BOTTOM_BIG || shape == LumecornShape.BOTTOM_SMALL) {
        return world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL);
      } else {
        return (
            world.method_8320(pos.method_10074()).method_27852(this) && (
                world.method_8320(pos.method_10084()).method_27852(this)
                    || world.method_8320(pos.method_10084()).method_27852(LighterEndBlocks.LUMECORN)
            )
        );
      }
    }

    @Override
    protected class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighborPos,
        class_2680 neighborState,
        class_5819 random
    ) {
      if (!method_9558(state, world, pos)) {
        return class_2246.field_10124.method_9564();
      } else {
        return state;
      }
    }

    @Override
    protected class_1799 method_9574(
        class_4538 world,
        class_2338 pos,
        class_2680 state,
        boolean includeData
    ) {
      return new class_1799(LighterEndBlocks.LUMECORN_SEED);
    }
  }

  public static class LumecornSeed extends class_2473 {

    public static final class_2758 AGE = class_2758.method_11867("age", 0, 3);

    public LumecornSeed(class_2251 settings) {
      super(
          LUMECORN_GENERATOR,
          settings
              .method_31710(class_3620.field_25705)
              .method_9634()
              .method_9618()
              .method_9626(class_2498.field_17580)
              .method_50012(class_3619.field_15971)
              .method_50013()
              .method_9640()
      );
      this.method_9590(this.field_10647.method_11664().method_11657(AGE, 0));
    }

    @Override
    public void method_10507(class_3218 world, class_2338 pos, class_2680 state, class_5819 random) {
      if (!isAllowedToGrow(world, pos)) {
        return;
      }
      if (state.method_11654(AGE) < 3) {
        world.method_8652(pos, state.method_28493(AGE), class_2248.field_31029);
      } else {
        if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
          return;
        }
        class_5821<class_3111> context = new class_5821<>(null, world,
            world.method_14178().method_12129(), random, pos, new class_3111());
        new LumecornFeature().method_13151(context);
      }
    }

    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
      return floor.method_26164(LighterEndTags.END_SOIL);
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
      if (random.method_43048(3) == 0) {
        this.method_10507(world, pos, state, random);
      }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
      super.method_9515(builder);
      builder.method_11667(AGE);
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
      return isAllowedToGrow(world, pos);
    }

    private static boolean isAllowedToGrow(class_4538 world, class_2338 pos) {
      return !LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd()
          || world.method_23753(pos).method_40220(class_6908.field_37394);
    }
  }

  public enum LumecornShape implements class_3542 {
    LIGHT_TOP("light_top", 15),
    LIGHT_TOP_MIDDLE("light_top_middle", 15),
    LIGHT_MIDDLE("light_middle", 15),
    LIGHT_BOTTOM("light_bottom", 15),
    MIDDLE("middle", 0),
    BOTTOM_BIG("bottom_big", 0),
    BOTTOM_SMALL("bottom_small", 0);

    private final String name;
    private final int light;

    LumecornShape(String name, int light) {
      this.name = name;
      this.light = light;
    }

    @Override
    public String method_15434() {
      return name;
    }

    @Override
    public String toString() {
      return name;
    }

    public int getLight() {
      return light;
    }
  }

  public static class LumecornFeature extends class_3031<class_3111> {

    public LumecornFeature() {
      super(class_3111.field_24893);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> featureConfig) {
      final class_5819 random = featureConfig.method_33654();
      final class_2338 pos = featureConfig.method_33655();
      final class_5281 world = featureConfig.method_33652();

      int height = random.method_39332(4, 7);
      class_2338.class_2339 mut = new class_2338.class_2339().method_10101(pos);
      for (int i = 1; i < height; i++) {
        mut.method_10098(class_2350.field_11036);
        if (!world.method_22347(mut)) {
          return false;
        }
      }
      mut.method_10101(pos);
      class_2680 topMiddle = LighterEndBlocks.LUMECORN.method_9564()
          .method_11657(Lumecorn.SHAPE, LumecornShape.LIGHT_TOP_MIDDLE);
      class_2680 middle = LighterEndBlocks.LUMECORN.method_9564()
          .method_11657(Lumecorn.SHAPE, LumecornShape.LIGHT_MIDDLE);
      class_2680 bottom = LighterEndBlocks.LUMECORN.method_9564()
          .method_11657(Lumecorn.SHAPE, LumecornShape.LIGHT_BOTTOM);
      class_2680 top = LighterEndBlocks.LUMECORN.method_9564().method_11657(
          Lumecorn.SHAPE, LumecornShape.LIGHT_TOP
      );
      if (height == 4) {
        world.method_8652(
            mut,
            LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(
                Lumecorn.SHAPE, LumecornShape.BOTTOM_SMALL
            ),
            Flags.SILENT
        );
        world.method_8652(mut.method_10098(class_2350.field_11036), bottom, 18);
        world.method_8652(mut.method_10098(class_2350.field_11036), topMiddle, 18);
        world.method_8652(mut.method_10098(class_2350.field_11036), top, 18);
        return true;
      }
      if (random.method_43056()) {
        world.method_8652(
            mut,
            LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(
                Lumecorn.SHAPE, LumecornShape.BOTTOM_SMALL
            ),
            18
        );
      } else {
        world.method_8652(
            mut,
            LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(
                Lumecorn.SHAPE, LumecornShape.BOTTOM_BIG
            ),
            18
        );
        world.method_8652(
            mut.method_10098(class_2350.field_11036),
            LighterEndBlocks.LUMECORN_STEM.method_9564().method_11657(
                Lumecorn.SHAPE, LumecornShape.MIDDLE
            ),
            18
        );
        height--;
      }
      world.method_8652(mut.method_10098(class_2350.field_11036), bottom, 18);

      for (int i = 4; i < height; i++) {
        world.method_8652(mut.method_10098(class_2350.field_11036), middle, 18);
      }
      world.method_8652(mut.method_10098(class_2350.field_11036), topMiddle, 18);
      world.method_8652(mut.method_10098(class_2350.field_11036), top, 18);
      return true;
    }
  }

  public static final class_8813 LUMECORN_GENERATOR = new class_8813(
      LighterEnd.MOD_ID + ":lumecorn",
      Optional.empty(),
      Optional.empty(),  // we're completely overriding lumecorn generation
      Optional.empty()
  );
}
