package io.github.openbagtwo.lighterend.blocks;

import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.blocks.entities.PedestalDisplay;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class Pedestal extends class_2237 {

  private static final class_265 SHAPE;

  public static final MapCodec<Pedestal> CODEC = Pedestal.method_54094(Pedestal::new);

  public Pedestal(class_2251 settings) {
    super(settings.method_50012(class_3619.field_15972));
  }

  @Override
  protected class_265 method_9530(
      class_2680 state,
      class_1922 world,
      class_2338 pos,
      class_3726 context
  ) {
    return SHAPE;
  }

  @Override
  protected MapCodec<? extends class_2237> method_53969() {
    return field_46280;
  }

  @Override
  public class_2586 method_10123(class_2338 pos, class_2680 state) {
    return new PedestalDisplay(pos, state);
  }

  @Override
  protected class_1269 method_55765(
      class_1799 stack,
      class_2680 state,
      class_1937 world,
      class_2338 pos,
      class_1657 player,
      class_1268 hand,
      class_3965 hit
  ) {
    if (world.method_8321(pos) instanceof PedestalDisplay display && !world.method_8608()) {

      boolean makeSound = false;
      class_1799 toInsert = class_1799.field_8037;

      if (!stack.method_7960()) {
        toInsert = stack.method_46651(1);
        stack.method_7934(1);
        makeSound = true;
      }
      if (!display.method_5442()) {
        class_1799 stackOnPedestal = display.method_5438(0);
        if (!player.method_31548().method_7394(stackOnPedestal)) {
          player.method_7328(stackOnPedestal, false);
        }
        makeSound = true;
        display.method_5448();
      }
      if (makeSound) {
        display.method_5447(0, toInsert);
        display.method_5431();
        player.method_31548().method_5431();
        world.method_8396(player, pos, class_3417.field_15197, class_3419.field_15245, 1f, 2f);
        world.method_8413(pos, state, state, class_2248.field_31036);
      }
    }

    return class_1269.field_5812;
  }

  static {
    class_265 basinUp = class_2248.method_9541(2, 3, 2, 14, 4, 14);
    class_265 basinDown = class_2248.method_9541(0, 0, 0, 16, 3, 16);
    class_265 pedestalDefault = class_2248.method_9541(1, 12, 1, 15, 14, 15);
    class_265 pillarDefault = class_2248.method_9541(3, 0, 3, 13, 12, 13);
    class_265 basin = class_259.method_1084(basinDown, basinUp);
    SHAPE = class_259.method_17786(basin, pillarDefault, pedestalDefault);
  }

}
