package io.github.openbagtwo.lighterend.blocks;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2473;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6908;
import net.minecraft.class_8813;

public class Sapling extends class_2473 {

  public final Supplier<class_3031<class_3111>> treeConstructor;
  public final int growChance;

  public Sapling(
      Supplier<class_3031<class_3111>> treeConstructor,
      class_2251 settings
  ) {
    this(treeConstructor, settings, 15);
  }

  public Sapling(
      Supplier<class_3031<class_3111>> treeConstructor,
      class_2251 settings,
      int growChance
  ) {
    super(SAPLING_GENERATOR,
        settings
            .method_9634()
            .method_9618()
            .method_9626(class_2498.field_17580)
            .method_50012(class_3619.field_15971)
            .method_50013()
            .method_9640()
    );
    this.treeConstructor = treeConstructor;
    this.growChance = growChance;
  }

  @Override
  public void method_10507(class_3218 world, class_2338 pos, class_2680 state, class_5819 random) {
    if (!isAllowedToGrow(world, pos)) {
      return;
    }
    if (state.method_11654(field_11476) == 0) {
      world.method_8652(pos, state.method_28493(field_11476),
          class_2248.field_31035);
    } else {
      class_5821<class_3111> context = new class_5821<>(null, world,
          world.method_14178().method_12129(), random, pos, new class_3111());
      treeConstructor.get().method_13151(context);
    }
  }

  @Override
  protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
    return floor.method_26164(LighterEndTags.END_SOIL);
  }

  @Override
  protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    if (random.method_43048(this.growChance) == 0) {
      this.method_10507(world, pos, state, random);
    }
  }

  @Override
  public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
    return isAllowedToGrow(world, pos);
  }

  protected static boolean isAllowedToGrow(class_4538 world, class_2338 pos) {
    return !LighterEnd.CONFIG.endPlantsOnlyGrowInTheEnd()
        || world.method_23753(pos).method_40220(class_6908.field_37394);
  }

  private static final class_8813 SAPLING_GENERATOR = new class_8813(
      LighterEnd.MOD_ID + ":sapling",
      Optional.empty(),
      Optional.empty(),
      Optional.empty()
  );
}
