package io.github.openbagtwo.lighterend.blocks;

import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.blocks.entities.SilkMothNestEntity;
import io.github.openbagtwo.lighterend.registries.LighterEndBlockEntities;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndData;
import io.github.openbagtwo.lighterend.registries.LighterEndData.SilkLevelComponent;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndSounds;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.GlobalState;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1701;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2353;
import net.minecraft.class_2358;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2766;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_8567;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class SilkMothNest extends class_2237 {

  public static final MapCodec<SilkMothNest> CODEC = method_54094(SilkMothNest::new);
  public static final class_2754<class_2350> FACING = class_2383.field_11177;
  public static final int MAX_FULLNESS = 3;
  public static final class_2758 FULLNESS = class_2758.method_11867("fullness", 0, MAX_FULLNESS);

  public static final class_265 OUTLINE_SHAPE = class_259.method_1084(
      class_2248.method_9541(0, 0, 0, 16, 13, 16),
      class_2248.method_9541(3, 12, 3, 13, 16, 13)
  );


  @Override
  public MapCodec<SilkMothNest> method_53969() {
    return field_46280;
  }

  public SilkMothNest(class_4970.class_2251 settings) {
    super(
        settings
            .method_31710(class_3620.field_16013)
            .method_51368(class_2766.field_12651)
            .method_9632(0.3F)
            .method_9626(class_2498.field_11547)
            .method_22488()
            .method_50013()
    );
    this.method_9590(
        this.field_10647.method_11664().method_11657(FULLNESS, 0).method_11657(FACING, class_2350.field_11043));
  }

  @Override
  protected boolean method_9498(class_2680 state) {
    return true;
  }

  @Override
  protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
    return state.method_11654(FULLNESS);
  }

  @Override
  public void method_9556(
      class_1937 world,
      class_1657 player,
      class_2338 pos,
      class_2680 state,
      @Nullable class_2586 blockEntity,
      class_1799 tool
  ) {
    super.method_9556(world, player, pos, state, blockEntity, tool);
    if (!world.method_8608() && blockEntity instanceof SilkMothNestEntity nestEntity) {
      if (!class_1890.method_60138(
          tool, class_9636.field_51553
      )) {
        nestEntity.tryReleaseMoths(state);
        class_1264.method_66221(state, world, pos);

      }
    }
  }

  public static void dropSilk(class_1937 world, class_2338 pos) {
    method_9577(world, pos, new class_1799(LighterEndItems.SILK, 3));
  }

  @Override
  protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos,
      class_1657 player, class_1268 hand, class_3965 hit) {
    int i = state.method_11654(FULLNESS);
    boolean bl = false;
    if (i >= MAX_FULLNESS) {
      class_1792 item = stack.method_7909();
      if (stack.method_31574(class_1802.field_8868)) {
        world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(),
            LighterEndSounds.MOTH_NEST_SHEAR, class_3419.field_15245, 1.0F, 1.0F);
        dropSilk(world, pos);
        stack.method_7970(1, player, class_1309.method_56079(hand));
        bl = true;
        world.method_33596(player, class_5712.field_28730, pos);
      }

      if (!world.method_8608() && bl) {
        player.method_7259(class_3468.field_15372.method_14956(item));
      }
    }

    if (bl) {

      this.takeSilk(world, state, pos);

      return class_1269.field_5812;
    } else {
      return super.method_55765(stack, state, world, pos, player, hand, hit);
    }
  }

  public void takeSilk(class_1937 world, class_2680 state, class_2338 pos) {
    world.method_8652(pos, state.method_11657(FULLNESS, 0), class_2248.field_31036);
  }

  @Override
  public class_2680 method_9605(class_1750 ctx) {
    return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
  }

  @Override
  protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
    builder.method_11667(FULLNESS, FACING);
  }

  @Nullable
  @Override
  public class_2586 method_10123(class_2338 pos, class_2680 state) {
    return new SilkMothNestEntity(pos, state);
  }

  @Nullable
  @Override
  public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state,
      class_2591<T> type) {
    return world.method_8608() ? null
        : method_31618(
            type,
            LighterEndBlockEntities.SILK_MOTH_NEST,
            SilkMothNestEntity::serverTick
        );
  }

  @Override
  public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
    if (
        world instanceof class_3218 serverWorld
            && player.method_66324()
            && serverWorld.method_64395().method_8355(class_1928.field_19392)
            && world.method_8321(pos) instanceof SilkMothNestEntity nestEntity
    ) {
      int fullness = state.method_11654(FULLNESS);
      boolean occupied = nestEntity.getOccupancy() > 0;
      if (occupied || fullness > 0) {
        class_1799 itemStack = new class_1799(this);
        itemStack.method_57365(nestEntity.method_57590());
        itemStack.method_57379(
            LighterEndData.SILK_LEVEL, new SilkLevelComponent(fullness));
        class_1542 itemEntity = new class_1542(
            world,
            pos.method_10263(),
            pos.method_10264(),
            pos.method_10260(),
            itemStack
        );
        itemEntity.method_6988();
        world.method_8649(itemEntity);
      }
    }

    return super.method_9576(world, pos, state, player);
  }

  @Override
  protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
    class_1297 entity = builder.method_51876(class_181.field_1226);
    if (entity instanceof class_1541
        || entity instanceof class_1548
        || entity instanceof class_1687
        || entity instanceof class_1528
        || entity instanceof class_1701) {
      class_2586 blockEntity = builder.method_51876(class_181.field_1228);
      if (blockEntity instanceof SilkMothNestEntity nestEntity) {
        nestEntity.tryReleaseMoths(state);
      }
    }

    return super.method_9560(state, builder);
  }

  @Override
  protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state,
      boolean includeData) {
    class_1799 itemStack = super.method_9574(world, pos, state, includeData);
    if (includeData) {
      itemStack.method_57379(LighterEndData.SILK_LEVEL, new SilkLevelComponent(state.method_61767(FULLNESS, 0)));
    }

    return itemStack;
  }

  @Override
  protected class_2680 method_9559(
      class_2680 state,
      class_4538 world,
      class_10225 tickView,
      class_2338 pos,
      class_2350 direction,
      class_2338 neighborPos,
      class_2680 neighborState,
      class_5819 random
  ) {
    if (world.method_8320(neighborPos).method_26204() instanceof class_2358 && world.method_8321(
        pos) instanceof SilkMothNestEntity nestEntity) {
      nestEntity.tryReleaseMoths(state);
    }

    return super.method_9559(state, world, tickView, pos, direction, neighborPos,
        neighborState, random);
  }

  @Override
  public class_2680 method_9598(class_2680 state, class_2470 rotation) {
    return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
  }

  @Override
  public class_2680 method_9569(class_2680 state, class_2415 mirror) {
    return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
  }

  @Override
  public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos,
      class_3726 context) {
    return SilkMothNest.OUTLINE_SHAPE;
  }

  public static class SilkMothNestFeature extends class_3031<class_3111> {

    public SilkMothNestFeature() {
      super(class_3111.field_24893);
    }

    private boolean canGenerate(class_5281 world, class_2338 pos) {
      class_2680 state = world.method_8320(pos.method_10084());
      if (state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_15475)) {
        state = world.method_8320(pos);
        if (state.method_26215() && world.method_22347(pos.method_10074())) {
          for (class_2350 dir : class_2353.field_11062) {
            return !world.method_8320(pos.method_10074().method_10093(dir)).method_51366();
          }
        }
      }
      return false;
    }

    @Override
    public boolean method_13151(class_5821<class_3111> generator) {
      final class_2339 POS = GlobalState.stateForThread().POS;
      final class_5819 random = generator.method_33654();
      final class_2338 center = generator.method_33655();
      final class_5281 world = generator.method_33652();
      int maxY = world.method_8624(class_2902.class_2903.field_13202, center.method_10263(), center.method_10260());
      int minY = PosInfo.upRay(world, new class_2338(center.method_10263(), 0, center.method_10260()), maxY);
      POS.method_10101(center);
      for (int y = maxY; y > minY; y--) {
        POS.method_33098(y);
        if (canGenerate(world, POS)) {
          class_2350 dir = class_2353.field_11062.method_10183(random);
          world.method_8652(
              POS,
              LighterEndBlocks.SILK_MOTH_NEST.method_9564()
                  .method_11657(class_2741.field_12481, dir),
              Flags.SILENT
          );
          world.method_35230(POS, LighterEndBlockEntities.SILK_MOTH_NEST).ifPresent(nest ->
              nest.addMoth(SilkMothNestEntity.MothData.create(
                  random.method_43048(SilkMothNestEntity.MIN_OCCUPATION_TICKS))));

          POS.method_33098(y - 1);
          world.method_8652(
              POS,
              LighterEndBlocks.SILK_MOTH_NEST.method_9564()
                  .method_11657(class_2741.field_12481, dir),
              Flags.SILENT
          );
          world.method_35230(POS, LighterEndBlockEntities.SILK_MOTH_NEST).ifPresent(nest ->
              nest.addMoth(SilkMothNestEntity.MothData.create(
                  random.method_43048(SilkMothNestEntity.MIN_OCCUPATION_TICKS))));
          return true;
        }
      }
      return false;
    }
  }
}
