package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.blocks.EndLily;
import io.github.openbagtwo.lighterend.blocks.ShadowBerry;
import io.github.openbagtwo.lighterend.blocks.SilkMothNest;
import io.github.openbagtwo.lighterend.blocks.SulphurCrystal;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndData;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_104;
import net.minecraft.class_141;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_207;
import net.minecraft.class_212;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2482;
import net.minecraft.class_44;
import net.minecraft.class_4488;
import net.minecraft.class_4559;
import net.minecraft.class_4559.class_4560;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.class_8548;
import net.minecraft.class_9317;
import net.minecraft.class_94;

public class BlockLootTableProvider extends FabricBlockLootTableProvider {

  protected BlockLootTableProvider(
      FabricDataOutput dataOutput,
      CompletableFuture<class_7874> registryLookup
  ) {
    super(dataOutput, registryLookup);
  }

  @Override
  public void method_10379() {
    for (List<class_2248> material : Arrays.asList(
        LighterEndBlocks.VIOLECITE.blocks,
        LighterEndBlocks.AZURE_JADESTONE.blocks,
        LighterEndBlocks.SANDY_JADESTONE.blocks,
        LighterEndBlocks.VIRID_JADESTONE.blocks,
        LighterEndBlocks.UMBRALITH.blocks,
        LighterEndBlocks.BORNITE.blocks,
        LighterEndBlocks.TENANEA.blocks,
        LighterEndBlocks.UMBRELLA.blocks,
        LighterEndBlocks.LOTUS.blocks,
        LighterEndBlocks.GLOWSHROOM.blocks,
        LighterEndBlocks.DRAGON.blocks
    )) {
      for (class_2248 block : material) {
        if (block instanceof class_2482) {
          method_45994(block, this::method_45980);
        } else if (block instanceof class_2323) {
          method_45994(block, this::method_46022);
        } else {
          method_46025(block);
        }
      }
    }

    for (class_2248 pot : Arrays.asList(
        LighterEndBlocks.POTTED_TENANEA_SAPLING,
        LighterEndBlocks.POTTED_UMBRELLA_SAPLING,
        LighterEndBlocks.POTTED_GLOWSHROOM_SAPLING
    )) {
      method_46023(pot);
    }

    method_45988(LighterEndBlocks.AURORA_CRYSTAL, auroraCrystalDrops());
    method_46025(LighterEndBlocks.ENDER_BLOCK);

    method_46025(LighterEndBlocks.MISSING_TILE);

    method_46025(LighterEndBlocks.DRAGON_BONE_BLOCK);
    method_46025(LighterEndBlocks.DRAGON_BONE_STAIRS);
    method_45994(LighterEndBlocks.DRAGON_BONE_SLAB, this::method_45980);
    method_45988(LighterEndBlocks.END_MOSS, this.method_45983(LighterEndBlocks.END_MOSS, class_2246.field_10471));

    method_45994(LighterEndBlocks.CREEPING_MOSS, this::method_65053);
    method_45994(LighterEndBlocks.UMBRELLA_FERN, this::method_65053);
    method_46006(LighterEndBlocks.TALL_UMBRELLA_FERN, LighterEndBlocks.UMBRELLA_FERN);
    method_46025(LighterEndBlocks.LUMECORN_SEED);
    method_46006(LighterEndBlocks.LUMECORN_STEM, LighterEndBlocks.LUMECORN_SEED);
    method_45988(LighterEndBlocks.LUMECORN, lumecornEarDrops());

    method_45994(LighterEndBlocks.TENANEA_FLOWER, this::method_65053);
    method_46025(LighterEndBlocks.TENANEA_SAPLING);
    method_45994(LighterEndBlocks.TENANEA_LEAVES,
        (leaves) -> this.method_45986(leaves, LighterEndBlocks.TENANEA_SAPLING,
            0.025F, 0.03125F, 0.041666668F, 0.05F));

    method_45988(LighterEndBlocks.SILK_MOTH_NEST, mothNestDrops());
    method_46025(LighterEndBlocks.UMBRELLA_TREE_CLUSTER);
    method_46025(LighterEndBlocks.UMBRELLA_TREE_CLUSTER_EMPTY);

    method_46025(LighterEndBlocks.UMBRELLA_MEMBRANE);

    method_45994(LighterEndBlocks.CHARNIA_CYAN, this::method_65053);
    method_45994(LighterEndBlocks.CHARNIA_GREEN, this::method_65053);
    method_45994(LighterEndBlocks.CHARNIA_LIGHT_BLUE, this::method_65053);
    method_45994(LighterEndBlocks.CHARNIA_ORANGE, this::method_65053);
    method_45994(LighterEndBlocks.CHARNIA_PURPLE, this::method_65053);
    method_45994(LighterEndBlocks.CHARNIA_RED, this::method_65053);

    method_45988(LighterEndBlocks.END_LILY, endLilyDrops());
    method_45988(LighterEndBlocks.END_LOTUS_FLOWER, lotusFlowerDrops());
    method_46025(LighterEndBlocks.END_LOTUS_STEM);
    method_46006(LighterEndBlocks.END_LOTUS_LEAF, LighterEndItems.END_LILY_LEAF);
    method_46025(LighterEndBlocks.END_LOTUS_SEED);

    method_45994(
        LighterEndBlocks.GLOWSHROOM_FUR,
        (block -> this.method_65053(LighterEndItems.GLOWSHROOM_FUR))
    );
    method_46025(LighterEndBlocks.GLOWSHROOM_CAP);
    method_46025(LighterEndBlocks.GLOWSHROOM_HYMENOPHORE);
    method_46025(LighterEndBlocks.GLOWSHROOM_SAPLING);
    method_46006(LighterEndBlocks.AGAVE, LighterEndBlocks.AGAVE_SEED);
    method_46025(LighterEndBlocks.AGAVE_BULB);
    method_45994(
        LighterEndBlocks.AGAVE_FUR,
        (block -> this.method_65053(LighterEndItems.AGAVE_FUR))
    );
    method_46025(LighterEndBlocks.AURANT_POLYPORE);
    method_46025(LighterEndBlocks.PURPLE_POLYPORE);
    method_45994(LighterEndBlocks.END_FURNACE, this::method_45996);
    method_45994(LighterEndBlocks.END_SMOKER, this::method_45996);

    method_46025(LighterEndBlocks.END_LEVER);

    method_46025(LighterEndBlocks.GOLD_CHANDELIER);
    method_46025(LighterEndBlocks.IRON_CHANDELIER);

    method_46025(LighterEndBlocks.EMERALD_ICE);
    method_46025(LighterEndBlocks.FERROUS_ICE);
    method_46025(LighterEndBlocks.AUROUS_ICE);

    method_45994(LighterEndBlocks.END_STONE_REDSTONE_ORE, this::method_46012);
    method_45994(LighterEndBlocks.UMBRALITH_REDSTONE_ORE, this::method_46012);
    method_45994(LighterEndBlocks.END_STONE_QUARTZ_ORE, block -> this.method_45981(block, class_1802.field_8155));
    method_45994(LighterEndBlocks.UMBRALITH_QUARTZ_ORE, block -> this.method_45981(block, class_1802.field_8155));

    method_46025(LighterEndBlocks.BRIMSTONE);
    method_45988(LighterEndBlocks.SULPHUR_CRYSTAL, sulphurCrystalDrops());
    method_45994(LighterEndBlocks.HYDROTHERMAL_VENT, this::method_46003);

    method_45988(
        LighterEndBlocks.SHADOW_BERRY,
        method_45982(
            LighterEndBlocks.SHADOW_BERRY,
            LighterEndItems.SHADOW_BERRY,
            LighterEndItems.SHADOW_BERRY_SEEDS,
            class_212.method_900(
                    LighterEndBlocks.SHADOW_BERRY)
                .method_22584(class_4560.method_22523().method_22524(ShadowBerry.field_10835, ShadowBerry.field_31079)
                )
        )
    );
    method_45994(LighterEndBlocks.SHADOW_GRASS, this::method_65053);
    method_45994(
        LighterEndBlocks.NEEDLEGRASS,
        block -> this.method_46001(
            block,
            this.method_45977(
                block,
                class_77
                    .method_411(class_1802.field_8600)
                    .method_438(class_141.method_621(class_5662.method_32462(0, 2))
                    )
            )
        )
    );
    method_46025(LighterEndBlocks.MURKWEED);

    method_45994(LighterEndBlocks.DRAGON_LEAVES,
        (leaves) -> this.method_45986(leaves, LighterEndBlocks.DRAGON_SAPLING,
            0.025F, 0.03125F, 0.041666668F, 0.05F));
    method_46025(LighterEndBlocks.DRAGON_SAPLING);
  }

  private class_52.class_53 auroraCrystalDrops() {
    /* Note: It is intentional (for now) that you can essentially dupe Aurora Crystals with a
             Fortune pick. It was present in BetterEnd and is (IMO) a reasonable way for Aurora
             Crystals to be renewable. */
    class_7225.class_7226<class_1887> impl = this.field_51845.method_46762(class_7924.field_41265);
    return this.method_45989(
        LighterEndBlocks.AURORA_CRYSTAL,
        this.method_45977(
            LighterEndBlocks.AURORA_CRYSTAL,
            class_77.method_411(LighterEndItems.AURORA_CRYSTAL_SHARD)
                .method_438(class_141.method_621(class_5662.method_32462(1.0F, 4.0F)))
                .method_438(class_94.method_455(impl.method_46747(class_1893.field_9130)))
        )
    );
  }

  private class_52.class_53 lumecornEarDrops() {
    return class_52.method_324()
        .method_336(
            this.method_45978(
                LighterEndItems.LUMECORN_EAR,
                class_55.method_347().method_352(class_5662.method_32462(1.0F, 2.0F))
                    .method_351(class_77.method_411(LighterEndItems.LUMECORN_EAR))
            )
        );
  }

  private class_52.class_53 mothNestDrops() {
    return class_52.method_324()
        .method_336(
            class_55.method_347()
                .method_356(this.method_60390())
                .method_352(class_44.method_32448(1.0F))
                .method_351(
                    class_77.method_411(LighterEndItems.SILK_MOTH_NEST)
                        .method_438(class_9317.method_57637(
                                class_9317.class_9319.field_49436)
                            .method_58730(LighterEndData.MOTHS
                            ))
                        .method_438(class_4488.method_21892(LighterEndBlocks.SILK_MOTH_NEST)
                            .method_21898(SilkMothNest.FULLNESS))
                )
        );
  }

  public class_52.class_53 endLilyDrops() {
    class_6883<class_1887> fortune = this.field_51845.method_46762(class_7924.field_41265)
        .method_46747(class_1893.field_9130);

    class_5341.class_210 topCondition = class_212.method_900(
        LighterEndBlocks.END_LILY
    ).method_22584(class_4559.class_4560.method_22523().method_22527(EndLily.IS_TOP, true));

    return this.method_45977(
        LighterEndBlocks.END_LILY,
        class_52.method_324().method_336(
            class_55.method_347()
                .method_351(class_77.method_411(
                    LighterEndItems.END_LILY_LEAF).method_421(topCondition)
                ).method_353(
                    class_94.method_463(
                        fortune, 0.5714286F, 3
                    )
                )
        )
    ).method_336(
        class_55.method_347()
            .method_356(topCondition)
            .method_351(class_77.method_411(LighterEndBlocks.END_LILY_SEED).method_438(
                class_94.method_463(
                    fortune, 0.5714286F, 3)))

    );
  }

  private class_52.class_53 lotusFlowerDrops() {
    return class_52.method_324()
        .method_336(
            this.method_45978(
                LighterEndBlocks.END_LOTUS_SEED,
                class_55.method_347().method_352(class_5662.method_32462(1.0F, 2.0F))
                    .method_351(class_77.method_411(LighterEndBlocks.END_LOTUS_SEED))
            )
        );
  }

  private class_52.class_53 sulphurCrystalDrops() {

    class_6883<class_1887> fortune = this.field_51845.method_46762(class_7924.field_41265)
        .method_46747(class_1893.field_9130);

    class_5341.class_210 fullyGrownCondition = class_212.method_900(
        LighterEndBlocks.SULPHUR_CRYSTAL
    ).method_22584(
        class_4559.class_4560.method_22523().method_22524(SulphurCrystal.STAGE, SulphurCrystal.MAX_STAGE)
    );

    return class_52
        .method_324()
        .method_336(
            class_55.method_347()
                .method_356(this.method_60390())
                .method_352(class_44.method_32448(1))
                .method_351(class_77.method_411(LighterEndBlocks.SULPHUR_CRYSTAL)
                    .method_438(class_141
                        .method_621(class_5662.method_32462(1, 3))
                        .method_524(fullyGrownCondition)
                    )
                    .method_438(class_141
                        .method_621(class_44.method_32448(1))
                        .method_524(class_207.method_889(fullyGrownCondition))
                    )
                    .method_438(class_94
                        .method_455(fortune)
                        .method_524(fullyGrownCondition)
                    )
                    .method_438(class_104.method_478())
                )
        )
        .method_336(
            class_55.method_347()
                .method_356(class_8548.method_51723(
                    class_207.method_889(this.method_60390()),
                    fullyGrownCondition))
                .method_352(class_44.method_32448(1))
                .method_351(class_77.method_411(LighterEndItems.CRYSTALLINE_SULPHUR)
                    .method_438(class_141
                        .method_621(class_5662.method_32462(1, 3))
                    )
                    .method_438(class_104.method_478())
                )
        );
  }
}
